/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.entity.AutoCurdlerBlockEntity;
import com.github.alexthe666.rats.server.entity.ai.goal.RatWorkGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.UpdateCurdlerFluidPacket;
import com.github.alexthe666.rats.server.message.UpdateRatFluidPacket;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;

public class RatDepositGoal
extends Goal
implements RatWorkGoal {
    private final TamedRat rat;
    private final DepositType type;
    private BlockPos targetBlock = null;

    public RatDepositGoal(TamedRat entity, DepositType type) {
        this.rat = entity;
        this.type = type;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.rat.canMove()) {
            return false;
        }
        if (!this.rat.getCommand().workCommand) {
            return false;
        }
        if (this.rat.m_5448_() != null) {
            return false;
        }
        if (this.rat.getDepositPos().isEmpty() || !this.rat.getDepositPos().get().m_122640_().equals(this.rat.m_9236_().m_46472_()) || RatUtils.isBlockProtected(this.rat.m_9236_(), this.rat.getDepositPos().get().m_122646_(), this.rat)) {
            return false;
        }
        BlockEntity te = this.rat.m_9236_().m_7702_(this.rat.getDepositPos().get().m_122646_());
        if (te == null) {
            return false;
        }
        if (this.type == DepositType.INVENTORY) {
            if (!this.rat.shouldDepositItem(this.rat.m_21205_())) {
                return false;
            }
            if (this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
                return false;
            }
            if (RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get()) && this.rat.m_21205_().m_41613_() < 64 && !this.getItemsOfTypeAround(this.rat.m_21205_()).isEmpty()) {
                return false;
            }
            if (te.getCapability(ForgeCapabilities.ITEM_HANDLER, this.rat.depositFacing).resolve().isEmpty()) {
                return false;
            }
        } else if (this.type == DepositType.ENERGY) {
            if (this.rat.getRFTransferRate() <= 0 || this.rat.getHeldRF() <= 0) {
                return false;
            }
            if (te.getCapability(ForgeCapabilities.ENERGY, this.rat.depositFacing).resolve().isEmpty()) {
                return false;
            }
        } else if (this.type == DepositType.FLUID) {
            if (this.rat.transportingFluid.isEmpty() || this.rat.transportingFluid.getAmount() == 0) {
                return false;
            }
            if (te.getCapability(ForgeCapabilities.FLUID_HANDLER, this.rat.depositFacing).resolve().isEmpty()) {
                return false;
            }
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private List<ItemEntity> getItemsOfTypeAround(ItemStack stack) {
        return this.rat.m_9236_().m_6443_(ItemEntity.class, this.rat.m_20191_().m_82400_((double)this.rat.getRadius()), item -> {
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)item.m_32055_())) {
                return false;
            }
            Path path = this.rat.m_21573_().m_6570_((Entity)item, 1);
            return path != null && path.m_77403_();
        });
    }

    private void resetTarget() {
        this.targetBlock = this.rat.getDepositPos().get().m_122646_();
    }

    public boolean m_8045_() {
        if (RatUpgradeUtils.hasUpgrade(this.rat, (Item)RatsItemRegistry.RAT_UPGRADE_PLATTER.get()) && this.rat.m_21205_().m_41613_() < 64 && this.getItemsOfTypeAround(this.rat.m_21205_()).isEmpty()) {
            return false;
        }
        return this.targetBlock != null && !this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_() && this.rat.shouldDepositItem(this.rat.m_21205_());
    }

    public void m_8056_() {
        this.rat.isCurrentlyWorking = true;
    }

    public void m_8041_() {
        this.rat.isCurrentlyWorking = false;
    }

    private Vec3 getMovePos() {
        return Vec3.m_82539_((Vec3i)this.targetBlock.m_121945_(this.rat.depositFacing));
    }

    public void m_8037_() {
        BlockEntity te = this.rat.m_9236_().m_7702_(this.targetBlock);
        if (this.targetBlock != null && te != null) {
            Container container;
            this.rat.m_21573_().m_26519_(this.getMovePos().m_7096_(), this.getMovePos().m_7098_(), this.getMovePos().m_7094_(), 1.25);
            double distance = Math.sqrt(this.rat.m_20275_(this.getMovePos().m_7096_(), this.getMovePos().m_7098_(), this.getMovePos().m_7094_()));
            if (distance < 4.5 * this.rat.getRatDistanceModifier() && distance > 2.5 * this.rat.getRatDistanceModifier() && te instanceof Container) {
                container = (Container)te;
                this.toggleChest(container, true);
            }
            if (distance <= 2.0 * this.rat.getRatDistanceModifier()) {
                if (te instanceof Container) {
                    container = (Container)te;
                    this.toggleChest(container, false);
                }
                this.executeTask(te);
                this.targetBlock = null;
                this.m_8041_();
            }
        }
    }

    public void toggleChest(Container te, boolean open) {
        if (te instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)te;
            if (open) {
                this.rat.m_9236_().m_7696_(this.targetBlock, chest.m_58900_().m_60734_(), 1, 1);
            } else {
                this.rat.m_9236_().m_7696_(this.targetBlock, chest.m_58900_().m_60734_(), 1, 0);
            }
            this.rat.m_9236_().m_142346_((Entity)this.rat, open ? GameEvent.f_157796_ : GameEvent.f_157793_, chest.m_58899_());
        }
    }

    private void executeTask(BlockEntity entity) {
        if (this.type == DepositType.INVENTORY) {
            ItemStack duplicate;
            IItemHandler resolvedHandler;
            LazyOptional handler = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, this.rat.depositFacing);
            if (handler.resolve().isPresent() && !ItemHandlerHelper.insertItem((IItemHandler)(resolvedHandler = (IItemHandler)handler.resolve().get()), (ItemStack)(duplicate = this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41777_()), (boolean)true).equals(duplicate)) {
                ItemStack shrunkenStack = ItemHandlerHelper.insertItem((IItemHandler)resolvedHandler, (ItemStack)duplicate, (boolean)false);
                if (shrunkenStack.m_41619_()) {
                    this.rat.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                } else {
                    this.rat.m_21008_(InteractionHand.MAIN_HAND, shrunkenStack);
                }
            }
        } else if (this.type == DepositType.ENERGY) {
            LazyOptional handler = entity.getCapability(ForgeCapabilities.ENERGY, this.rat.depositFacing);
            if (handler.resolve().isPresent()) {
                IEnergyStorage storage = (IEnergyStorage)handler.resolve().get();
                int howMuchWeHave = this.rat.getHeldRF();
                int inputtedEnergy = 0;
                try {
                    if (storage.canReceive() && storage.receiveEnergy(howMuchWeHave, true) > 0) {
                        inputtedEnergy = storage.receiveEnergy(howMuchWeHave, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inputtedEnergy > 0) {
                    this.rat.setHeldRF(Math.max(0, this.rat.getHeldRF() - inputtedEnergy));
                }
            }
        } else if (this.type == DepositType.FLUID) {
            FluidStack copiedFluid = this.rat.transportingFluid.copy();
            LazyOptional handler = entity.getCapability(ForgeCapabilities.FLUID_HANDLER, this.rat.depositFacing);
            if (handler.resolve().isPresent()) {
                IFluidHandler fluidHandler = (IFluidHandler)handler.resolve().get();
                if (!this.rat.transportingFluid.isEmpty()) {
                    int minusAmount = 0;
                    try {
                        if (fluidHandler.getTanks() > 0) {
                            FluidStack firstTank = fluidHandler.getFluidInTank(0);
                            if (fluidHandler.getTanks() > 1) {
                                for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                                    FluidStack otherTank = fluidHandler.getFluidInTank(i);
                                    if (copiedFluid == null || !copiedFluid.isFluidEqual(otherTank)) continue;
                                    firstTank = otherTank;
                                }
                            }
                            if ((firstTank.isEmpty() || copiedFluid == null || copiedFluid.isFluidEqual(firstTank)) && fluidHandler.fill(copiedFluid, IFluidHandler.FluidAction.SIMULATE) != 0) {
                                minusAmount = fluidHandler.fill(copiedFluid, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                    }
                    catch (Exception firstTank) {
                        // empty catch block
                    }
                    if (minusAmount > 0) {
                        int total = copiedFluid.getAmount() - minusAmount;
                        if (total <= 0) {
                            this.rat.transportingFluid = FluidStack.EMPTY;
                        } else {
                            this.rat.transportingFluid.setAmount(total);
                        }
                        if (!this.rat.m_9236_().m_5776_()) {
                            RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateRatFluidPacket(this.rat.m_19879_(), this.rat.transportingFluid));
                            BlockEntity blockEntity = this.rat.m_9236_().m_7702_(this.targetBlock);
                            if (blockEntity instanceof AutoCurdlerBlockEntity) {
                                AutoCurdlerBlockEntity curdler = (AutoCurdlerBlockEntity)blockEntity;
                                RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateCurdlerFluidPacket(this.targetBlock.m_121878_(), curdler.getTank().getFluid()));
                            }
                        }
                        SoundEvent sound = this.rat.transportingFluid.isEmpty() ? SoundEvents.f_11778_ : SoundEvents.f_11781_;
                        this.rat.m_5496_(sound, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    @Override
    public RatWorkGoal.TaskType getRatTaskType() {
        return RatWorkGoal.TaskType.DEPOSIT;
    }

    public static enum DepositType {
        INVENTORY,
        FLUID,
        ENERGY;

    }
}

