/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.block.RatCageBlock;
import com.github.alexthe666.rats.server.block.RatCageWheelBlock;
import com.github.alexthe666.rats.server.block.entity.DecoratedRatCageBlockEntity;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUpgradeUtils;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;

public class RatCageWheelBlockEntity
extends DecoratedRatCageBlockEntity {
    public int useTicks = 0;
    public float rotationSpeed = 1.0f;
    private TamedRat wheeler;
    private int dismountCooldown = 0;
    private final EnergyStorage energyStorage = new EnergyStorage(1000, 10, 10, 0);
    private final LazyOptional<EnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);

    public RatCageWheelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.RAT_CAGE_WHEEL.get(), pos, state);
    }

    @Override
    public ItemStack getContainedItem() {
        return new ItemStack((ItemLike)RatsItemRegistry.RAT_WHEEL.get());
    }

    @Override
    public void setContainedItem(ItemStack stack) {
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        compound.m_128405_("UseTicks", this.useTicks);
        compound.m_128365_("Energy", this.energyStorage.serializeNBT());
        compound.m_128405_("DismountCooldown", this.dismountCooldown);
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.useTicks = compound.m_128451_("UseTicks");
        this.dismountCooldown = compound.m_128451_("DismountCooldown");
        if (compound.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(compound.m_128423_("Energy"));
        }
    }

    public void removeWheeler() {
        if (this.wheeler != null) {
            this.wheeler.setInWheel(false);
            this.wheeler = null;
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RatCageWheelBlockEntity te) {
        block7: {
            block8: {
                if (te.dismountCooldown > 0) {
                    --te.dismountCooldown;
                }
                if (te.wheeler != null) break block8;
                te.useTicks = 0;
                if (te.dismountCooldown > 0) break block7;
                for (TamedRat rat : level.m_45976_(TamedRat.class, new AABB(pos))) {
                    if (!rat.m_21824_()) continue;
                    te.wheeler = rat;
                    te.wheeler.setInWheel(true);
                    te.rotationSpeed = RatUpgradeUtils.hasUpgrade(rat, (Item)RatsItemRegistry.RAT_UPGRADE_SPEED.get()) ? 2.0f : 1.0f;
                    break block7;
                }
                break block7;
            }
            ++te.useTicks;
            te.sendEnergy(level, pos);
            if (!level.m_5776_()) {
                Direction facing = Direction.NORTH;
                if (state.m_60713_((Block)RatsBlockRegistry.RAT_CAGE_WHEEL.get())) {
                    facing = (Direction)state.m_61143_((Property)RatCageWheelBlock.FACING);
                }
                te.wheeler.f_19859_ = facing.m_122435_();
                te.wheeler.m_146922_(te.wheeler.f_19859_);
                te.wheeler.f_20885_ = te.wheeler.f_20886_ = te.wheeler.m_146908_();
                te.wheeler.f_20883_ = te.wheeler.f_20884_ = te.wheeler.m_146908_();
                int nrg = Mth.m_14167_((float)(10.0f * te.rotationSpeed));
                if (te.energyStorage.receiveEnergy(nrg, true) != 0) {
                    te.energyStorage.receiveEnergy(nrg, false);
                }
                if (te.useTicks > 200 && te.useTicks % 100 == 0 && level.m_213780_().m_188501_() > 0.25f) {
                    for (Direction direction : Direction.values()) {
                        if (RatCageBlock.runConnectionLogic(level.m_8055_(pos.m_121945_(direction))) != 1 || te.wheeler == null) continue;
                        te.wheeler.m_6034_((float)pos.m_121945_(direction).m_123341_() + 0.5f, (float)pos.m_121945_(direction).m_123342_() + 0.5f, (float)pos.m_121945_(direction).m_123343_() + 0.5f);
                        te.removeWheeler();
                        te.dismountCooldown = 1200 + level.m_213780_().m_188503_(1200);
                    }
                }
            }
        }
    }

    private void sendEnergy(Level level, BlockPos pos) {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        for (int i = 0; i < Direction.values().length && capacity.get() > 0; ++i) {
            BlockEntity blockEntity;
            Direction facing = Direction.values()[i];
            if (facing.equals((Object)Direction.UP) || (blockEntity = level.m_7702_(pos.m_121945_(facing))) == null) continue;
            blockEntity.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).ifPresent(handler -> {
                if (handler.canReceive()) {
                    int received = handler.receiveEnergy(Math.min(capacity.get(), 10), false);
                    capacity.addAndGet(-received);
                    this.energyStorage.extractEnergy(received, false);
                    this.m_6596_();
                }
            });
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.energyCap.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == ForgeCapabilities.ENERGY ? this.energyCap.cast() : super.getCapability(capability, facing);
    }
}

