/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.server.block.entity.RatHoleBlockEntity;
import com.github.alexthe666.rats.server.entity.rat.DiggingRat;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RatHoleBlock
extends BaseEntityBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NS_LEFT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0);
    private static final VoxelShape NS_RIGHT_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape EW_LEFT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final VoxelShape EW_RIGHT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape NORTH_CORNER_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape EAST_CORNER_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final VoxelShape SOUTH_CORNER_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0);
    private static final VoxelShape WEST_CORNER_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private VoxelShape shape;

    public RatHoleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shape = Shapes.m_83113_((VoxelShape)TOP_AABB, (VoxelShape)NORTH_CORNER_AABB, (BooleanOp)BooleanOp.f_82695_).m_83296_();
        this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)SOUTH_CORNER_AABB, (BooleanOp)BooleanOp.f_82695_).m_83296_();
        this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)EAST_CORNER_AABB, (BooleanOp)BooleanOp.f_82695_).m_83296_();
        this.shape = Shapes.m_83113_((VoxelShape)this.shape, (VoxelShape)WEST_CORNER_AABB, (BooleanOp)BooleanOp.f_82695_).m_83296_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        return context instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)context).m_193113_() instanceof DiggingRat ? TOP_AABB : super.m_5939_(state, getter, pos, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        BlockState northState = level.m_8055_(blockpos.m_122012_());
        BlockState eastState = level.m_8055_(blockpos.m_122029_());
        BlockState southState = level.m_8055_(blockpos.m_122019_());
        BlockState westState = level.m_8055_(blockpos.m_122024_());
        return (BlockState)((BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.shouldFaceHaveHole(northState, northState.m_60783_((BlockGetter)level, blockpos.m_122012_(), Direction.SOUTH))))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.shouldFaceHaveHole(eastState, eastState.m_60783_((BlockGetter)level, blockpos.m_122029_(), Direction.WEST))))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.shouldFaceHaveHole(southState, southState.m_60783_((BlockGetter)level, blockpos.m_122019_(), Direction.NORTH))))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.shouldFaceHaveHole(westState, westState.m_60783_((BlockGetter)level, blockpos.m_122024_(), Direction.EAST))));
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity entity = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_);
        if (entity instanceof RatHoleBlockEntity) {
            RatHoleBlockEntity hole = (RatHoleBlockEntity)entity;
            return hole.getImitatedBlockState().m_287290_(builder);
        }
        return super.m_49635_(state, builder);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape shape1 = this.shape;
        if (state.m_60734_() instanceof RatHoleBlock) {
            if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)EW_LEFT_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)EW_RIGHT_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)NS_LEFT_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
            if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
                shape1 = Shapes.m_83113_((VoxelShape)shape1, (VoxelShape)NS_RIGHT_AABB, (BooleanOp)BooleanOp.f_82695_);
            }
        }
        return shape1;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, WEST, SOUTH});
    }

    private boolean shouldFaceHaveHole(BlockState state, boolean occluding) {
        return occluding || state.m_60734_() == this;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RatHoleBlockEntity(pos, state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty connect;
        switch (facing) {
            case NORTH: {
                BooleanProperty booleanProperty = NORTH;
                break;
            }
            case SOUTH: {
                BooleanProperty booleanProperty = SOUTH;
                break;
            }
            case EAST: {
                BooleanProperty booleanProperty = EAST;
                break;
            }
            case WEST: {
                BooleanProperty booleanProperty = WEST;
                break;
            }
            default: {
                BooleanProperty booleanProperty = connect = null;
            }
        }
        if (connect == null) {
            return state;
        }
        return (BlockState)state.m_61124_((Property)connect, (Comparable)Boolean.valueOf(this.shouldFaceHaveHole(facingState, facingState.m_60783_((BlockGetter)level, facingPos, facing.m_122424_()))));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof RatHoleBlockEntity) {
            RatHoleBlockEntity hole = (RatHoleBlockEntity)blockEntity;
            return new ItemStack((ItemLike)hole.getImitatedBlockState().m_60734_());
        }
        return new ItemStack((ItemLike)Blocks.f_50705_);
    }
}

