/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.block.CustomItemRarity;
import com.github.alexthe666.rats.server.entity.monster.boss.RatBaron;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;

public class AirRaidSirenBlock
extends Block
implements CustomItemRarity {
    private static final VoxelShape AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public AirRaidSirenBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Rarity getRarity() {
        return Rarity.RARE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return this.spawnTheBaron(level, pos) ? InteractionResult.m_19078_((boolean)level.m_5776_()) : InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag = level.m_276867_(pos);
        if (flag) {
            this.spawnTheBaron(level, pos);
        }
    }

    private boolean spawnTheBaron(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return true;
        }
        if (level.m_6436_(pos).m_19048_() != Difficulty.PEACEFUL) {
            level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.AIR_RAID_SIREN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            if (RatConfig.summonBaronOnlyInRatlantis && !level.m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
                for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0))) {
                    player.m_5661_((Component)Component.m_237115_((String)"entity.rats.rat_baron.ratlantis"), true);
                }
                return true;
            }
            LightningBolt bolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
            assert (bolt != null);
            bolt.m_146884_(Vec3.m_82512_((Vec3i)pos));
            bolt.m_20874_(true);
            level.m_7967_((Entity)bolt);
            level.m_46597_(pos, Blocks.f_50132_.m_49966_());
            RatBaron baron = new RatBaron((EntityType<? extends AbstractRat>)((EntityType)RatlantisEntityRegistry.RAT_BARON.get()), level);
            baron.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 5.0, (double)pos.m_123343_() + 0.5);
            ForgeEventFactory.onFinalizeSpawn((Mob)baron, (ServerLevelAccessor)((ServerLevelAccessor)level), (DifficultyInstance)level.m_6436_(pos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
            baron.m_21446_(pos, 16);
            if (level.m_46469_().m_46207_(GameRules.f_46136_)) {
                for (int i = 0; i < 2; ++i) {
                    RandomSource rand = level.m_213780_();
                    level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 3.0, (double)(pos.m_123342_() - 1), (double)pos.m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 3.0, new ItemStack((ItemLike)Items.f_42416_)));
                }
            }
            return level.m_7967_((Entity)baron);
        }
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }
}

