/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry.worldgen;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisPlacedFeatureRegistry;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;

public class RatlantisBiomeRegistry {
    public static final ResourceKey<Biome> RATLANTIS = RatlantisBiomeRegistry.makeKey("ratlantis");

    private static ResourceKey<Biome> makeKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("rats", name));
    }

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter features = context.m_255420_(Registries.f_256988_);
        HolderGetter carvers = context.m_255420_(Registries.f_257003_);
        context.m_255272_(RATLANTIS, (Object)new Biome.BiomeBuilder().m_264558_(true).m_47611_(0.5f).m_47609_(0.55f).m_47605_(new MobSpawnSettings.Builder().m_48368_(0.4f).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)RatlantisEntityRegistry.FERAL_RATLANTEAN.get(), 20, 1, 3)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)RatlantisEntityRegistry.PIRAT.get(), 50, 1, 2)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)RatlantisEntityRegistry.RATLANTEAN_SPIRIT.get(), 15, 1, 1)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)RatlantisEntityRegistry.RATLANTEAN_RATBOT.get(), 5, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 40, 1, 2)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20507_, 14, 1, 2)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20516_, 15, 1, 3)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)RatlantisEntityRegistry.RATFISH.get(), 45, 8, 8)).m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20559_, 2, 1, 2)).m_48376_(RatsMod.RATS, new MobSpawnSettings.SpawnerData((EntityType)RatsEntityRegistry.RAT.get(), 10, 2, 4)).m_48381_()).m_47601_(new BiomeGenerationSettings.Builder(features, carvers).m_255308_(GenerationStep.Carving.AIR, RatlantisDimensionRegistry.RATLANTIS_CAVES).m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.f_195276_).m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, MiscOverworldPlacements.f_195274_).m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, RatlantisPlacedFeatureRegistry.SMALL_RUINS).m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, RatlantisPlacedFeatureRegistry.LARGE_RUINS).m_255155_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, CavePlacements.f_195235_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195323_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195324_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195325_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195327_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195329_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195332_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195335_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195339_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195340_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195304_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195306_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MiscOverworldPlacements.f_195270_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MiscOverworldPlacements.f_195268_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, MiscOverworldPlacements.f_195269_).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RatlantisPlacedFeatureRegistry.CHEESE_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RatlantisPlacedFeatureRegistry.GEM_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, RatlantisPlacedFeatureRegistry.ORATCHALCUM_ORE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RatlantisPlacedFeatureRegistry.RATGLOVE_FLOWERS).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, RatlantisPlacedFeatureRegistry.MARBLE_PILE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195469_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195426_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195444_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195414_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195458_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195406_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195407_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195403_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195448_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195463_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195230_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195218_).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195227_).m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, MiscOverworldPlacements.f_195271_).m_255380_()).m_47603_(new BiomeSpecialEffects.Builder().m_48027_(new AmbientMoodSettings((Holder)SoundEvents.f_11689_, 6000, 8, 2.0)).m_48040_(16762410).m_48043_(2546944).m_48045_(8177920).m_48019_(16767615).m_48034_(4445678).m_48037_(270131).m_48018_()).m_47592_());
    }

    public static BiomeSource buildBiomeSource(HolderGetter<Biome> biomes) {
        return MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList((List)ImmutableList.of((Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(RATLANTIS)))));
    }
}

