/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.registry;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import sfiomn.legendarycreatures.blocks.DoomFireBlock;
import sfiomn.legendarycreatures.registry.ItemRegistry;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"legendarycreatures");
    public static final RegistryObject<Block> DOOM_FIRE_BLOCK = BLOCKS.register("doom_fire", () -> new DoomFireBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283869_).m_60910_().m_60966_().m_60953_(p_235468_0_ -> 15).m_60918_(SoundType.f_56745_)));

    private static <T extends Block> RegistryObject<Block> registerBlock(String name, Supplier<T> block) {
        RegistryObject newBlock = BLOCKS.register(name, block);
        BlockRegistry.registerBlockItem(name, newBlock);
        return newBlock;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ItemRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

