/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities.goals;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.MoveToTargetGoal;

public class RangedMeleeAttackGoal
extends MoveToTargetGoal {
    protected final int attackDuration;
    private final int actionPoint;
    private final int goalCoolDown;
    private final double minDistance;
    private final double maxDistance;
    protected int attackAnimationTick;
    private long lastUseTime;
    private boolean hasAttacked;

    public RangedMeleeAttackGoal(AnimatedCreatureEntity mob, int attackDuration, int hurtTick, int goalCoolDown, double minDistanceAttack, double maxDistanceAttack, double speedModifier, boolean followingEvenIfNotSeen) {
        super(mob, speedModifier, followingEvenIfNotSeen);
        this.attackDuration = (int)Math.ceil((double)attackDuration / 2.0);
        this.actionPoint = hurtTick / 2;
        this.goalCoolDown = goalCoolDown;
        this.minDistance = minDistanceAttack;
        this.maxDistance = maxDistanceAttack;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean isAttacking() {
        return this.mob.getAttackAnimation() == this.getAnimationId();
    }

    @Override
    public boolean m_8036_() {
        long time = this.mob.m_9236_().m_46467_();
        if (time - this.lastUseTime < (long)this.goalCoolDown || this.isAttacking()) {
            return false;
        }
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (this.mob.m_21574_().m_148306_((Entity)target) && this.mob.m_20280_((Entity)target) > this.getMinAttackReachSqr(target)) {
            return super.m_8036_();
        }
        return false;
    }

    @Override
    public boolean m_8045_() {
        boolean canContinueToUse = super.m_8045_();
        if (canContinueToUse) {
            return !this.hasAttacked && this.mob.m_20280_((Entity)Objects.requireNonNull(this.mob.m_5448_())) > this.getMinAttackReachSqr(this.mob.m_5448_());
        }
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
        this.attackAnimationTick = 0;
        this.hasAttacked = false;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.lastUseTime = this.mob.m_9236_().m_46467_();
        if (this.isAttacking()) {
            this.stopAttack();
        }
        this.mob.m_21561_(false);
    }

    @Override
    public void m_8037_() {
        LivingEntity target;
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if ((target = this.mob.m_5448_()) != null) {
            if (!this.isAttacking()) {
                super.m_8037_();
            } else {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
            }
            double distToTargetSqr = this.mob.m_20280_((Entity)target);
            if (!this.isAttacking() && !this.hasAttacked && distToTargetSqr <= this.getAttackReachSqr(target) - 1.0) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_20182_());
                this.startAttack(target);
            }
            if (this.attackAnimationTick == 0 && this.isAttacking()) {
                this.stopAttack();
            }
            if (this.isActionPoint()) {
                this.executeAttack(target);
            }
        }
    }

    protected int getAnimationId() {
        return 7;
    }

    protected void startAttack(LivingEntity target) {
        this.mob.setAttackAnimation(this.getAnimationId());
        this.attackAnimationTick = this.attackDuration;
    }

    protected void stopAttack() {
        this.hasAttacked = true;
        this.mob.setAttackAnimation(0);
    }

    protected boolean executeAttack(LivingEntity target) {
        return this.mob.m_7327_((Entity)target);
    }

    protected boolean isActionPoint() {
        return this.attackAnimationTick == this.attackDuration - this.actionPoint;
    }

    protected double getMinAttackReachSqr(LivingEntity entity) {
        return this.minDistance * this.minDistance;
    }

    @Override
    protected double getAttackReachSqr(LivingEntity entity) {
        return this.maxDistance * this.maxDistance + (double)entity.m_20205_();
    }
}

