/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities.goals;

import java.util.EnumSet;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.MoveToTargetGoal;

public class PoisonMeleeAttackGoal
extends MoveToTargetGoal {
    protected final int poisonDuration;
    protected final int poisonStrength;
    private final int attackDuration;
    private final int actionPoint;
    private final int attackCoolDown;
    private final int goalCoolDown;
    private int attackAnimationTick;
    private long lastUseTime;
    private int ticksUntilNextAttack;
    protected boolean isPoisonApplied;
    protected final int tentative;
    protected int tentativeCount;

    public PoisonMeleeAttackGoal(AnimatedCreatureEntity mob, int poisonDuration, int poisonStrength, int tentative, int attackDuration, int hurtTick, int attackCoolDown, double speedModifier, boolean followingEvenIfNotSeen, int goalCoolDown) {
        super(mob, speedModifier, followingEvenIfNotSeen);
        this.poisonDuration = poisonDuration;
        this.poisonStrength = poisonStrength;
        this.attackDuration = (int)Math.ceil((double)attackDuration / 2.0);
        this.actionPoint = hurtTick / 2;
        this.attackCoolDown = (int)Math.ceil((double)attackCoolDown / 2.0);
        this.tentative = tentative;
        this.goalCoolDown = goalCoolDown;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean isAttacking() {
        return this.mob.getAttackAnimation() == 5;
    }

    @Override
    public boolean m_8036_() {
        long time = this.mob.m_9236_().m_46467_();
        if (time - this.lastUseTime < (long)this.goalCoolDown || this.isAttacking()) {
            return false;
        }
        LivingEntity target = this.mob.m_5448_();
        if (!super.m_8036_()) {
            return false;
        }
        assert (target != null);
        return !target.m_21023_(MobEffects.f_19614_);
    }

    @Override
    public boolean m_8045_() {
        if (super.m_8045_()) {
            return !this.isPoisonApplied && this.tentativeCount < this.tentative;
        }
        return false;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
        this.attackAnimationTick = 0;
        this.isPoisonApplied = false;
        this.ticksUntilNextAttack = 0;
        this.tentativeCount = 0;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.lastUseTime = this.mob.m_9236_().m_46467_();
        if (this.isAttacking()) {
            this.stopAttack();
        }
        this.mob.m_21561_(false);
    }

    @Override
    public void m_8037_() {
        LivingEntity target;
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.ticksUntilNextAttack > 0) {
            --this.ticksUntilNextAttack;
        }
        if ((target = this.mob.m_5448_()) != null) {
            this.mob.m_21563_().m_24964_(target.m_20182_());
            super.m_8037_();
            double distToTargetSqr = this.mob.m_20280_((Entity)target);
            if (this.ticksUntilNextAttack == 0 && this.getAttackReachSqr(target) >= distToTargetSqr && !this.isAttacking()) {
                this.startAttack();
            }
            if (this.attackAnimationTick == 0 && this.isAttacking()) {
                this.stopAttack();
            }
            if (this.isActionPoint()) {
                this.executeAttack(target);
            }
        }
    }

    protected void startAttack() {
        this.mob.setAttackAnimation(5);
        this.attackAnimationTick = this.attackDuration;
    }

    protected void stopAttack() {
        this.mob.setAttackAnimation(0);
        this.ticksUntilNextAttack = this.attackCoolDown;
    }

    protected void executeAttack(LivingEntity target) {
        if (target != null && this.mob.m_7327_((Entity)target)) {
            this.applyPoison(target);
            ++this.tentativeCount;
        }
    }

    protected void applyPoison(LivingEntity target) {
        target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, this.poisonDuration, this.poisonStrength, false, true));
        this.isPoisonApplied = target.m_21023_(MobEffects.f_19614_);
    }

    protected boolean isActionPoint() {
        return this.attackAnimationTick == this.attackDuration - this.actionPoint;
    }

    @Override
    protected double getAttackReachSqr(LivingEntity entity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + entity.m_20205_();
    }
}

