/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities.goals;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;

public abstract class MoveToTargetGoal
extends Goal {
    protected final AnimatedCreatureEntity mob;
    protected final double speedModifier;
    protected final boolean followingEvenIfNotSeen;
    protected int ticksUntilNextPathRecalculation;

    public MoveToTargetGoal(AnimatedCreatureEntity mob, double speedModifier, boolean followingEvenIfNotSeen) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.followingEvenIfNotSeen = followingEvenIfNotSeen;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        Path path = this.mob.m_21573_().m_6570_((Entity)target, 0);
        if (path != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.mob.m_20280_((Entity)target) && this.mob.m_21574_().m_148306_((Entity)target);
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.followingEvenIfNotSeen) {
            return !this.mob.m_21573_().m_26571_();
        }
        return true;
    }

    public void m_8056_() {
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            double distToTargetSqr = this.mob.m_20280_((Entity)target);
            if ((this.followingEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)target)) && --this.ticksUntilNextPathRecalculation <= 0) {
                this.ticksUntilNextPathRecalculation = 2 + this.mob.m_217043_().m_188503_(4);
                if (!this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                if (distToTargetSqr > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distToTargetSqr > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
            }
        }
    }

    protected abstract double getAttackReachSqr(LivingEntity var1);
}

