/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.config.json;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import sfiomn.legendarycreatures.LegendaryCreatures;
import sfiomn.legendarycreatures.api.entities.MobEntityEnum;
import sfiomn.legendarycreatures.config.SpawnInfo;
import sfiomn.legendarycreatures.config.json.JsonChanceSpawn;
import sfiomn.legendarycreatures.config.json.JsonSpawnInfo;

public class JsonConfig {
    public static Map<String, SpawnInfo> mobIdSpawnList = new HashMap<String, SpawnInfo>();
    public static Map<String, JsonSpawnInfo> jsonMobIdSpawnList = new HashMap<String, JsonSpawnInfo>();

    public static void registerMobId(String mobId) {
        mobIdSpawnList.put(mobId, new SpawnInfo());
        jsonMobIdSpawnList.put(mobId, new JsonSpawnInfo());
    }

    public static void registerBreakingBlockNameSpawn(String mobId, String registryName, double chance) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        if (!JsonConfig.mobIdSpawnList.get((Object)mobId).breakingBlockNameSpawns.containsKey(registryName) && mobEntityEnum.canSpawnByBreaking()) {
            JsonConfig.mobIdSpawnList.get((Object)mobId).breakingBlockNameSpawns.put(registryName, new JsonChanceSpawn(chance));
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).breakingBlockNameSpawns.put(registryName, new JsonChanceSpawn(chance));
        }
    }

    public static void registerBreakingBlockTagSpawn(String mobId, String registryName, double chance) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        TagKey blockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(registryName));
        if (!JsonConfig.mobIdSpawnList.get((Object)mobId).breakingBlockTagSpawns.containsKey(blockTag) && mobEntityEnum.canSpawnByBreaking()) {
            JsonConfig.mobIdSpawnList.get((Object)mobId).breakingBlockTagSpawns.put((TagKey<Block>)blockTag, new JsonChanceSpawn(chance));
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).breakingBlockTagSpawns.put(registryName, new JsonChanceSpawn(chance));
        }
    }

    public static void registerKillingEntityNameSpawn(String mobId, String registryName, double chance) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        if (!JsonConfig.mobIdSpawnList.get((Object)mobId).killingEntityNameSpawns.containsKey(registryName) && mobEntityEnum.canSpawnByKilling()) {
            JsonConfig.mobIdSpawnList.get((Object)mobId).killingEntityNameSpawns.put(registryName, new JsonChanceSpawn(chance));
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).killingEntityNameSpawns.put(registryName, new JsonChanceSpawn(chance));
        }
    }

    public static void registerKillingEntityTagSpawn(String mobId, String registryName, double chance) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        TagKey entityTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(registryName));
        if (!JsonConfig.mobIdSpawnList.get((Object)mobId).killingEntityTypeTagSpawns.containsKey(entityTag) && mobEntityEnum.canSpawnByKilling()) {
            JsonConfig.mobIdSpawnList.get((Object)mobId).killingEntityTypeTagSpawns.put(entityTag, new JsonChanceSpawn(chance));
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).killingEntityTypeTagSpawns.put(registryName, new JsonChanceSpawn(chance));
        }
    }

    public static void registerBreakingBlockNameBlackList(String mobId, List<String> registryNames) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        if (mobEntityEnum.canSpawnByBreaking()) {
            JsonConfig.mobIdSpawnList.get((Object)mobId).blackLists.breakingBlockNames.addAll(registryNames);
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).blackLists.breakingBlockNames.addAll(registryNames);
        }
    }

    public static void registerBreakingBlockTagBlackList(String mobId, List<String> registryNames) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        if (mobEntityEnum.canSpawnByBreaking()) {
            for (String registryName : registryNames) {
                JsonConfig.mobIdSpawnList.get((Object)mobId).blackLists.breakingBlockTags.add((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(registryName)));
            }
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).blackLists.breakingBlockTags.addAll(registryNames);
        }
    }

    public static void registerKillingEntityNameBlackList(String mobId, List<String> registryNames) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        if (mobEntityEnum.canSpawnByKilling()) {
            JsonConfig.mobIdSpawnList.get((Object)mobId).blackLists.killingEntityNames.addAll(registryNames);
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).blackLists.killingEntityNames.addAll(registryNames);
        }
    }

    public static void registerKillingEntityTagBlackList(String mobId, List<String> registryNames) {
        if (!JsonConfig.isMobIdValid(mobId)) {
            return;
        }
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        assert (mobEntityEnum != null);
        if (mobEntityEnum.canSpawnByKilling()) {
            for (String registryName : registryNames) {
                JsonConfig.mobIdSpawnList.get((Object)mobId).blackLists.killingEntityTypeTags.add(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(registryName)));
            }
            JsonConfig.jsonMobIdSpawnList.get((Object)mobId).blackLists.killingEntityTypeTags.addAll(registryNames);
        }
    }

    private static boolean isMobIdValid(String mobId) {
        MobEntityEnum mobEntityEnum = MobEntityEnum.valueOfMobId(mobId);
        if (mobEntityEnum == null) {
            LegendaryCreatures.LOGGER.debug("Error - MobId " + mobId + " not present in MobEntityEnum.");
            return false;
        }
        if (!mobIdSpawnList.containsKey(mobId)) {
            LegendaryCreatures.LOGGER.debug("Error - MobId " + mobId + " not present in JsonConfig mobIdSpawnList, use registerMobId method in JsonRegistration.");
            return false;
        }
        return true;
    }
}

