/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.mob.update_3;

import com.ninni.species.mixin_util.WolfAccess;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesParticles;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.registry.SpeciesStatusEffects;
import com.ninni.species.registry.SpeciesTags;
import com.ninni.species.registry.SpeciesVillagerTypes;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.ai.goal.BewereagerAttackGoal;
import com.ninni.species.server.entity.ai.goal.CelebrateWithVillagersGoal;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class Bewereager
extends Monster
implements OwnableEntity {
    public static final EntityDataAccessor<Integer> HOWL_COOLDOWN = SynchedEntityData.m_135353_(Bewereager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ATTACK_SPEED = SynchedEntityData.m_135353_(Bewereager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(Bewereager.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> FROM_WOLF = SynchedEntityData.m_135353_(Bewereager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SPLITTING_ID = SynchedEntityData.m_135353_(Bewereager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(Bewereager.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public final AnimationState howlAnimationState = new AnimationState();
    public final AnimationState biteAttackAnimationState = new AnimationState();
    public final AnimationState slashAttackAnimationState = new AnimationState();
    public final AnimationState shakeAnimationState = new AnimationState();
    public final AnimationState splitAnimationState = new AnimationState();
    public final AnimationState stunAnimationState = new AnimationState();
    public final AnimationState jumpAnimationState = new AnimationState();
    public int bewereagerSplittingTime;
    private int howlTime;
    private int stunTime;
    private int jumpTime;
    public int splitTime;
    public int shakeTime;
    public int attackCooldown;
    public boolean isWet;

    public Bewereager(EntityType<? extends Monster> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> livingEntity.m_6095_().m_204039_(SpeciesTags.ATTACKED_BY_BEWEREAGER) && !this.isSplitting()));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, !this.isSplitting()));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true, !this.isSplitting()));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new BewereagerAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new TransformDuringFullMoonGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new CelebrateWithVillagersGoal((Mob)this, (SoundEvent)SpeciesSoundEvents.BEWEREAGER_CELEBRATE.get(), true));
        this.f_21345_.m_25352_(1, (Goal)new HowlGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new JumpTowardsTargetGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_(Attributes.f_22279_, 0.23);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isSplitting()) {
            int i = this.getSplittingProgress();
            this.bewereagerSplittingTime -= i;
            if (this.bewereagerSplittingTime == 0 && this.isSplitting() && this.m_20089_() != SpeciesPose.SPLITTING.get()) {
                this.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_SPLIT.get(), 1.0f, 1.0f);
                this.m_20124_(SpeciesPose.SPLITTING.get());
            }
        }
        if (this.getHowlCooldown() > 0) {
            this.setHowlCooldown(this.getHowlCooldown() - 1);
        }
        if (this.m_5448_() == null && this.getAttackSpeed() != 0) {
            this.setAttackSpeed(0);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.attackCooldown == 0 && (this.m_20089_() == SpeciesPose.SLASH_ATTACK.get() || this.m_20089_() == SpeciesPose.ATTACK.get())) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.stunTime > 0) {
            --this.stunTime;
        }
        if (this.stunTime == 0 && this.m_20089_() == SpeciesPose.STUN.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.jumpTime > 0) {
            --this.jumpTime;
        }
        if (this.jumpTime == 0 && this.m_20089_() == Pose.LONG_JUMPING) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.splitTime > 0) {
            --this.splitTime;
        }
        if (this.splitTime == 1) {
            this.split();
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20208_(1.8), this.m_20187_(), this.m_20262_(1.8), 0.0, 0.0, 0.0);
        }
        if (this.shakeTime == 0 && this.m_20089_() == SpeciesPose.SHAKING.get()) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.getAttackSpeed() > 0) {
            float amount = 1.0f - (6.0f - (float)this.getAttackSpeed()) / 6.0f;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.f_19796_.m_188501_() < amount) {
                    int i = 0;
                    while ((float)i < amount * 3.0f) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.BEWEREAGER_SPEED.get()), this.m_20208_(0.35), this.m_20227_(0.35) + (double)this.f_19796_.m_188501_(), this.m_20262_(0.35), 1, 0.3, 0.3, 0.3, 1.0);
                        ++i;
                    }
                }
            }
        }
        if (this.howlTime > 0) {
            --this.howlTime;
            if (this.howlTime < 60 && this.howlTime > 20) {
                float angle = (float)Math.PI / 180 * this.f_20883_;
                double headX = 1.0f * this.m_6134_() * Mth.m_14031_((float)((float)Math.PI + angle));
                double headZ = 1.0f * this.m_6134_() * Mth.m_14089_((float)angle);
                if (this.howlTime % 8 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)SpeciesParticles.BEWEREAGER_HOWL.get(), this.m_20185_() + headX, this.m_20186_() + 2.25, this.m_20189_() + headZ, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.howlTime == 0 && this.m_20089_() == Pose.ROARING) {
            this.m_20124_(Pose.STANDING);
        }
        if (this.howlTime == 1 && !this.m_21023_(MobEffects.f_19600_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300));
            this.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_HOWL_STRENGTH.get(), 4.0f, 1.0f);
            this.setHowlCooldown(600);
        }
        if (!this.isWet && this.m_20071_()) {
            this.isWet = true;
        }
        if (this.m_9236_().f_46443_) {
            if (this.attackCooldown == 0 && (this.biteAttackAnimationState.m_216984_() || this.slashAttackAnimationState.m_216984_())) {
                this.biteAttackAnimationState.m_216973_();
                this.slashAttackAnimationState.m_216973_();
            }
            if (this.howlTime == 0 && this.howlAnimationState.m_216984_()) {
                this.howlAnimationState.m_216973_();
            }
            if (this.stunTime == 0 && this.stunAnimationState.m_216984_()) {
                this.stunAnimationState.m_216973_();
            }
            if (this.jumpTime == 0 && this.jumpAnimationState.m_216984_()) {
                this.jumpAnimationState.m_216973_();
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.isWet && this.m_20089_() == Pose.STANDING && !this.m_20071_() && !this.m_21691_() && !this.m_9236_().m_46471_() && this.m_20096_()) {
            this.m_20124_(SpeciesPose.SHAKING.get());
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        ListTag listtag = new BannerPattern.Builder().m_222705_(BannerPatterns.f_222751_, DyeColor.CYAN).m_222705_(BannerPatterns.f_222731_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222735_, DyeColor.GRAY).m_222705_(BannerPatterns.f_222715_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222736_, DyeColor.BLACK).m_222705_(BannerPatterns.f_222712_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222750_, DyeColor.LIGHT_GRAY).m_222705_(BannerPatterns.f_222715_, DyeColor.BLACK).m_58587_();
        if (this.getFromWolf() && this.m_269323_() != null && this.m_269323_().m_7306_((Entity)player) && itemstack.m_150930_(Items.f_42660_) && BlockItem.m_186336_((ItemStack)itemstack).m_128441_("Patterns") && BlockItem.m_186336_((ItemStack)itemstack).m_128423_("Patterns").equals(listtag)) {
            if (this.m_21023_(MobEffects.f_19597_) || this.m_21023_((MobEffect)SpeciesStatusEffects.STUCK.get())) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.startSplitting(this.f_19796_.m_188503_(401) + 400);
                }
                this.m_216990_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_TRANSFORM_START.get());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        if (this.howlTime > 0) {
            this.howlTime = 0;
            this.m_20124_(Pose.STANDING);
            this.setHowlCooldown(600);
        }
        return super.m_6469_(damageSource, v);
    }

    public boolean m_7327_(Entity entity) {
        if (entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_))) {
            if (this.getAttackSpeed() == 6) {
                this.m_20124_(SpeciesPose.STUN.get());
                this.m_216990_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_STUN.get());
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 20; ++i) {
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)SpeciesParticles.BEWEREAGER_SLOW.get()), this.m_20185_() + this.f_19796_.m_188583_() * 0.5, this.m_20227_(1.0) + (double)this.f_19796_.m_188501_(), this.m_20189_() + this.f_19796_.m_188583_() * 0.5, 1, 0.3, 0.3, 0.3, 1.0);
                    }
                }
            } else {
                this.setAttackSpeed(this.getAttackSpeed() + 1);
            }
        }
        return super.m_7327_(entity);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOWL_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(ATTACK_SPEED, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(FROM_WOLF, (Object)false);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
        this.f_19804_.m_135372_(DATA_SPLITTING_ID, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("HowlCooldown", this.getHowlCooldown());
        nbt.m_128405_("AttackSpeed", this.getAttackSpeed());
        nbt.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        nbt.m_128379_("FromWolf", this.getFromWolf());
        if (this.m_21805_() != null) {
            nbt.m_128362_("Owner", this.m_21805_());
        }
        nbt.m_128405_("SplittingTime", this.isSplitting() ? this.bewereagerSplittingTime : -1);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setHowlCooldown(nbt.m_128451_("HowlCooldown"));
        this.setAttackSpeed(nbt.m_128451_("AttackSpeed"));
        if (nbt.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)nbt.m_128451_("CollarColor")));
        }
        this.setFromWolf(nbt.m_128471_("FromWolf"));
        if (nbt.m_128403_("Owner")) {
            this.setOwnerUUID(nbt.m_128342_("Owner"));
        }
        if (nbt.m_128425_("SplittingTime", 99) && nbt.m_128451_("SplittingTime") > -1) {
            this.startSplitting(nbt.m_128451_("SplittingTime"));
        }
    }

    public int getAttackSpeed() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_SPEED);
    }

    public void setAttackSpeed(int speed) {
        this.f_19804_.m_135381_(ATTACK_SPEED, (Object)speed);
    }

    public int getHowlCooldown() {
        return (Integer)this.f_19804_.m_135370_(HOWL_COOLDOWN);
    }

    public void setHowlCooldown(int cooldown) {
        this.f_19804_.m_135381_(HOWL_COOLDOWN, (Object)cooldown);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    public boolean getFromWolf() {
        return (Boolean)this.f_19804_.m_135370_(FROM_WOLF);
    }

    public void setFromWolf(boolean fromWolf) {
        this.f_19804_.m_135381_(FROM_WOLF, (Object)fromWolf);
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(uuid));
    }

    public boolean isSplitting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_SPLITTING_ID);
    }

    private void startSplitting(int i) {
        this.bewereagerSplittingTime = i;
        this.m_20088_().m_135381_(DATA_SPLITTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19597_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, i, 2));
    }

    private int getSplittingProgress() {
        int i = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int j = 0;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k = (int)this.m_20185_() - 4; k < (int)this.m_20185_() + 4 && j < 14; ++k) {
                for (int l = (int)this.m_20186_() - 4; l < (int)this.m_20186_() + 4 && j < 14; ++l) {
                    for (int i1 = (int)this.m_20189_() - 4; i1 < (int)this.m_20189_() + 4 && j < 14; ++i1) {
                        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos.m_122178_(k, l, i1));
                        if (!blockstate.m_60713_(Blocks.f_50183_) && !(blockstate.m_60734_() instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
        }
        return i;
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.m_20089_() == Pose.ROARING || this.m_20089_() == SpeciesPose.STUN.get() || this.m_20089_() == SpeciesPose.SPLITTING.get();
    }

    protected int m_5639_(float v, float v1) {
        return super.m_5639_(v, v1) - 10;
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor)) {
            if (this.m_20089_() == Pose.ROARING) {
                this.howlAnimationState.m_216977_(this.f_19797_);
                this.howlTime = 70;
            } else if (this.m_20089_() == SpeciesPose.STUN.get()) {
                this.stunAnimationState.m_216977_(this.f_19797_);
                this.setAttackSpeed(0);
                this.stunTime = 70;
            } else if (this.m_20089_() == SpeciesPose.ATTACK.get()) {
                this.attackCooldown = 5;
                this.biteAttackAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.SLASH_ATTACK.get()) {
                this.attackCooldown = 15;
                this.slashAttackAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == Pose.LONG_JUMPING) {
                this.jumpTime = 20;
                this.jumpAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.SPLITTING.get()) {
                this.splitTime = 45;
                this.splitAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == SpeciesPose.SHAKING.get()) {
                this.shakeTime = 25;
                this.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_SHAKE.get(), this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_146850_(GameEvent.f_223710_);
                this.shakeAnimationState.m_216977_(this.f_19797_);
            } else if (this.m_20089_() == Pose.STANDING) {
                this.howlAnimationState.m_216973_();
                this.stunAnimationState.m_216973_();
                this.biteAttackAnimationState.m_216973_();
                this.slashAttackAnimationState.m_216973_();
                this.jumpAnimationState.m_216973_();
                this.shakeAnimationState.m_216973_();
                if (this.isWet) {
                    this.isWet = false;
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public void transform() {
        if (this.getFromWolf()) {
            this.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_TRANSFORM.get(), 1.0f, 1.0f);
            Wolf wolf = (Wolf)this.m_21406_(EntityType.f_20499_, false);
            wolf.m_30397_(this.getCollarColor());
            if (this.m_21805_() != null) {
                wolf.m_21816_(this.m_21805_());
                wolf.m_7105_(true);
                wolf.m_21839_(true);
            }
            if (wolf instanceof WolfAccess) {
                WolfAccess wolfAccess = (WolfAccess)wolf;
                wolfAccess.setIsBewereager(true);
            }
            this.addTransformingParticles();
            this.m_9236_().m_7967_((Entity)wolf);
        }
    }

    public void split() {
        if (this.getFromWolf()) {
            Villager villager = (Villager)EntityType.f_20492_.m_20615_(this.m_9236_());
            villager.m_34375_(villager.m_7141_().m_35567_((VillagerType)SpeciesVillagerTypes.CURED_BEWEREAGER.get()).m_35565_(VillagerProfession.f_35585_));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.m_21805_() != null) {
                    serverLevel.m_8670_(ReputationEventType.f_26985_, (Entity)this.m_269323_(), (ReputationEventHandler)villager);
                }
                villager.m_35483_(serverLevel);
            }
            if ((level = this.m_269323_()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)level;
                SpeciesCriterion.CURE_BEWEREAGER.trigger(serverPlayer);
            }
            if (this.m_8077_()) {
                villager.m_6593_(this.m_7770_());
            }
            villager.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            villager.m_146926_(this.m_146909_());
            villager.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 0));
            this.m_9236_().m_7967_((Entity)villager);
            Wolf wolf = (Wolf)this.m_21406_(EntityType.f_20499_, false);
            wolf.m_30397_(this.getCollarColor());
            if (this.m_21805_() != null) {
                wolf.m_21816_(this.m_21805_());
                wolf.m_7105_(true);
            }
            if (wolf instanceof WolfAccess) {
                WolfAccess wolfAccess = (WolfAccess)wolf;
                wolfAccess.setIsBewereager(false);
                wolfAccess.setIsCuredBewereager(true);
            }
            this.addTransformingParticles();
            this.m_9236_().m_7967_((Entity)wolf);
            float v = 0.35f;
            Vec3 vec3 = new Vec3((double)v, (double)v, (double)v);
            Vec3 vec32 = new Vec3((double)(-v), (double)v, (double)(-v));
            villager.m_246865_(vec3);
            wolf.m_246865_(vec32);
        }
    }

    public void addTransformingParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20227_(0.6), this.m_20189_(), 1, 0.3, 0.3, 0.3, 1.0);
        }
    }

    protected boolean m_8028_() {
        return super.m_8028_() && !this.getFromWolf();
    }

    public boolean m_6785_(double p_21542_) {
        return !this.getFromWolf();
    }

    protected void m_7472_(DamageSource p_34697_, int p_34698_, boolean p_34699_) {
        Creeper creeper;
        super.m_7472_(p_34697_, p_34698_, p_34699_);
        Entity entity = p_34697_.m_7639_();
        if (entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            ItemStack itemstack = new ItemStack((ItemLike)SpeciesItems.BEWEREAGER_HEAD.get());
            creeper.m_32314_();
            this.m_19983_(itemstack);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SpeciesSoundEvents.BEWEREAGER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SpeciesSoundEvents.BEWEREAGER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.BEWEREAGER_DEATH.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_STEP.get(), 0.15f, this.m_6100_());
    }

    public static boolean m_219013_(EntityType<? extends Monster> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return pos.m_123342_() > 60 && levelAccessor.m_45517_(LightLayer.SKY, pos) > 0 && levelAccessor.m_6018_().m_46462_() && levelAccessor.m_46940_() > 0.9f && levelAccessor.m_46791_() != Difficulty.PEACEFUL && Bewereager.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)randomSource) && Bewereager.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)randomSource);
    }

    public static class TransformDuringFullMoonGoal
    extends Goal {
        protected final Bewereager bewereager;

        public TransformDuringFullMoonGoal(Bewereager bewereager) {
            this.bewereager = bewereager;
        }

        public boolean m_8036_() {
            if (!this.bewereager.getFromWolf() || this.bewereager.isSplitting() || this.bewereager.m_20089_() != Pose.STANDING) {
                return false;
            }
            return !this.bewereager.m_20069_() && !this.bewereager.m_9236_().m_46462_() && this.bewereager.m_20096_() && !this.bewereager.m_21023_(MobEffects.f_19597_);
        }

        public void m_8056_() {
            this.bewereager.transform();
        }
    }

    public static class HowlGoal
    extends Goal {
        protected final Bewereager mob;

        public HowlGoal(Bewereager mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.getHowlCooldown() == 0 && !this.mob.m_21023_(MobEffects.f_19600_) && this.mob.m_20089_() == Pose.STANDING && this.mob.m_20096_() && !this.mob.isSplitting();
        }

        public void m_8056_() {
            this.mob.m_20124_(Pose.ROARING);
            this.mob.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_HOWL.get(), 4.0f, 1.0f);
        }
    }

    public static class JumpTowardsTargetGoal
    extends Goal {
        protected final Bewereager mob;

        public JumpTowardsTargetGoal(Bewereager mob) {
            this.mob = mob;
        }

        public boolean m_8036_() {
            return this.mob.m_5448_() != null && this.mob.m_20280_((Entity)this.mob.m_5448_()) > 100.0 && this.mob.m_20096_() && this.mob.m_20089_() == Pose.STANDING && !this.mob.isSplitting() && !this.mob.m_21023_((MobEffect)SpeciesStatusEffects.STUCK.get()) && !this.mob.m_21023_(MobEffects.f_19597_);
        }

        public void m_8056_() {
            if (this.mob.m_5448_() != null) {
                this.mob.m_20124_(Pose.LONG_JUMPING);
                this.mob.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_JUMP.get(), 3.0f, this.mob.m_6100_());
                Vec3 direction = new Vec3(this.mob.m_5448_().m_20185_() - this.mob.m_20185_(), this.mob.m_5448_().m_20186_() - this.mob.m_20186_(), this.mob.m_5448_().m_20189_() - this.mob.m_20189_()).m_82541_().m_82490_(2.0);
                this.mob.m_20256_(new Vec3(direction.f_82479_, 0.5, direction.f_82481_));
                this.mob.m_21573_().m_26573_();
            }
        }

        public boolean m_8045_() {
            return !this.mob.m_20096_() && !this.mob.isSplitting();
        }

        public void m_8041_() {
            this.mob.m_216990_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_LAND.get());
        }
    }
}

