/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.entity.ai.goal;

import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.entity.mob.update_3.Bewereager;
import com.ninni.species.server.entity.util.SpeciesPose;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class BewereagerAttackGoal
extends Goal {
    protected final Bewereager bewereager;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;

    public BewereagerAttackGoal(Bewereager bewereager) {
        this.bewereager = bewereager;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.bewereager.m_5448_();
        if (livingEntity == null || !livingEntity.m_6084_() || this.bewereager.m_20089_() == Pose.ROARING || this.bewereager.isSplitting()) {
            return false;
        }
        this.path = this.bewereager.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(livingEntity) >= this.bewereager.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.bewereager.m_5448_();
        if (livingentity == null || this.bewereager.isSplitting()) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.bewereager.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.bewereager.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void m_8041_() {
        LivingEntity livingentity = this.bewereager.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.bewereager.m_6710_(null);
        }
        this.bewereager.m_21561_(false);
        this.bewereager.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.bewereager.m_5448_();
        if (livingEntity != null) {
            this.bewereager.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            double distanceToTarget = this.bewereager.m_262793_(livingEntity);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.bewereager.m_21574_().m_148306_((Entity)livingEntity) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 0.0 || this.bewereager.m_217043_().m_188501_() < 0.05f)) {
                this.pathedTargetX = livingEntity.m_20185_();
                this.pathedTargetY = livingEntity.m_20186_();
                this.pathedTargetZ = livingEntity.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.bewereager.m_217043_().m_188503_(7);
                if (distanceToTarget > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distanceToTarget > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.bewereager.m_21573_().m_5624_((Entity)livingEntity, 1.4)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            this.checkAndPerformAttack(livingEntity, distanceToTarget);
            this.path = this.bewereager.m_21573_().m_6570_((Entity)livingEntity, 0);
            if (this.getAttackReachSqr(livingEntity) > 0.0) {
                this.bewereager.m_21573_().m_26536_(this.path, 1.4);
            }
        }
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity, double distanceToTarget) {
        if (distanceToTarget <= this.getAttackReachSqr(livingEntity) && this.bewereager.attackCooldown == 0 && this.bewereager.m_20089_() == Pose.STANDING) {
            if (this.bewereager.getAttackSpeed() >= 3) {
                this.bewereager.m_20124_(SpeciesPose.ATTACK.get());
                this.bewereager.m_216990_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_BITE.get());
            } else {
                this.bewereager.m_20124_(SpeciesPose.SLASH_ATTACK.get());
                this.bewereager.m_216990_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_SLASH.get());
            }
            this.bewereager.m_5496_((SoundEvent)SpeciesSoundEvents.BEWEREAGER_SPEED.get(), 1.0f, 0.7f + (float)this.bewereager.getAttackSpeed() * 0.2f);
            this.bewereager.m_6674_(InteractionHand.MAIN_HAND);
            this.bewereager.m_7327_((Entity)livingEntity);
        }
    }

    protected double getAttackReachSqr(LivingEntity livingEntity) {
        return this.bewereager.m_20205_() * 2.0f * this.bewereager.m_20205_() * 2.0f + livingEntity.m_20205_();
    }
}

