/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.server.data.CruncherPelletManager;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CruncherPelletBlockEntity
extends BlockEntity {
    @Nullable
    private CruncherPelletManager.CruncherPelletData data = null;
    private static final Logger LOGGER = LogUtils.getLogger();

    public CruncherPelletBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)SpeciesBlockEntities.CRUNCHER_PELLET.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        if (compoundTag.m_128425_("PelletData", 10)) {
            CruncherPelletManager.CruncherPelletData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128469_("PelletData"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setPelletData);
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (this.getPelletData() != null) {
            CruncherPelletManager.CruncherPelletData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getPelletData()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_("PelletData", tag));
        }
    }

    public CruncherPelletManager.CruncherPelletData getPelletData() {
        return this.data;
    }

    public void setPelletData(CruncherPelletManager.CruncherPelletData data) {
        this.data = data;
    }

    public void unpackLootTable(Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.f_58857_.m_7654_() == null) {
            return;
        }
        CruncherPelletManager.CruncherPelletData pelletData = this.getPelletData();
        if (pelletData == null) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10563_.m_54597_(serverPlayer, pelletData.entityType().m_20677_());
        }
        int count = UniformInt.m_146622_((int)pelletData.minTries(), (int)pelletData.maxTries()).m_214085_(player.m_217043_());
        for (int i = 0; i < count; ++i) {
            ObjectArrayList<ItemStack> randomDrops = this.getRandomDrops(player);
            randomDrops.forEach(this::spawnItem);
        }
        this.m_6596_();
    }

    private void spawnItem(ItemStack itemStack) {
        Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)itemStack);
    }

    public ObjectArrayList<ItemStack> getRandomDrops(Player player) {
        DamageSource damageSource;
        CruncherPelletManager.CruncherPelletData data = this.getPelletData();
        ResourceLocation resourceLocation = data.entityType().m_20677_();
        LootTable lootTable = this.f_58857_.m_7654_().m_278653_().m_278676_(resourceLocation);
        Entity entity = data.entityType().m_20615_(this.f_58857_);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            damageSource = this.f_58857_.m_269111_().m_269333_(livingEntity);
        } else {
            damageSource = this.f_58857_.m_269111_().m_269341_();
        }
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.f_58857_).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_)).m_287289_(LootContextParams.f_81458_, (Object)player).m_287289_(LootContextParams.f_81459_, (Object)player).m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_());
        LootParams lootParams = builder.m_287235_(LootContextParamSets.f_81415_);
        return lootTable.m_287195_(lootParams);
    }
}

