/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesEntities;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.criterion.SpeciesCriterion;
import com.ninni.species.server.entity.mob.update_1.Wraptor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WraptorEggBlock
extends Block
implements SimpleWaterloggedBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty HATCH = BlockStateProperties.f_61416_;

    public WraptorEggBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HATCH, (Comparable)Integer.valueOf(0)));
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        FallingBlockEntity fallingBlockEntity;
        if (entity instanceof FallingBlockEntity && (fallingBlockEntity = (FallingBlockEntity)entity).m_31980_().m_60734_() instanceof AnvilBlock && fallDistance > 4.0f) {
            this.breakEgg(world, pos, state);
        }
        super.m_142072_(world, state, pos, entity, fallDistance);
    }

    private void breakEgg(Level world, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)HATCH);
        if (i < 2) {
            world.m_5594_(null, pos, (SoundEvent)SpeciesSoundEvents.WRAPTOR_EGG_CRACK.get(), SoundSource.BLOCKS, 1.5f, 1.5f + world.f_46441_.m_188501_() * 0.2f);
            world.m_7731_(pos, (BlockState)this.m_49966_().m_61124_((Property)HATCH, (Comparable)Integer.valueOf(i + 1)), 2);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        } else {
            world.m_5594_(null, pos, (SoundEvent)SpeciesSoundEvents.WRAPTOR_EGG_HATCH.get(), SoundSource.BLOCKS, 1.5f, 1.5f + world.f_46441_.m_188501_() * 0.2f);
            world.m_7471_(pos, false);
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            Wraptor wraptor = (Wraptor)((EntityType)SpeciesEntities.WRAPTOR.get()).m_20615_(world);
            assert (wraptor != null);
            wraptor.m_146762_(-24000);
            wraptor.setBormFromEgg(true);
            wraptor.m_21530_();
            wraptor.m_7678_((double)pos.m_123341_() + 0.3, pos.m_123342_(), (double)pos.m_123343_() + 0.3, 0.0f, 0.0f);
            world.m_7967_((Entity)wraptor);
            Player player = wraptor.m_9236_().m_45930_((Entity)wraptor, 16.0);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SpeciesCriterion.HATCH_WRAPTOR.trigger(serverPlayer);
            }
        }
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return !levelReader.m_46859_(blockPos.m_7495_());
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HATCH, WATERLOGGED});
    }
}

