/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesBlocks;
import com.ninni.species.server.block.entity.MobHeadBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MobHeadBlock
extends BaseEntityBlock
implements Equipable {
    public static final int MAX = RotationSegment.m_247348_();
    private final Type type;
    private static final int ROTATIONS = MAX + 1;
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    protected static final VoxelShape GHOUL_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    protected static final VoxelShape WICKED_SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    protected static final VoxelShape QUAKE_SHAPE = Block.m_49796_((double)1.5, (double)0.0, (double)1.5, (double)14.5, (double)7.0, (double)14.5);
    protected static final VoxelShape BEWEREAGER_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);

    public MobHeadBlock(Type type, BlockBehaviour.Properties properties) {
        super(properties);
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState p_56331_, BlockGetter p_56332_, BlockPos p_56333_, CollisionContext p_56334_) {
        if (this.getType() == Types.WICKED) {
            return WICKED_SHAPE;
        }
        if (this.getType() == Types.GHOUL) {
            return GHOUL_SHAPE;
        }
        if (this.getType() == Types.BEWEREAGER) {
            return BEWEREAGER_SHAPE;
        }
        return QUAKE_SHAPE;
    }

    public VoxelShape m_7952_(BlockState p_56336_, BlockGetter p_56337_, BlockPos p_56338_) {
        return Shapes.m_83040_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.m_246374_((float)context.m_7074_())));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{ROTATION});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level p_151992_, BlockState p_151993_, BlockEntityType<T> p_151994_) {
        if (p_151992_.f_46443_) {
            boolean flag;
            boolean bl = flag = p_151993_.m_60713_((Block)SpeciesBlocks.GHOUL_HEAD.get()) || p_151993_.m_60713_((Block)SpeciesBlocks.GHOUL_WALL_HEAD.get()) || p_151993_.m_60713_((Block)SpeciesBlocks.BEWEREAGER_HEAD.get()) || p_151993_.m_60713_((Block)SpeciesBlocks.BEWEREAGER_WALL_HEAD.get());
            if (flag) {
                return MobHeadBlock.m_152132_(p_151994_, (BlockEntityType)((BlockEntityType)SpeciesBlockEntities.MOB_HEAD.get()), MobHeadBlockEntity::animation);
            }
        }
        return null;
    }

    public Type getType() {
        return this.type;
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType computationType) {
        return false;
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MobHeadBlockEntity(pos, state);
    }

    public static interface Type {
    }

    public static enum Types implements Type
    {
        WICKED,
        QUAKE,
        BEWEREAGER,
        GHOUL;

    }
}

