/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.server.block;

import com.ninni.species.registry.SpeciesBlockEntities;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesSoundEvents;
import com.ninni.species.server.block.entity.BirtDwellingBlockEntity;
import com.ninni.species.server.block.property.SpeciesProperties;
import com.ninni.species.server.entity.mob.update_1.Birt;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BirtDwellingBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty BIRTS = SpeciesProperties.BIRTS;
    public static final IntegerProperty EGGS = SpeciesProperties.EGGS;

    public BirtDwellingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)BIRTS, (Comparable)Integer.valueOf(0))).m_61124_((Property)EGGS, (Comparable)Integer.valueOf(0)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if ((Integer)state.m_61143_((Property)EGGS) > 0 && player.m_21120_(hand).m_41619_()) {
            BlockEntity blockEntity;
            if (!world.m_5776_() && (blockEntity = world.m_7702_(pos)) instanceof BirtDwellingBlockEntity) {
                BirtDwellingBlockEntity birtDwellingBlockEntity = (BirtDwellingBlockEntity)blockEntity;
                birtDwellingBlockEntity.angerBirts(player, state, BirtDwellingBlockEntity.BirtState.EMERGENCY);
            }
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)EGGS) - 1)));
            BlockPos itemPos = pos.m_121945_((Direction)state.m_61143_((Property)FACING));
            world.m_5594_(null, itemPos, (SoundEvent)SpeciesSoundEvents.BLOCK_BIRT_DWELLING_COLLECT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            BirtDwellingBlock.m_49840_((Level)world, (BlockPos)itemPos, (ItemStack)new ItemStack((ItemLike)SpeciesItems.BIRT_EGG.get()));
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, blockHitResult);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, blockPos, blockState, blockEntity, itemStack);
        if (!level.f_46443_ && blockEntity instanceof BirtDwellingBlockEntity) {
            BirtDwellingBlockEntity birtDwellingBlockEntity = (BirtDwellingBlockEntity)blockEntity;
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)itemStack) == 0) {
                birtDwellingBlockEntity.angerBirts(player, blockState, BirtDwellingBlockEntity.BirtState.EMERGENCY);
                level.m_46717_(blockPos, (Block)this);
                this.angerNearbyBirts(level, blockPos);
            }
        }
    }

    private void angerNearbyBirts(Level world, BlockPos pos) {
        List playerList = world.m_45976_(Player.class, new AABB(pos).m_82377_(8.0, 6.0, 8.0));
        if (playerList.isEmpty()) {
            return;
        }
        List birtList = world.m_45976_(Birt.class, new AABB(pos).m_82377_(8.0, 6.0, 8.0));
        if (!birtList.isEmpty()) {
            for (Birt birt : birtList) {
                if (birt.m_5448_() != null) continue;
                birt.m_6710_((LivingEntity)playerList.get(world.f_46441_.m_188503_(playerList.size())));
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_8125_().m_122424_())).m_61124_((Property)EGGS, (Comparable)((Integer)this.m_49966_().m_61143_((Property)EGGS)))).m_61124_((Property)BIRTS, (Comparable)((Integer)this.m_49966_().m_61143_((Property)BIRTS)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, BIRTS, EGGS});
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new BirtDwellingBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BirtDwellingBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)SpeciesBlockEntities.BIRT_DWELLING.get()), BirtDwellingBlockEntity::serverTick);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState blockState, Player player) {
        BlockEntity blockEntity;
        if (!world.m_5776_() && player.m_7500_() && world.m_46469_().m_46207_(GameRules.f_46136_) && (blockEntity = world.m_7702_(pos)) instanceof BirtDwellingBlockEntity) {
            boolean bl;
            BirtDwellingBlockEntity blockEntity1 = (BirtDwellingBlockEntity)blockEntity;
            ItemStack itemStack = new ItemStack((ItemLike)this);
            boolean bl2 = bl = !blockEntity1.hasNoBirts();
            if (bl) {
                CompoundTag nbtCompound = new CompoundTag();
                nbtCompound.m_128365_("Birts", (Tag)blockEntity1.getBirts());
                BlockItem.m_186338_((ItemStack)itemStack, (BlockEntityType)((BlockEntityType)SpeciesBlockEntities.BIRT_DWELLING.get()), (CompoundTag)nbtCompound);
                nbtCompound = new CompoundTag();
                itemStack.m_41700_("BlockStateTag", (Tag)nbtCompound);
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), itemStack);
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(world, pos, blockState, player);
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        BlockEntity blockEntity;
        Entity entity = (Entity)builder.m_287159_(LootContextParams.f_81455_);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_)) instanceof BirtDwellingBlockEntity) {
            BirtDwellingBlockEntity blockEntity1 = (BirtDwellingBlockEntity)blockEntity;
            blockEntity1.angerBirts(null, blockState, BirtDwellingBlockEntity.BirtState.EMERGENCY);
        }
        return super.m_49635_(blockState, builder);
    }
}

