/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.client.model.mob.update_1.DeepfishModel;
import com.ninni.species.server.entity.mob.update_1.Deepfish;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeepfishFeatureRenderer<T extends Deepfish, M extends DeepfishModel<T>>
extends RenderLayer<T, M> {
    private final ResourceLocation texture;
    private final AnimationAngleAdjuster<T> animationAngleAdjuster;
    private final ModelPartVisibility<T, M> modelPartVisibility;

    public DeepfishFeatureRenderer(RenderLayerParent<T, M> context, ResourceLocation texture, AnimationAngleAdjuster<T> animationAngleAdjuster, ModelPartVisibility<T, M> modelPartVisibility) {
        super(context);
        this.texture = texture;
        this.animationAngleAdjuster = animationAngleAdjuster;
        this.modelPartVisibility = modelPartVisibility;
    }

    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T fish, float f, float g, float h, float j, float k, float l) {
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_234338_((ResourceLocation)this.texture));
        if (fish.m_20145_()) {
            return;
        }
        this.updateModelPartVisibility();
        ((DeepfishModel)this.m_117386_()).m_7695_(matrixStack, vertexConsumer, i, LivingEntityRenderer.m_115338_(fish, (float)0.0f), 1.0f, 1.0f, 1.0f, this.animationAngleAdjuster.apply(fish, h, j));
        this.unhideAllModelParts();
    }

    private void updateModelPartVisibility() {
        List<ModelPart> list = this.modelPartVisibility.getPartsToDraw((DeepfishModel)this.m_117386_());
        ((DeepfishModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> {
            part.f_233556_ = true;
        });
        list.forEach(part -> {
            part.f_233556_ = false;
        });
    }

    private void unhideAllModelParts() {
        ((DeepfishModel)this.m_117386_()).m_142109_().m_171331_().forEach(part -> {
            part.f_233556_ = false;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface AnimationAngleAdjuster<T extends Deepfish> {
        public float apply(T var1, float var2, float var3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface ModelPartVisibility<T extends Deepfish, M extends EntityModel<T>> {
        public List<ModelPart> getPartsToDraw(M var1);
    }
}

