/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.ninni.species.client.model.mob.update_3.LeafHangerModel;
import com.ninni.species.client.renderer.entity.HangerRenderer;
import com.ninni.species.registry.SpeciesEntityModelLayers;
import com.ninni.species.server.entity.mob.update_3.LeafHanger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class LeafHangerRenderer
extends HangerRenderer<LeafHanger, LeafHangerModel<LeafHanger>> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("species", "textures/entity/hanger/leaf_hanger.png");
    public static final ResourceLocation TEXTURE_RARE = new ResourceLocation("species", "textures/entity/hanger/fang_hanger.png");

    public LeafHangerRenderer(EntityRendererProvider.Context context) {
        super(context, new LeafHangerModel(context.m_174023_(SpeciesEntityModelLayers.LEAF_HANGER)), 0.5f);
    }

    public ResourceLocation getTextureLocation(LeafHanger entity) {
        return entity.isRare() ? TEXTURE_RARE : TEXTURE;
    }

    @Nullable
    public RenderType getRenderType(LeafHanger entity, boolean b, boolean b1, boolean b2) {
        return entity.isRare() ? RenderType.m_110473_((ResourceLocation)TEXTURE_RARE) : RenderType.m_110473_((ResourceLocation)TEXTURE);
    }

    public void render(LeafHanger entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_COIL));
        Vec3 base = new Vec3(0.0, (double)entity.getTongueOffset(), 0.0);
        Vec3 tip = new Vec3(entity.getCurrentTonguePos());
        Vec3 direction = tip.m_82546_(base);
        double length = direction.m_82553_();
        if (!entity.m_6084_()) {
            return;
        }
        Vec3 dirNorm = direction.m_82541_();
        Vec3 up = Math.abs(dirNorm.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 right = dirNorm.m_82537_(up).m_82541_().m_82490_(0.3);
        Vec3 forward = dirNorm.m_82537_(right).m_82541_().m_82490_(0.3);
        poseStack.m_85836_();
        float vMax = (float)length;
        float baseOpacity = entity.isTongueOut() && !entity.isPullingTarget() ? 0.4f : 1.0f;
        float tipOpacity = entity.isTongueOut() && !entity.isPullingTarget() ? 0.0f : 1.0f;
        tip = tip.m_82520_(0.0, -0.135, 0.0);
        this.drawTongueQuad(poseStack, builder, base, tip, right, vMax, packedLight, baseOpacity, tipOpacity);
        this.drawTongueQuad(poseStack, builder, base, tip, forward, vMax, packedLight, baseOpacity, tipOpacity);
        poseStack.m_85849_();
        if (length > 0.2 && !entity.isPullingTarget()) {
            BlockState state = entity.getBaitBlockState();
            BlockPos pos = BlockPos.m_274446_((Position)entity.m_20182_().m_82549_(tip));
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)pos);
            tip = tip.m_82520_(0.0, 0.135, 0.0);
            poseStack.m_85836_();
            poseStack.m_85837_(tip.f_82479_ - 0.5, tip.f_82480_, tip.f_82481_ - 0.5);
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
            ModelBlockRenderer renderer = Minecraft.m_91087_().m_91289_().m_110937_();
            renderer.tesselateBlock((BlockAndTintGetter)entity.m_9236_(), model, state, pos, poseStack, buffer.m_6299_(RenderType.m_110463_()), false, RandomSource.m_216327_(), 42L, light, ModelData.EMPTY, RenderType.m_110463_());
            poseStack.m_85849_();
        }
    }
}

