/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.model.mob.update_3;

import com.ninni.species.client.animation.SpectreAnimations;
import com.ninni.species.server.entity.mob.update_3.Spectre;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SpectreModel<E extends Spectre>
extends HierarchicalModel<E> {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart rightArm;
    private final ModelPart rightChain;
    private final ModelPart leftArm;
    private final ModelPart leftChain;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart face;
    private final ModelPart collar;
    private final ModelPart helmet;
    private final ModelPart featherBase;
    private final ModelPart featherMiddle;
    private final ModelPart featherEnd;

    public SpectreModel(ModelPart root) {
        this.root = root;
        this.all = root.m_171324_("all");
        this.rightArm = this.all.m_171324_("rightArm");
        this.rightChain = this.rightArm.m_171324_("rightChain");
        this.leftArm = this.all.m_171324_("leftArm");
        this.leftChain = this.leftArm.m_171324_("leftChain");
        this.body = this.all.m_171324_("body");
        this.collar = this.body.m_171324_("collar");
        this.head = this.all.m_171324_("head");
        this.face = this.head.m_171324_("face");
        this.helmet = this.head.m_171324_("helmet");
        this.featherBase = this.helmet.m_171324_("featherBase");
        this.featherMiddle = this.featherBase.m_171324_("featherMiddle");
        this.featherEnd = this.featherMiddle.m_171324_("featherEnd");
    }

    public void setupAnim(E entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        float tilt;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        float speed = 0.5f;
        float degree = 1.0f;
        this.head.f_104203_ += headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ += headYaw * ((float)Math.PI / 180);
        if (((Spectre)entity).getVariant() == Spectre.Type.HULKING_SPECTRE) {
            this.m_233381_(((Spectre)entity).attackAnimationState, SpectreAnimations.SABLE_ATTACK, animationProgress);
        } else {
            this.m_233381_(((Spectre)entity).attackAnimationState, SpectreAnimations.ATTACK, animationProgress);
        }
        this.m_233381_(((Spectre)entity).dashAnimationState, SpectreAnimations.JOUSTING_ATTACK, animationProgress);
        this.m_233381_(((Spectre)entity).spawnAnimationState, SpectreAnimations.SPAWN, animationProgress);
        this.m_233381_(((Spectre)entity).poofAnimationState, SpectreAnimations.POOF, animationProgress);
        if (((Spectre)entity).getVariant() == Spectre.Type.SPECTRE) {
            this.body.f_104203_ = tilt = Math.min(limbDistance / 0.3f, 1.0f);
            this.body.f_104202_ = tilt * 5.0f;
            this.leftArm.f_104203_ = -tilt;
            this.rightArm.f_104203_ = -tilt;
            this.leftArm.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.8f)) * degree * 0.5f;
            this.rightArm.f_104201_ = Mth.m_14031_((float)(animationProgress * speed * 0.3f - 0.5f)) * degree * 0.5f + 0.5f;
        }
        if (((Spectre)entity).getVariant() == Spectre.Type.JOUSTING_SPECTRE) {
            tilt = Math.min(limbDistance / 0.3f, 1.0f);
            this.leftArm.f_104203_ = -tilt;
            this.rightArm.f_104203_ = -tilt;
            this.leftArm.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.8f)) * degree * 0.5f;
            this.rightArm.f_104201_ = Mth.m_14031_((float)(animationProgress * speed * 0.3f - 0.5f)) * degree * 0.5f + 0.5f;
        }
        if (((Spectre)entity).getVariant() == Spectre.Type.HULKING_SPECTRE) {
            tilt = Math.min(limbDistance / 0.3f, 1.0f);
            this.body.f_104203_ = tilt * 0.5f;
            this.body.f_104202_ = tilt * 2.0f;
            this.leftArm.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.8f)) * degree * 1.0f;
            this.rightArm.f_104201_ = Mth.m_14031_((float)(animationProgress * speed * 0.3f - 0.5f)) * degree * 1.0f + 1.0f;
        }
        this.body.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f)) * degree * 0.5f + 1.5f;
        this.body.f_104203_ += Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.5f)) * degree * 0.25f * 0.25f;
        this.leftArm.f_104203_ += Mth.m_14089_((float)(animationProgress * speed * 0.3f)) * degree * 0.25f * 0.25f;
        this.leftChain.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.2f)) * degree * 0.35f * 0.25f;
        this.leftChain.f_104204_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.2f)) * degree * 0.35f * 0.25f;
        this.leftChain.f_104205_ = Mth.m_14031_((float)(animationProgress * speed * 0.3f - 0.2f)) * degree * 0.35f * 0.25f;
        this.leftChain.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.2f)) * degree * 0.5f + 7.0f;
        this.rightArm.f_104203_ += Mth.m_14031_((float)(animationProgress * speed * 0.3f)) * degree * 0.25f * 0.25f;
        this.rightChain.f_104203_ = Mth.m_14031_((float)(animationProgress * speed * 0.3f)) * degree * 0.35f * 0.25f;
        this.rightChain.f_104204_ = Mth.m_14031_((float)(animationProgress * speed * 0.3f)) * degree * 0.35f * 0.25f;
        this.rightChain.f_104205_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f)) * degree * 0.35f * 0.25f;
        this.rightChain.f_104201_ = Mth.m_14031_((float)(animationProgress * speed * 0.3f)) * degree * 0.5f + 7.0f;
        this.head.f_104201_ += Mth.m_14089_((float)(animationProgress * speed * 0.3f)) * degree * 0.5f + 2.0f - 4.0f;
        this.head.f_104203_ += Mth.m_14031_((float)(animationProgress * speed * 0.3f - 0.5f)) * degree * 0.25f * 0.25f;
        this.helmet.f_104203_ += Mth.m_14031_((float)(animationProgress * speed * 0.3f - 0.8f)) * degree * 0.25f * 0.25f;
        this.featherBase.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.2f)) * degree * 0.75f * 0.25f - 0.8f;
        this.featherMiddle.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 0.8f)) * degree * 0.75f * 0.25f - 0.4f;
        this.featherEnd.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.3f - 1.2f)) * degree * 0.75f * 0.25f - 0.2f;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(32, 15).m_171488_(-3.0f, -1.5f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)0.5f, (float)0.0f));
        rightArm.m_171599_("rightChain", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171488_(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)6.5f, (float)0.0f));
        PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(32, 15).m_171480_().m_171488_(-1.0f, -1.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("leftChain", CubeListBuilder.m_171558_().m_171514_(0, 31).m_171480_().m_171488_(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0f, (float)7.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 39).m_171488_(-4.0f, -2.5f, -2.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(-4.0f, 5.5f, -2.0f, 8.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)0.0f));
        body.m_171599_("collar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = all.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.75f, (float)1.0f));
        head.m_171599_("face", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.25f, (float)-1.0f));
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -5.0f, -5.0f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.02f)), PartPose.m_171419_((float)0.0f, (float)-3.25f, (float)-1.0f));
        PartDefinition featherBase = helmet.m_171599_("featherBase", CubeListBuilder.m_171558_().m_171514_(38, 42).m_171488_(-1.5f, -6.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition featherMiddle = featherBase.m_171599_("featherMiddle", CubeListBuilder.m_171558_().m_171514_(35, 37).m_171488_(-1.5f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        featherMiddle.m_171599_("featherEnd", CubeListBuilder.m_171558_().m_171514_(32, 32).m_171488_(-1.5f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSableBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(37, 32).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 4).m_171488_(-1.0f, 13.0f, 4.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171480_().m_171488_(-6.0f, 13.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 0).m_171488_(4.0f, 13.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, 13.0f, -6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-4.0f, 10.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-11.0f, (float)-1.0f, (float)0.0f));
        rightArm.m_171599_("rightChain", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-4.0f, -1.5f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.5f, (float)0.0f));
        PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(37, 32).m_171480_().m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 4).m_171480_().m_171488_(-1.0f, 13.0f, 4.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 0).m_171488_(4.0f, 13.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171480_().m_171488_(-6.0f, 13.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-1.0f, 13.0f, -6.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-4.0f, 10.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)11.0f, (float)-1.0f, (float)0.0f));
        leftArm.m_171599_("leftChain", CubeListBuilder.m_171558_().m_171514_(0, 62).m_171488_(-4.0f, -1.5f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)7.5f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-6.0f, -2.5f, -3.0f, 12.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 50).m_171488_(-4.0f, 7.5f, -2.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)0.0f));
        body.m_171599_("collar", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = all.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.75f, (float)1.0f));
        head.m_171599_("face", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.25f, (float)-1.0f));
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-5.0f, -5.0f, -5.0f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.02f)), PartPose.m_171419_((float)0.0f, (float)-3.25f, (float)-1.0f));
        PartDefinition featherBase = helmet.m_171599_("featherBase", CubeListBuilder.m_171558_().m_171514_(54, 26).m_171488_(-1.5f, -6.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition featherMiddle = featherBase.m_171599_("featherMiddle", CubeListBuilder.m_171558_().m_171514_(51, 21).m_171488_(-1.5f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        featherMiddle.m_171599_("featherEnd", CubeListBuilder.m_171558_().m_171514_(48, 16).m_171488_(-1.5f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)80);
    }

    public static LayerDefinition createJoustingBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition rightArm = all.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(24, 52).m_171488_(-2.0f, 0.5f, -2.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)0.5f, (float)0.0f));
        rightArm.m_171599_("rightChain", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = all.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(24, 52).m_171480_().m_171488_(-1.0f, 1.0f, -2.0f, 3.0f, 12.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("leftChain", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-4.0f, -0.5f, -2.0f, 8.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(4, 67).m_171488_(-2.0f, 4.5f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.5f, (float)0.0f));
        body.m_171599_("collar", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -1.5f, -8.0f, 16.0f, 3.0f, 16.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)0.0f));
        PartDefinition head = all.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-1.75f, (float)1.0f));
        head.m_171599_("face", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.25f, (float)-1.0f));
        PartDefinition helmet = head.m_171599_("helmet", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(-5.0f, -5.0f, -5.0f, 10.0f, 5.0f, 10.0f, new CubeDeformation(0.02f)).m_171514_(40, 20).m_171488_(-1.0f, -13.0f, -5.0f, 2.0f, 8.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.25f, (float)-1.0f));
        PartDefinition featherBase = helmet.m_171599_("featherBase", CubeListBuilder.m_171558_().m_171514_(58, 46).m_171488_(-1.5f, -6.0f, 0.0f, 3.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition featherMiddle = featherBase.m_171599_("featherMiddle", CubeListBuilder.m_171558_().m_171514_(55, 41).m_171488_(-1.5f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        featherMiddle.m_171599_("featherEnd", CubeListBuilder.m_171558_().m_171514_(52, 36).m_171488_(-1.5f, -5.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)80);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

