/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client.model.mob.update_1;

import com.google.common.collect.ImmutableList;
import com.ninni.species.server.entity.mob.update_1.Deepfish;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeepfishModel<T extends Deepfish>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leftEar;
    private final ModelPart rightEar;
    private final ModelPart tail;

    public DeepfishModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.leftEar = this.body.m_171324_("left_ear");
        this.rightEar = this.body.m_171324_("right_ear");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition getLayerDefinition() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 16).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition leftEar = body.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171488_(0.0f, -2.5f, -2.5f, 2.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.5f, (float)-0.5f));
        PartDefinition rightEar = body.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 28).m_171480_().m_171488_(-2.0f, -2.5f, -2.5f, 2.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.5f, (float)-0.5f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(18, 8).m_171488_(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)48, (int)48);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public List<ModelPart> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.tail, (Object)this.leftEar, (Object)this.rightEar);
    }

    public void setupAnim(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        limbDistance = Mth.m_14036_((float)limbDistance, (float)-0.25f, (float)0.25f);
        float speed = 1.5f;
        float degree = 1.0f;
        this.body.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.body.f_104204_ += Mth.m_14089_((float)(animationProgress * speed * 0.15f)) * degree * 0.25f;
        this.body.f_104201_ = Mth.m_14089_((float)(animationProgress * speed * 0.15f + 1.5707964f)) * degree * 1.0f + 20.0f;
        this.tail.f_104204_ = Mth.m_14089_((float)(limbAngle * speed * 2.1f + 0.5f)) * degree * 3.0f * limbDistance;
        this.tail.f_104203_ = Mth.m_14089_((float)(animationProgress * speed * 0.15f + 1.5707964f + 0.5f)) * degree * 1.5f * 0.25f;
    }
}

