/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.species.client;

import com.ninni.species.CommonProxy;
import com.ninni.species.client.events.ClientEvents;
import com.ninni.species.client.inventory.BirtdayCakeScreen;
import com.ninni.species.client.screen.ScreenShakeEvent;
import com.ninni.species.mixin_util.PlayerAccess;
import com.ninni.species.registry.SpeciesItems;
import com.ninni.species.registry.SpeciesMenus;
import com.ninni.species.server.item.CrankbowItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
    }

    @Override
    public void clientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)SpeciesMenus.BIRTDAY_CAKE.get()), BirtdayCakeScreen::new);
        ItemProperties.register((Item)((Item)SpeciesItems.CRANKBOW.get()), (ResourceLocation)new ResourceLocation("species", "pull"), (stack, level, entity, seed) -> {
            int maxCooldown;
            if (!(entity instanceof Player)) {
                return -1.0f;
            }
            if (!stack.m_41784_().m_128471_("IsUsing")) {
                return -1.0f;
            }
            CompoundTag tag = stack.m_41784_();
            int cooldown = tag.m_128451_("Cooldown");
            float progress = 1.0f - (float)cooldown / (float)Math.max(1, maxCooldown = CrankbowItem.getShootingCooldown(stack));
            if (progress < 0.05f) {
                return 0.0f;
            }
            if (progress < 0.2f) {
                return 0.15f;
            }
            if (progress < 0.35f) {
                return 0.3f;
            }
            if (progress < 0.5f) {
                return 0.4f;
            }
            return 0.6f;
        });
        ItemProperties.register((Item)((Item)SpeciesItems.RICOSHIELD.get()), (ResourceLocation)new ResourceLocation("species", "blocking"), (stack, level, player, i) -> player != null && player.m_6117_() && player.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)SpeciesItems.SPECTRALIBUR.get()), (ResourceLocation)new ResourceLocation("species", "souls"), (stack, level, player, i) -> stack.m_41784_().m_128441_("Souls") ? (float)stack.m_41783_().m_128451_("Souls") : 0.0f);
        ItemProperties.register((Item)((Item)SpeciesItems.COIL.get()), (ResourceLocation)new ResourceLocation("species", "placing"), (stack, level, player, i) -> stack.m_41782_() && stack.m_41783_().m_128441_("EndPointPos") ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)SpeciesItems.HARPOON.get()), (ResourceLocation)new ResourceLocation("species", "using"), (stack, level, player, i) -> player != null && player.m_6117_() && player.m_21211_() == stack ? 1.0f : 0.0f);
    }

    @Override
    public void harpoonSync(int id) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player instanceof PlayerAccess) {
            PlayerAccess playerAccess = (PlayerAccess)player;
            playerAccess.setHarpoonId(id);
        }
    }

    @Override
    public Level getWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    @Override
    public void screenShake(ScreenShakeEvent event) {
        ClientEvents.SCREEN_SHAKE_EVENTS.add(event);
    }
}

