/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.skyfall.configuration;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class SkyfallConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> SPAWN_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> IMPACT_STRENGTH;
    public static final ForgeConfigSpec.ConfigValue<Double> FALLING_SPEED;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> METEORITE_DIMENSIONS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> METEORITE_FIRE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ALIENPHOBIA;
    public static final ForgeConfigSpec.ConfigValue<Double> SHOWER_SPAWN_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> APOCALYPSE_SPAWN_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> ANGRY_MOON_DESCEND_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> SHOWER_DIMENSIONS;
    public static final ForgeConfigSpec.ConfigValue<Double> MIN_SHOWER_START;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_SHOWER_START;
    public static final ForgeConfigSpec.ConfigValue<Double> MIN_SHOWER_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_SHOWER_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> FORCE_BEACON;
    public static final ForgeConfigSpec.ConfigValue<Double> PROTECTOR_STARDUST_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ALWAYS_BEACON;
    public static final ForgeConfigSpec.ConfigValue<Boolean> FAST_FIRE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LESS_PARTICLES;

    static {
        BUILDER.push("Meteorites");
        SPAWN_CHANCE = BUILDER.comment("this value multiplies the default chance of a meteorite spawning (Default: 1)").define("Spawn Chance Multiplier", (Object)1.0);
        IMPACT_STRENGTH = BUILDER.comment("this value multiplies the default impact strength of meteorites (Default: 1").define("Impact Strength Multiplier", (Object)1.0);
        FALLING_SPEED = BUILDER.comment("this value multiplies the default falling speed of meteorites (Default: 1)").define("Falling Speed Multiplier", (Object)1.0);
        METEORITE_DIMENSIONS = BUILDER.comment("the list of dimensions where meteorites can spawn in (Default: minecraft:overworld) Example: [minecraft:overworld, minecraft:the_end]").defineList("Meteorite Spawn Dimensions", List.of("minecraft:overworld"), entry -> true);
        METEORITE_FIRE = BUILDER.comment("this controls whether or not the meteorites spawn fire upon landing").define("Meteorite Fire", true);
        ALIENPHOBIA = BUILDER.comment("if true this completely disables the alien").define("Alienphobia", false);
        BUILDER.pop();
        BUILDER.push("Events");
        SHOWER_SPAWN_CHANCE = BUILDER.comment("this value multiplies the default chance of a meteorite spawning during a meteor shower (Default: 1)").define("Meteorite Shower Meteorite Spawn Chance  Multiplier", (Object)1.0);
        APOCALYPSE_SPAWN_CHANCE = BUILDER.comment("this value multiplies the default chance of a meteorite spawning during a apocalypse (Default: 1)").define("Apocalypse Meteorite Spawn Chance  Multiplier", (Object)1.0);
        ANGRY_MOON_DESCEND_MULTIPLIER = BUILDER.comment("this value multiplies the default descend speed of the angry moon (Default: 1)").define("Angry Moon Descend Speed Multiplier", (Object)1.0);
        SHOWER_DIMENSIONS = BUILDER.comment("this list defines in which dimensions meteor showers can happen").defineList("Meteor Shower Dimensions", List.of("minecraft:overworld"), entry -> true);
        MIN_SHOWER_START = BUILDER.comment("the minimum of time where a meteor shower can start in ticks (Default: 268000) (meteor showers work with a time that counts up every tick and if it reaches this number, a meteor shower starts and will go on until the timer reaches the shower start value + the shower duration then the timer resets)").define("Min Meteor Shower Start Time", (Object)268000.0);
        MAX_SHOWER_START = BUILDER.comment("the maximum of time where a meteor shower can start in ticks (Default: 436000)").define("Max Meteor Shower Start Time", (Object)436000.0);
        MIN_SHOWER_DURATION = BUILDER.comment("this defines the minimum of the duration a meteor shower can last (Default: 3000)").define("Min Shower Duration", (Object)3000.0);
        MAX_SHOWER_DURATION = BUILDER.comment("this defines the maximum of the duration a meteor shower can last (Default: 6000)").define("Max Shower Duration", (Object)6000.0);
        BUILDER.pop();
        BUILDER.push("Blocks and Items");
        FORCE_BEACON = BUILDER.comment("this will completely despawn any meteorites entering the area of a astral repulsion beacon, including meteorites summoned by a player (Default: False)").define("Force Repulsion", false);
        PROTECTOR_STARDUST_CHANCE = BUILDER.comment("this defines the chance(in %) of stardust spawning when a meteorite is shot by a skyfall protector (Default: 35)").define("Skyfall Protector Stardust Chance", (Object)35.0);
        ALWAYS_BEACON = BUILDER.comment("this controls whether or not the astral repulsion beacon should always have a effect, even if there is no stardust beneath it").define("Always Active Repulsion Beacon", true);
        BUILDER.pop();
        BUILDER.push("Performance");
        FAST_FIRE = BUILDER.comment("decides if fire is placed immediately or through falling blocks (Default: False)").define("Immediate Fire", false);
        LESS_PARTICLES = BUILDER.comment("if true, it will reduce the amount of particles a lot (Default: False)").define("Lightweight Particles", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

