/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricrevival.common.recipes;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import superlord.prehistoricfauna.common.recipes.ItemWeightedPairCodec;
import superlord.prehistoricrevival.common.recipes.DNAAnalyzerRecipeCodec;

public class DNAAnalyzerRecipeJsonManager
extends SimpleJsonResourceReloadListener {
    private static final Gson STANDARD_GSON = new Gson();
    public static final Logger LOGGER = LogManager.getLogger();
    protected static Map<Item, List<ItemWeightedPairCodec>> recipeList = new HashMap<Item, List<ItemWeightedPairCodec>>();
    protected static Map<ResourceLocation, DNAAnalyzerRecipeCodec> recipeListR1 = new HashMap<ResourceLocation, DNAAnalyzerRecipeCodec>();
    private final String folderName;

    public DNAAnalyzerRecipeJsonManager() {
        this("loot_tables/dna_analyzer", STANDARD_GSON);
    }

    public DNAAnalyzerRecipeJsonManager(String folderName, Gson gson) {
        super(gson, folderName);
        this.folderName = folderName;
    }

    public static Map<Item, List<ItemWeightedPairCodec>> getRecipes() {
        return recipeList;
    }

    public static void setRecipeList(Map<Item, List<ItemWeightedPairCodec>> recipeList) {
        DNAAnalyzerRecipeJsonManager.recipeList = recipeList;
    }

    public static List<ItemWeightedPairCodec> getItems(Item item) {
        return recipeList.getOrDefault(item, Collections.emptyList());
    }

    public static boolean containsRecipe(Item item) {
        return recipeList.containsKey(item);
    }

    public static ItemStack getRandomItemStack(Item input, Level level) {
        ItemStack outputStack;
        if (null == level) {
            return ItemStack.f_41583_;
        }
        Item outputItem = null;
        List<ItemWeightedPairCodec> outputs = recipeList.get(input);
        int totalWeight = 0;
        for (ItemWeightedPairCodec itemWeightedPair : outputs) {
            totalWeight += itemWeightedPair.getWeight();
        }
        int randomNr = level.f_46441_.m_188503_(totalWeight);
        int cumulativeWeight = 0;
        for (ItemWeightedPairCodec itemWeightedPair : outputs) {
            if (randomNr >= (cumulativeWeight += itemWeightedPair.getWeight())) continue;
            outputItem = itemWeightedPair.getItem();
            break;
        }
        if ((outputStack = new ItemStack(outputItem)) == null) {
            return ItemStack.f_41583_;
        }
        return outputStack;
    }

    public static void populateRecipeMap(Level level) {
        recipeList.clear();
        HashMap weightedPairsTemp = new HashMap();
        for (ResourceLocation resourceLocation : recipeListR1.keySet()) {
            DNAAnalyzerRecipeCodec dnaAnalyzerRecipeCodec = recipeListR1.get(resourceLocation);
            List<ResourceLocation> tagsRL = dnaAnalyzerRecipeCodec.getInputItemTags();
            List<ResourceLocation> itemsRL = dnaAnalyzerRecipeCodec.getInputItems();
            for (ResourceLocation tag : tagsRL) {
                TagKey itemTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag);
                level.m_9598_().m_6632_(Registries.f_256913_).ifPresent(reg -> {
                    Iterable itemHolder = reg.m_206058_(itemTagKey);
                    for (Holder tempItemHolder : itemHolder) {
                        Item item = (Item)tempItemHolder.get();
                        if (weightedPairsTemp.containsKey(item)) {
                            LOGGER.warn("Item {} for resourceLocation {} already has items assigned, adding more", (Object)item, (Object)resourceLocation);
                        }
                        List weightedPairsList = weightedPairsTemp.getOrDefault(item, new ArrayList());
                        weightedPairsList.addAll(dnaAnalyzerRecipeCodec.getItemWeightedPairs());
                        weightedPairsTemp.put(item, weightedPairsList);
                    }
                    if (!itemHolder.iterator().hasNext()) {
                        LOGGER.error("Tag for {} does not have any items!", (Object)itemTagKey);
                        LOGGER.error("Analyzer recipe for {} might not have any items assigned, or it uses items from a mod, but the mod isn't installed!", (Object)resourceLocation);
                    }
                });
            }
            for (ResourceLocation items : itemsRL) {
                level.m_9598_().m_6632_(Registries.f_256913_).ifPresent(reg -> {
                    Item item = (Item)reg.m_7745_(items);
                    if (item == null) {
                        LOGGER.error("Item {} does not exist, currently parsing through {}!", (Object)items, (Object)resourceLocation);
                        LOGGER.error("Recipe for {} might not have any items assigned, or it uses items from a mod, but the mod isn't installed!", (Object)resourceLocation);
                        return;
                    }
                    if (weightedPairsTemp.containsKey(item)) {
                        LOGGER.warn("Item {} for resourceLocation {} already has items assigned, adding more", (Object)item, (Object)resourceLocation);
                    }
                    List weightedPairsList = weightedPairsTemp.getOrDefault(item, new ArrayList());
                    weightedPairsList.addAll(dnaAnalyzerRecipeCodec.getItemWeightedPairs());
                    weightedPairsTemp.put(item, weightedPairsList);
                });
            }
        }
        LOGGER.info("Registered {} jsons with items!", (Object)weightedPairsTemp.keySet().size());
        recipeList.putAll(weightedPairsTemp);
        weightedPairsTemp.clear();
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        recipeList.clear();
        HashMap<ResourceLocation, DNAAnalyzerRecipeCodec> recipeList = new HashMap<ResourceLocation, DNAAnalyzerRecipeCodec>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsons.entrySet()) {
            ResourceLocation key = entry.getKey();
            JsonElement element = entry.getValue();
            DNAAnalyzerRecipeCodec.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).get().ifLeft(result -> {
                DNAAnalyzerRecipeCodec dnaAnalyzerRecipe = (DNAAnalyzerRecipeCodec)result.getFirst();
                recipeList.put(key, dnaAnalyzerRecipe);
            }).ifRight(partial -> LOGGER.error("Failed to parse recipe JSON for {} due to: {}", (Object)this.folderName, (Object)partial.message()));
        }
        recipeListR1 = recipeList;
        LOGGER.info("Data loader for {} loaded {} jsons", (Object)this.folderName, (Object)recipeListR1.size());
    }
}

