/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricrevival.common.entities.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import superlord.prehistoricfauna.init.PFTags;
import superlord.prehistoricrevival.common.blocks.DNAAnalyzerBlock;
import superlord.prehistoricrevival.common.containers.DNAAnalyzerContainer;
import superlord.prehistoricrevival.common.init.PRBlockEntities;
import superlord.prehistoricrevival.common.recipes.DNAAnalyzerRecipeJsonManager;

public class DNAAnalyzerBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(10){

        protected void onContentsChanged(int slot) {
            DNAAnalyzerBlockEntity.this.m_6596_();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private IItemHandler hopperHandler = new IItemHandler(){

        public int getSlots() {
            return DNAAnalyzerBlockEntity.this.itemHandler.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return DNAAnalyzerBlockEntity.this.itemHandler.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 0) {
                return DNAAnalyzerBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            if (slot == 0 && stack.m_204117_(PFTags.FOSSILS)) {
                return DNAAnalyzerBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return DNAAnalyzerBlockEntity.this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return DNAAnalyzerBlockEntity.this.itemHandler.isItemValid(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    private LazyOptional<IItemHandler> hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return DNAAnalyzerBlockEntity.this.progress;
                }
                case 1: {
                    return DNAAnalyzerBlockEntity.this.maxProgress;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    DNAAnalyzerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    DNAAnalyzerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 10;
        }
    };
    private int progress = 0;
    private int maxProgress = 40;

    public DNAAnalyzerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PRBlockEntities.DNA_ANALYZER.get(), pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.prehistoric_revival.dna_analyzer");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandlerOptional.cast();
            }
            return this.hopperHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
        this.hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandlerOptional.invalidate();
        this.hopperHandlerOptional.invalidate();
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, DNAAnalyzerBlockEntity blockEntity) {
        if (DNAAnalyzerBlockEntity.hasRecipe(blockEntity)) {
            blockEntity.progress = Math.min(blockEntity.progress + 1, blockEntity.maxProgress);
            DNAAnalyzerBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            if (blockEntity.progress >= blockEntity.maxProgress && !world.m_5776_()) {
                DNAAnalyzerBlockEntity.craftItem(world.m_9598_(), blockEntity);
            }
            world.m_7731_(pos, (BlockState)blockEntity.m_58900_().m_61124_((Property)DNAAnalyzerBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 1);
        } else {
            blockEntity.resetProgress();
            DNAAnalyzerBlockEntity.m_155232_((Level)world, (BlockPos)pos, (BlockState)state);
            world.m_7731_(pos, (BlockState)blockEntity.m_58900_().m_61124_((Property)DNAAnalyzerBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 1);
        }
    }

    private static boolean hasRecipe(DNAAnalyzerBlockEntity entity) {
        Level world = entity.m_58904_();
        if (DNAAnalyzerRecipeJsonManager.getRecipes().isEmpty() && !world.m_5776_()) {
            DNAAnalyzerRecipeJsonManager.populateRecipeMap(world);
        }
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        boolean hasRecipe = DNAAnalyzerRecipeJsonManager.containsRecipe(inventory.m_8020_(0).m_41720_());
        return hasRecipe && DNAAnalyzerBlockEntity.canInsertAmountIntoOutputSlot(inventory);
    }

    private static void craftItem(RegistryAccess p_266740_, DNAAnalyzerBlockEntity entity) {
        Level world = entity.m_58904_();
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        boolean hasRecipe = DNAAnalyzerRecipeJsonManager.containsRecipe(inventory.m_8020_(0).m_41720_());
        if (hasRecipe) {
            ItemStack result = DNAAnalyzerRecipeJsonManager.getRandomItemStack(inventory.m_8020_(0).m_41720_(), world);
            entity.itemHandler.extractItem(0, 1, false);
            boolean success = false;
            int n = entity.itemHandler.getSlots();
            for (int i = 1; i < n; ++i) {
                if (!entity.itemHandler.insertItem(i, result, false).m_41619_()) continue;
                success = true;
                break;
            }
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        int n = inventory.m_6643_();
        for (int slot = 1; slot < n; ++slot) {
            if (!inventory.m_8020_(slot).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new DNAAnalyzerContainer(containerId, inventory, this, this.data);
    }
}

