/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricrevival.common.entities.tile;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import superlord.prehistoricrevival.common.blocks.CultivatorBlock;
import superlord.prehistoricrevival.common.containers.CultivatorContainer;
import superlord.prehistoricrevival.common.init.PRBlockEntities;
import superlord.prehistoricrevival.common.init.PRTags;
import superlord.prehistoricrevival.common.recipes.RecipeCultivator;

public class CultivatorBlockEntity
extends BlockEntity
implements MenuProvider {
    public int ticksExisted;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            CultivatorBlockEntity.this.m_6596_();
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 1 && (stack.m_204117_(PRTags.EGGS) || stack.m_204117_(PRTags.SAPLINGS) || stack.m_204117_(PRTags.SEEDS) || stack.m_150930_(Items.f_42447_) || stack.m_150930_(Items.f_42455_) || stack.m_150930_(Items.f_42590_)) || stack.m_150930_(Items.f_42446_)) {
                return true;
            }
            if (slot == 0 && stack.m_204117_(PRTags.DNA)) {
                return true;
            }
            return slot == 2;
        }
    };
    private IItemHandler hopperHandler = new IItemHandler(){

        public int getSlots() {
            return CultivatorBlockEntity.this.itemHandler.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return CultivatorBlockEntity.this.itemHandler.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 2) {
                return CultivatorBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
            }
            if (slot == 1 && this.getStackInSlot(1) == new ItemStack((ItemLike)Items.f_42446_)) {
                return CultivatorBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return stack;
            }
            if (slot == 0 && stack.m_204117_(PRTags.DNA)) {
                return CultivatorBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }
            if (slot == 1 && (stack.m_204117_(PRTags.EGGS) || stack.m_204117_(PRTags.SAPLINGS) || stack.m_204117_(PRTags.SEEDS) || stack.m_150930_(Items.f_42447_) || stack.m_150930_(Items.f_42455_) || stack.m_150930_(Items.f_42590_))) {
                return CultivatorBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public int getSlotLimit(int slot) {
            return CultivatorBlockEntity.this.itemHandler.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return CultivatorBlockEntity.this.itemHandler.isItemValid(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    private LazyOptional<IItemHandler> hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CultivatorBlockEntity.this.progress;
                case 1 -> CultivatorBlockEntity.this.maxProgress;
                case 2 -> CultivatorBlockEntity.this.tickCount;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CultivatorBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    CultivatorBlockEntity.this.maxProgress = value;
                    break;
                }
                case 2: {
                    CultivatorBlockEntity.this.tickCount = value;
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };
    private int progress = 0;
    private int maxProgress = 1200;
    public int tickCount = 0;

    public CultivatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)PRBlockEntities.CULTIVATOR.get(), pPos, pBlockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.prehistoric_revival.cultivator");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandlerOptional.cast();
            }
            return this.hopperHandlerOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
        this.hopperHandlerOptional = LazyOptional.of(() -> this.hopperHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandlerOptional.invalidate();
        this.hopperHandlerOptional.invalidate();
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.progress = tag.m_128451_("progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, CultivatorBlockEntity pBlockEntity) {
        ++pBlockEntity.tickCount;
        if (CultivatorBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            CultivatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (pBlockEntity.progress > pBlockEntity.maxProgress) {
                CultivatorBlockEntity.craftItem(pBlockEntity);
            }
            pLevel.m_7731_(pPos, (BlockState)pBlockEntity.m_58900_().m_61124_((Property)CultivatorBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 1);
        } else {
            CultivatorBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            pBlockEntity.resetProgress();
            pLevel.m_7731_(pPos, (BlockState)pBlockEntity.m_58900_().m_61124_((Property)CultivatorBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 1);
        }
    }

    private static boolean hasRecipe(CultivatorBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)RecipeCultivator.Type.INSTANCE, (Container)inventory, level);
        return match.isPresent() && CultivatorBlockEntity.canInsertAmountIntoOutputSlot(inventory) && CultivatorBlockEntity.canInsertItemIntoOutputSlot(inventory, ((RecipeCultivator)match.get()).assemble(inventory, level.m_9598_()));
    }

    private static void craftItem(CultivatorBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)RecipeCultivator.Type.INSTANCE, (Container)inventory, level);
        if (match.isPresent()) {
            entity.itemHandler.extractItem(0, 1, false);
            if (inventory.m_8020_(1).m_150930_(Items.f_42455_)) {
                entity.itemHandler.extractItem(1, 1, false);
                entity.itemHandler.insertItem(1, new ItemStack((ItemLike)Items.f_42446_), false);
            } else {
                entity.itemHandler.extractItem(1, 1, false);
            }
            entity.itemHandler.insertItem(2, ((RecipeCultivator)match.get()).assemble(inventory, level.m_9598_()), false);
            entity.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack output) {
        return inventory.m_8020_(2).m_41720_() == output.m_41720_() || inventory.m_8020_(2).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(2).m_41741_() > inventory.m_8020_(2).m_41613_();
    }

    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new CultivatorContainer(pContainerId, pInventory, this, this.data);
    }
}

