/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricrevival.common.containers;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import superlord.prehistoricrevival.common.entities.tile.DNAAnalyzerBlockEntity;
import superlord.prehistoricrevival.common.init.PRBlocks;
import superlord.prehistoricrevival.common.init.PRContainers;

public class DNAAnalyzerContainer
extends AbstractContainerMenu {
    private final DNAAnalyzerBlockEntity blockEntity;
    private final Level world;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;

    public DNAAnalyzerContainer(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(10));
    }

    public DNAAnalyzerContainer(int containerId, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)PRContainers.DNA_ANALYZER.get(), containerId);
        DNAAnalyzerContainer.m_38869_((Container)inventory, (int)10);
        this.blockEntity = (DNAAnalyzerBlockEntity)entity;
        this.world = inventory.f_35978_.m_9236_();
        this.data = data;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 36, 42));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 1, 92, 23));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 2, 92, 41));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 3, 92, 59));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 4, 110, 23));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 5, 110, 41));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 6, 110, 59));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 7, 128, 23));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 8, 128, 41));
            this.m_38897_((Slot)new DNAAnalyzerResultSlot((IItemHandler)handler, 9, 128, 59));
        });
        this.m_38884_(data);
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress(int scale) {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        if (progress == 0 || maxProgress == 0) {
            return 0;
        }
        return Mth.m_14167_((float)((float)scale * (float)progress / (float)maxProgress));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 46, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 46) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return DNAAnalyzerContainer.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.world, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)PRBlocks.DNA_ANALYZER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private class DNAAnalyzerResultSlot
    extends SlotItemHandler {
        public DNAAnalyzerResultSlot(IItemHandler itemHandler, int index, int x, int y) {
            super(itemHandler, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return false;
        }
    }
}

