/*
 * Decompiled with CFR 0.152.
 */
package io.socol.betterthirdperson;

import io.socol.betterthirdperson.BetterThirdPerson;
import io.socol.betterthirdperson.api.CustomCameraManager;
import io.socol.betterthirdperson.api.TickPhase;
import io.socol.betterthirdperson.impl.MovementInputAdapter;
import io.socol.betterthirdperson.impl.PlayerAdapter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class CustomCameraListener {
    private final CustomCameraManager manager;

    public CustomCameraListener(CustomCameraManager manager) {
        this.manager = manager;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player instanceof LocalPlayer) {
            PlayerAdapter player = new PlayerAdapter((AbstractClientPlayer)event.player);
            TickPhase phase = event.phase == TickEvent.Phase.START ? TickPhase.START : TickPhase.END;
            this.manager.onPlayerTick(player, phase);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onInputs(MovementInputUpdateEvent event) {
        PlayerAdapter player = new PlayerAdapter((AbstractClientPlayer)Minecraft.m_91087_().f_91074_);
        MovementInputAdapter inputs = new MovementInputAdapter(event.getInput());
        this.manager.handleMovementInputs(player, inputs, TickPhase.END);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (event.phase != TickEvent.Phase.START || player == null) {
            return;
        }
        PlayerAdapter playerAdapter = new PlayerAdapter((AbstractClientPlayer)player);
        this.manager.onRenderTickStart(playerAdapter, event.renderTickTime);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (BetterThirdPerson.getCameraManager().hasCustomCamera()) {
            float cameraYaw = BetterThirdPerson.getCameraManager().getCustomCamera().getYaw();
            float cameraPitch = BetterThirdPerson.getCameraManager().getCustomCamera().getPitch();
            if (event.getYaw() != cameraYaw || event.getPitch() != cameraPitch) {
                Minecraft mc = Minecraft.m_91087_();
                event.setYaw(cameraYaw);
                event.setPitch(cameraPitch);
                event.getCamera().m_90575_((BlockGetter)mc.f_91073_, (Entity)mc.f_91074_, !mc.f_91066_.m_92176_().m_90612_(), mc.f_91066_.m_92176_().m_90613_(), (float)event.getPartialTick());
            }
        }
    }
}

