/*
 * Decompiled with CFR 0.152.
 */
package com.cursee.monolib.core.serialization;

import com.cursee.monolib.core.serialization.ISerializer;
import com.cursee.monolib.core.serialization.NBTParseException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public class SerializerCompoundTag
implements ISerializer<CompoundTag> {
    public static final ISerializer<CompoundTag> SERIALIZER = new SerializerCompoundTag();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private SerializerCompoundTag() {
    }

    @Override
    public CompoundTag fromJSON(JsonElement json) {
        try {
            if (json.isJsonObject()) {
                return TagParser.m_129359_((String)GSON.toJson(json));
            }
            return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)json, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Failed to read NBT from " + GsonHelper.m_13883_((JsonElement)json), (Throwable)e);
        }
    }

    @Override
    public JsonElement toJSON(CompoundTag toWrite) {
        return new JsonPrimitive(toWrite.toString());
    }

    @Override
    public CompoundTag fromByteBuf(FriendlyByteBuf buffer) {
        return buffer.m_130260_();
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, CompoundTag toWrite) {
        buffer.m_130079_(toWrite);
    }

    @Override
    public Tag toNBT(CompoundTag toWrite) {
        return toWrite;
    }

    @Override
    public CompoundTag fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            return compound;
        }
        throw new NBTParseException("Expected NBT to be a compound tag. Class was " + String.valueOf(nbt.getClass()) + " with ID " + nbt.m_7060_() + " instead.");
    }
}

