/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.ramcompat.items;

import com.github.alexthe666.alexsmobs.client.particle.AMParticleRegistry;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.EntityFart;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class StinkGlandItem
extends RelicItem {
    private static final String TAG_DURATION = "duration";
    private static final String TAG_COOLDOWN = "cooldown";

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"defense").maxLevel(10).stat(StatData.builder((String)TAG_DURATION).initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"radius").initialValue(1.5, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)TAG_COOLDOWN).initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).ability(AbilityData.builder((String)"dash").maxLevel(10).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).stat(StatData.builder((String)"power").initialValue(0.75, 1.75).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.075).formatValue(value -> MathUtils.round((double)value, (int)2)).build()).stat(StatData.builder((String)TAG_COOLDOWN).initialValue(10.0, 7.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.075).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 200)).loot(LootData.builder().entry(LootCollections.JUNGLE).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("dash")) {
            Level level = player.m_20193_();
            RandomSource random = level.m_213780_();
            Vec3 angle = player.m_20154_();
            double power = this.getAbilityValue(stack, "dash", "power");
            player.m_20256_(angle.m_82541_().m_82490_(power));
            player.m_204079_((int)Math.ceil(power * 5.0));
            player.f_19789_ = 0.0f;
            angle = angle.m_82490_(-1.0);
            for (int i = 0; i < 5; ++i) {
                EntityFart fart = new EntityFart((EntityType)AMEntityRegistry.FART.get(), level);
                fart.m_146884_(player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0));
                fart.shoot(angle.m_7096_(), angle.m_7098_(), angle.m_7094_(), 0.25f, 15.0f);
                fart.setShooter((Entity)player);
                level.m_7967_((Entity)fart);
            }
            level.m_5594_(null, player.m_20183_(), (SoundEvent)AMSoundRegistry.STINK_RAY.get(), SoundSource.MASTER, 1.0f, 0.9f + MathUtils.randomFloat((RandomSource)random) * 0.2f);
            if (!level.m_5776_()) {
                this.spreadExperience((LivingEntity)player, stack, 1);
            }
            this.addAbilityCooldown(stack, "dash", (int)Math.round(this.getAbilityValue(stack, "dash", TAG_COOLDOWN) * 20.0));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        int duration = NBTUtils.getInt((ItemStack)stack, (String)TAG_DURATION, (int)0);
        int cooldown = NBTUtils.getInt((ItemStack)stack, (String)TAG_COOLDOWN, (int)0);
        if (cooldown > 0) {
            return;
        }
        double radius = this.getAbilityValue(stack, "defense", "radius");
        if (duration <= 0) {
            if (!level.m_5776_() && player.m_21223_() <= player.m_21233_() * 0.2f) {
                NBTUtils.setInt((ItemStack)stack, (String)TAG_DURATION, (int)((int)Math.ceil(this.getAbilityValue(stack, "defense", TAG_DURATION) * 20.0)));
            }
        } else {
            for (Mob target : level.m_45976_(Mob.class, player.m_20191_().m_82400_(radius))) {
                if (target.m_5448_() != null && target.m_5448_().m_20148_().equals(player.m_20148_())) {
                    target.m_6703_(null);
                    target.m_6710_(null);
                }
                if (EntityUtils.isAlliedTo((Entity)player, (Entity)target)) continue;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 0));
                for (Mob mob : level.m_45976_(Mob.class, target.m_20191_().m_82400_(16.0))) {
                    if (mob.m_20148_().equals(target.m_20148_()) || mob.m_5448_() != null && !mob.m_5448_().m_20148_().equals(player.m_20148_())) continue;
                    mob.m_6703_((LivingEntity)target);
                    mob.m_6710_((LivingEntity)target);
                }
            }
            if (!level.m_5776_() && duration % 20 == 0) {
                this.spreadExperience((LivingEntity)player, stack, 1);
            }
            if (player.f_19797_ % 3 == 0) {
                level.m_5594_(null, player.m_20183_(), (SoundEvent)AMSoundRegistry.SKUNK_SPRAY.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
            for (int i = 0; i < (int)Math.ceil(radius * 2.0); ++i) {
                level.m_7106_((ParticleOptions)AMParticleRegistry.SMELLY.get(), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 2.0f), player.m_20189_(), (double)MathUtils.randomFloat((RandomSource)random) * (radius * (double)0.075f), (double)-0.05f, (double)MathUtils.randomFloat((RandomSource)random) * (radius * (double)0.075f));
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        if (level.m_5776_()) {
            return;
        }
        int duration = NBTUtils.getInt((ItemStack)stack, (String)TAG_DURATION, (int)0);
        int cooldown = NBTUtils.getInt((ItemStack)stack, (String)TAG_COOLDOWN, (int)0);
        if (duration > 0) {
            NBTUtils.setInt((ItemStack)stack, (String)TAG_DURATION, (int)(--duration));
            if (duration <= 0) {
                NBTUtils.setInt((ItemStack)stack, (String)TAG_COOLDOWN, (int)((int)Math.ceil(this.getAbilityValue(stack, "defense", TAG_COOLDOWN) * 20.0)));
            }
        }
        if (cooldown > 0) {
            NBTUtils.setInt((ItemStack)stack, (String)TAG_COOLDOWN, (int)(--cooldown));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

