/*
 * Decompiled with CFR 0.152.
 */
package elocindev.necronomicon.api.resource.v1;

import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBuilderAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"necronomicon");
    public static final int PACK_FORMAT = 15;

    public static void registerBuiltinPack(String modid, Path path, Component title, boolean enabledDefault, Component description, PackType packType, Pack.Position pos, boolean fixed) {
        PathPackResources pack = new PathPackResources(ModList.get().getModFileById(modid).getFile().getFileName() + ":" + path, true, path);
        ResourceBuilderAPI.registerResourcePack(packType, () -> Pack.m_245512_((String)modid, (Component)title, (boolean)enabledDefault, s -> pack, (Pack.Info)new Pack.Info(description, 15, FeatureFlagSet.m_246902_()), (PackType)packType, (Pack.Position)pos, (boolean)fixed, (PackSource)PackSource.f_10528_));
    }

    public static void registerBuiltinPack(String modid, Path path, Component title, boolean enabledDefault, Component description, PackType packType, Pack.Position pos, boolean fixed, int packFormat) {
        PathPackResources pack = new PathPackResources(ModList.get().getModFileById(modid).getFile().getFileName() + ":" + path, true, path);
        ResourceBuilderAPI.registerResourcePack(packType, () -> Pack.m_245512_((String)modid, (Component)title, (boolean)enabledDefault, s -> pack, (Pack.Info)new Pack.Info(description, packFormat, FeatureFlagSet.m_246902_()), (PackType)packType, (Pack.Position)pos, (boolean)fixed, (PackSource)PackSource.f_10528_));
    }

    public static void registerResourcePack(PackType packType, @Nullable Supplier<Pack> packSupplier) {
        if (packSupplier == null) {
            return;
        }
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Consumer<AddPackFindersEvent> consumer = event -> {
            Pack pack;
            if (event.getPackType() == packType && (pack = (Pack)packSupplier.get()) != null) {
                event.addRepositorySource(arg_0 -> ResourceBuilderAPI.lambda$registerResourcePack$4((Supplier)packSupplier, arg_0));
            }
        };
        bus.addListener(consumer);
    }

    private static /* synthetic */ void lambda$registerResourcePack$4(Supplier packSupplier, Consumer infoConsumer) {
        infoConsumer.accept((Pack)packSupplier.get());
    }
}

