/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import superlord.prehistoricfauna.client.render.BleedingHeartType;
import superlord.prehistoricfauna.init.PFEffects;

@Mixin(value={Gui.class})
public class GuiMixin {
    private static boolean drawForHeartType(Gui.HeartType type) {
        return type != Gui.HeartType.CONTAINER && type != Gui.HeartType.ABSORBING && type != Gui.HeartType.FROZEN;
    }

    private static boolean hasAnyCustomJurassicHearts(Player player) {
        return player.m_21023_((MobEffect)PFEffects.BLEEDING.get());
    }

    @Inject(method={"Lnet/minecraft/client/gui/Gui;renderHeart(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Gui$HeartType;IIIZZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHeart(GuiGraphics stack, Gui.HeartType __, int x, int y, int v, boolean blinking, boolean halfHeart, CallbackInfo cbi) {
        BleedingHeartType type;
        Player player;
        Entity entity;
        if (!blinking && GuiMixin.drawForHeartType(__) && (entity = Minecraft.m_91087_().f_91075_) instanceof Player && GuiMixin.hasAnyCustomJurassicHearts(player = (Player)entity) && (type = BleedingHeartType.getType(player)) != null) {
            boolean hardcore = player.m_9236_().m_6106_().m_5466_();
            Pair<Integer, Integer> pos = type.getHeartPos(hardcore);
            if (halfHeart) {
                pos = type.getHalfHeartPos(hardcore);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BleedingHeartType.ATLAS);
            stack.m_280163_(BleedingHeartType.ATLAS, x, y, (float)((Integer)pos.getLeft()).intValue(), (float)((Integer)pos.getRight()).intValue(), 9, 9, 64, 9);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)Gui.f_279580_);
            cbi.cancel();
        }
    }
}

