/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.init;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import superlord.prehistoricfauna.common.structure.ChinleHutStructure;
import superlord.prehistoricfauna.common.structure.DjadochtaHutStructure;
import superlord.prehistoricfauna.common.structure.HellCreekHutStructure;
import superlord.prehistoricfauna.common.structure.IschigualastoHutStructure;
import superlord.prehistoricfauna.common.structure.KayentaHutStructure;
import superlord.prehistoricfauna.common.structure.MorrisonHutStructure;
import superlord.prehistoricfauna.common.structure.YixianHutStructure;
import superlord.prehistoricfauna.common.structure.piece.ChinleHutPieces;
import superlord.prehistoricfauna.common.structure.piece.DjadochtaHutPieces;
import superlord.prehistoricfauna.common.structure.piece.HellCreekHutPieces;
import superlord.prehistoricfauna.common.structure.piece.IschigualastoHutPieces;
import superlord.prehistoricfauna.common.structure.piece.KayentaHutPieces;
import superlord.prehistoricfauna.common.structure.piece.MorrisonHutPieces;
import superlord.prehistoricfauna.common.structure.piece.YixianHutPieces;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFTags;

public class PFStructures {
    public static final ResourceKey<Structure> CHINLE_HUT = PFStructures.createKey("chinle_hut");
    public static final ResourceKey<Structure> ISCHIGUALASTO_HUT = PFStructures.createKey("ischigualasto_hut");
    public static final ResourceKey<Structure> MORRISON_HUT = PFStructures.createKey("morrison_hut");
    public static final ResourceKey<Structure> KAYENTA_HUT = PFStructures.createKey("kayenta_hut");
    public static final ResourceKey<Structure> HELL_CREEK_HUT = PFStructures.createKey("hell_creek_hut");
    public static final ResourceKey<Structure> DJADOCHTA_HUT = PFStructures.createKey("djadochta_hut");
    public static final ResourceKey<Structure> YIXIAN_HUT = PFStructures.createKey("yixian_hut");
    public static final ResourceKey<StructureSet> CHINLE_HUT_STRUCTURE_SET = PFStructures.registerStructureSet("chinle_hut");
    public static final ResourceKey<StructureSet> ISCHIGUALASTO_HUT_STRUCTURE_SET = PFStructures.registerStructureSet("ischigualasto_hut");
    public static final ResourceKey<StructureSet> MORRISON_HUT_STRUCTURE_SET = PFStructures.registerStructureSet("morrison_hut");
    public static final ResourceKey<StructureSet> KAYENTA_HUT_STRUCTURE_SET = PFStructures.registerStructureSet("kayenta_hut");
    public static final ResourceKey<StructureSet> HELL_CREEK_HUT_STRUCTURE_SET = PFStructures.registerStructureSet("hell_creek_hut");
    public static final ResourceKey<StructureSet> DJADOCHTA_HUT_STRUCTURE_SET = PFStructures.registerStructureSet("djadochta_hut");
    public static final ResourceKey<StructureSet> YIXIAN_HUT_STRUCTURE_SET = PFStructures.registerStructureSet("yixian_hut");

    public static void bootstrap(BootstapContext<Structure> bootstap) {
        HolderGetter holdergetter = bootstap.m_255420_(Registries.f_256952_);
        bootstap.m_255272_(CHINLE_HUT, (Object)new ChinleHutStructure(PFStructures.structure((HolderSet<Biome>)holdergetter.m_254956_(PFTags.HAS_CHINLE_HUT), TerrainAdjustment.NONE)));
        bootstap.m_255272_(ISCHIGUALASTO_HUT, (Object)new IschigualastoHutStructure(PFStructures.structure((HolderSet<Biome>)holdergetter.m_254956_(PFTags.HAS_ISCHIGUALASTO_HUT), TerrainAdjustment.NONE)));
        bootstap.m_255272_(MORRISON_HUT, (Object)new MorrisonHutStructure(PFStructures.structure((HolderSet<Biome>)holdergetter.m_254956_(PFTags.HAS_MORRISON_HUT), TerrainAdjustment.NONE)));
        bootstap.m_255272_(KAYENTA_HUT, (Object)new KayentaHutStructure(PFStructures.structure((HolderSet<Biome>)holdergetter.m_254956_(PFTags.HAS_KAYENTA_HUT), TerrainAdjustment.NONE)));
        bootstap.m_255272_(HELL_CREEK_HUT, (Object)new HellCreekHutStructure(PFStructures.structure((HolderSet<Biome>)holdergetter.m_254956_(PFTags.HAS_HELL_CREEK_HUT), TerrainAdjustment.NONE)));
        bootstap.m_255272_(DJADOCHTA_HUT, (Object)new DjadochtaHutStructure(PFStructures.structure((HolderSet<Biome>)holdergetter.m_254956_(PFTags.HAS_DJADOCHTA_HUT), TerrainAdjustment.NONE)));
        bootstap.m_255272_(YIXIAN_HUT, (Object)new YixianHutStructure(PFStructures.structure((HolderSet<Biome>)holdergetter.m_254956_(PFTags.HAS_YIXIAN_HUT), TerrainAdjustment.NONE)));
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> p_256015_, Map<MobCategory, StructureSpawnOverride> p_256297_, GenerationStep.Decoration p_255729_, TerrainAdjustment p_255865_) {
        return new Structure.StructureSettings(p_256015_, p_256297_, p_255729_, p_255865_);
    }

    private static Structure.StructureSettings structure(HolderSet<Biome> p_256501_, TerrainAdjustment p_255704_) {
        return PFStructures.structure(p_256501_, Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, p_255704_);
    }

    private static ResourceKey<Structure> createKey(String p_209873_) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("prehistoricfauna", p_209873_));
    }

    public static void bootstrapStructureSet(BootstapContext<StructureSet> bootstap) {
        HolderGetter holdergetter = bootstap.m_255420_(Registries.f_256944_);
        bootstap.m_255272_(CHINLE_HUT_STRUCTURE_SET, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)holdergetter.m_255043_(CHINLE_HUT))), (StructurePlacement)new RandomSpreadStructurePlacement(PrehistoricFaunaConfig.chinleHutMaxDistance, PrehistoricFaunaConfig.chinleHutMinDistance, RandomSpreadType.LINEAR, 591239123)));
        bootstap.m_255272_(ISCHIGUALASTO_HUT_STRUCTURE_SET, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)holdergetter.m_255043_(ISCHIGUALASTO_HUT))), (StructurePlacement)new RandomSpreadStructurePlacement(PrehistoricFaunaConfig.ischigualastoHutMaxDistance, PrehistoricFaunaConfig.ischigualastoHutMinDistance, RandomSpreadType.LINEAR, 96234812)));
        bootstap.m_255272_(MORRISON_HUT_STRUCTURE_SET, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)holdergetter.m_255043_(MORRISON_HUT))), (StructurePlacement)new RandomSpreadStructurePlacement(PrehistoricFaunaConfig.morrisonHutMaxDistance, PrehistoricFaunaConfig.morrisonHutMinDistance, RandomSpreadType.LINEAR, 612341942)));
        bootstap.m_255272_(KAYENTA_HUT_STRUCTURE_SET, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)holdergetter.m_255043_(KAYENTA_HUT))), (StructurePlacement)new RandomSpreadStructurePlacement(PrehistoricFaunaConfig.kayentaHutMaxDistance, PrehistoricFaunaConfig.kayentaHutMinDistance, RandomSpreadType.LINEAR, 851282139)));
        bootstap.m_255272_(HELL_CREEK_HUT_STRUCTURE_SET, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)holdergetter.m_255043_(HELL_CREEK_HUT))), (StructurePlacement)new RandomSpreadStructurePlacement(PrehistoricFaunaConfig.hellCreekHutMaxDistance, PrehistoricFaunaConfig.hellCreekHutMinDistance, RandomSpreadType.LINEAR, 6248341)));
        bootstap.m_255272_(DJADOCHTA_HUT_STRUCTURE_SET, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)holdergetter.m_255043_(DJADOCHTA_HUT))), (StructurePlacement)new RandomSpreadStructurePlacement(PrehistoricFaunaConfig.djadochtaHutMaxDistance, PrehistoricFaunaConfig.djadochtaHutMinDistance, RandomSpreadType.LINEAR, 85923812)));
        bootstap.m_255272_(YIXIAN_HUT_STRUCTURE_SET, (Object)new StructureSet(List.of(StructureSet.m_210015_((Holder)holdergetter.m_255043_(YIXIAN_HUT))), (StructurePlacement)new RandomSpreadStructurePlacement(PrehistoricFaunaConfig.yixianHutMaxDistance, PrehistoricFaunaConfig.yixianHutMinDistance, RandomSpreadType.LINEAR, 5381239)));
    }

    private static ResourceKey<StructureSet> registerStructureSet(String p_209839_) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)new ResourceLocation("prehistoricfauna", p_209839_));
    }

    public static interface PFStructurePieceType {
        public static final DeferredRegister<StructurePieceType> REGISTRY = DeferredRegister.create((ResourceKey)Registries.f_256786_, (String)"prehistoricfauna");
        public static final RegistryObject<StructurePieceType> CHINLE_HUT = PFStructurePieceType.register(ChinleHutPieces.ChinleHutPiece::new, "chinle_hut");
        public static final RegistryObject<StructurePieceType> ISCHIGUALASTO_HUT = PFStructurePieceType.register(IschigualastoHutPieces.IschigualastoHutPiece::new, "ischigualasto_hut");
        public static final RegistryObject<StructurePieceType> MORRISON_HUT = PFStructurePieceType.register(MorrisonHutPieces.MorrisonHutPiece::new, "morrison_hut");
        public static final RegistryObject<StructurePieceType> KAYENTA_HUT = PFStructurePieceType.register(KayentaHutPieces.KayentaHutPiece::new, "kayenta_hut");
        public static final RegistryObject<StructurePieceType> HELL_CREEK_HUT = PFStructurePieceType.register(HellCreekHutPieces.HellCreekHutPiece::new, "hell_creek_hut");
        public static final RegistryObject<StructurePieceType> DJADOCHTA_HUT = PFStructurePieceType.register(DjadochtaHutPieces.DjadochtaHutPiece::new, "djadochta_hut");
        public static final RegistryObject<StructurePieceType> YIXIAN_HUT = PFStructurePieceType.register(YixianHutPieces.YixianHutPiece::new, "yixian_hut");

        private static RegistryObject<StructurePieceType> register(StructurePieceType.StructureTemplateType type, String string) {
            return REGISTRY.register(string, () -> StructurePieceType.m_210155_((StructurePieceType.StructureTemplateType)type, (String)string.toLowerCase(Locale.ROOT)));
        }
    }

    public static interface PFStructureType<S extends Structure>
    extends StructureType<S> {
        public static final DeferredRegister<StructureType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.f_256938_, (String)"prehistoricfauna");
        public static final RegistryObject<StructureType<ChinleHutStructure>> CHINLE_HUT = PFStructureType.register("chinle_hut", ChinleHutStructure.CODEC);
        public static final RegistryObject<StructureType<IschigualastoHutStructure>> ISCHIGUALASTO_HUT = PFStructureType.register("ischigualasto_hut", IschigualastoHutStructure.CODEC);
        public static final RegistryObject<StructureType<MorrisonHutStructure>> MORRISON_HUT = PFStructureType.register("morrison_hut", MorrisonHutStructure.CODEC);
        public static final RegistryObject<StructureType<KayentaHutStructure>> KAYENTA_HUT = PFStructureType.register("kayenta_hut", KayentaHutStructure.CODEC);
        public static final RegistryObject<StructureType<HellCreekHutStructure>> HELL_CREEK_HUT = PFStructureType.register("hell_creek_hut", HellCreekHutStructure.CODEC);
        public static final RegistryObject<StructureType<DjadochtaHutStructure>> DJADOCHTA_HUT = PFStructureType.register("djadochta_hut", DjadochtaHutStructure.CODEC);
        public static final RegistryObject<StructureType<YixianHutStructure>> YIXIAN_HUT = PFStructureType.register("yixian_hut", YixianHutStructure.CODEC);

        private static <S extends Structure> RegistryObject<StructureType<S>> register(String string, Codec<S> codec) {
            return REGISTRY.register(string, () -> StructureType.m_226881_((String)string, (Codec)codec));
        }
    }
}

