/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.init;

import com.mojang.serialization.Codec;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import superlord.prehistoricfauna.common.world.PFBiomeModifier;
import superlord.prehistoricfauna.init.PFPlacedFeatures;
import superlord.prehistoricfauna.init.PFTags;

public class PFBiomeModifiers {
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"prehistoricfauna");
    public static final RegistryObject<Codec<PFBiomeModifier>> PF_BIOME_MODIFIER_TYPE = BIOME_MODIFIER_SERIALIZERS.register("prehistoric_fauna_biome_modifier", () -> PFBiomeModifier.CODEC);
    public static final ResourceKey<BiomeModifier> ADD_OVERWORLD_FOSSILS = PFBiomeModifiers.register("add_overworld_fossils");
    public static final ResourceKey<BiomeModifier> ADD_CRETACEOUS_FOSSILS = PFBiomeModifiers.register("add_cretaceous_fossils");
    public static final ResourceKey<BiomeModifier> ADD_JURASSIC_FOSSILS = PFBiomeModifiers.register("add_jurassic_fossils");
    public static final ResourceKey<BiomeModifier> ADD_PETRIFIED_TREES = PFBiomeModifiers.register("add_petrified_trees");

    public static void bootstrap(BootstapContext<BiomeModifier> bootstapContext) {
        bootstapContext.m_255272_(ADD_OVERWORLD_FOSSILS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(PFBiomeModifiers.getBiome(bootstapContext, (TagKey<Biome>)BiomeTags.f_215817_), PFBiomeModifiers.getPlacedFeature(bootstapContext, PFPlacedFeatures.FOSSILIZED_CHALK, PFPlacedFeatures.FOSSILIZED_SANDSTONE, PFPlacedFeatures.FOSSILIZED_SILTSTONE), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstapContext.m_255272_(ADD_CRETACEOUS_FOSSILS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(PFBiomeModifiers.getBiome(bootstapContext, PFTags.IS_CRETACEOUS), PFBiomeModifiers.getPlacedFeature(bootstapContext, PFPlacedFeatures.CRETACEOUS_FOSSILIZED_SANDSTONE, PFPlacedFeatures.CRETACEOUS_FOSSILIZED_SILTSTONE), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstapContext.m_255272_(ADD_JURASSIC_FOSSILS, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(PFBiomeModifiers.getBiome(bootstapContext, PFTags.IS_JURASSIC), PFBiomeModifiers.getPlacedFeature(bootstapContext, PFPlacedFeatures.JURASSIC_FOSSILIZED_SANDSTONE), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstapContext.m_255272_(ADD_PETRIFIED_TREES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(PFBiomeModifiers.getBiome(bootstapContext, (TagKey<Biome>)BiomeTags.f_207607_), PFBiomeModifiers.getPlacedFeature(bootstapContext, PFPlacedFeatures.PLACED_PETRIFIED_TREE), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    @NotNull
    private static HolderSet.Direct<Biome> getBiome(BootstapContext<BiomeModifier> bootstapContext, ResourceKey<Biome> biome) {
        return HolderSet.m_205809_((Holder[])new Holder[]{bootstapContext.m_255420_(Registries.f_256952_).m_255043_(biome)});
    }

    @SafeVarargs
    @NotNull
    private static HolderSet.Direct<Biome> getBiome(BootstapContext<BiomeModifier> bootstapContext, ResourceKey<Biome> ... biome) {
        return HolderSet.m_205800_(Stream.of(biome).map(resourceKey -> bootstapContext.m_255420_(Registries.f_256952_).m_255043_(resourceKey)).collect(Collectors.toList()));
    }

    private static HolderSet.Named<Biome> getBiome(BootstapContext<BiomeModifier> bootstapContex, TagKey<Biome> biome) {
        return bootstapContex.m_255420_(Registries.f_256952_).m_254956_(biome);
    }

    @SafeVarargs
    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> ... placedFeature) {
        return HolderSet.m_205800_(Stream.of(placedFeature).map(resourceKey -> context.m_255420_(Registries.f_256988_).m_255043_(resourceKey)).collect(Collectors.toList()));
    }

    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeature) {
        return HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(placedFeature)});
    }

    @NotNull
    private static ResourceKey<BiomeModifier> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("prehistoricfauna", name));
    }
}

