/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.world.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import superlord.prehistoricfauna.common.util.FastNoise;
import superlord.prehistoricfauna.common.world.biome.biomesource.TriassicBiomeSource;
import superlord.prehistoricfauna.common.world.biome.surfacedecorators.SurfaceDecorators;
import superlord.prehistoricfauna.common.world.chunkgen.FastNoiseDensityFunction;
import superlord.prehistoricfauna.init.PFBiomes;
import superlord.prehistoricfauna.init.PFBlocks;

public class TriassicChunkGenerator
extends ChunkGenerator {
    public static final Codec<TriassicChunkGenerator> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(generator -> generator.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(generator -> generator.settings)).apply((Applicative)codec, codec.stable(TriassicChunkGenerator::new)));
    protected final Holder<NoiseGeneratorSettings> settings;
    protected final Climate.Sampler sampler;
    static Random random = new Random();
    private long seed = random.nextLong();
    public static final FastNoise noise = new FastNoise(0);
    private float[][][] terrainShapeSamplePoints;

    public TriassicChunkGenerator(BiomeSource pBiomeSource, Holder<NoiseGeneratorSettings> settings) {
        this(pBiomeSource, settings, random.nextLong());
    }

    public TriassicChunkGenerator(BiomeSource pBiomeSource, Holder<NoiseGeneratorSettings> settings, long seed) {
        super(pBiomeSource);
        this.settings = settings;
        this.seed = seed;
        this.sampler = new Climate.Sampler((DensityFunction)new FastNoiseDensityFunction(noise), (DensityFunction)new FastNoiseDensityFunction(noise, 400.0f), (DensityFunction)new FastNoiseDensityFunction(noise, -400.0f), (DensityFunction)new FastNoiseDensityFunction(noise, 800.0f), (DensityFunction)new FastNoiseDensityFunction(noise, -800.0f), (DensityFunction)new FastNoiseDensityFunction(noise, 1200.0f), new ArrayList());
        this.initializeNoise(seed);
    }

    public void initializeNoise(long seed) {
        int seedBits = (int)(seed >> 32);
        if (noise.GetSeed() != seedBits) {
            noise.SetSeed(seedBits);
        }
        SurfaceDecorators.setFastNoise(noise);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion region, long seed, RandomState p_223045_, BiomeManager manager, StructureManager structureFeatureManager, ChunkAccess chunk, GenerationStep.Carving genStep) {
    }

    public void m_214194_(WorldGenRegion region, StructureManager structureFeatureManager, RandomState p_223052_, ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                int startHeight = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
                pos.m_122178_(x + chunk.m_7697_().m_45604_(), startHeight, z + chunk.m_7697_().m_45605_());
                boolean isInSolid = false;
                boolean visibleToSun = true;
                while (pos.m_123342_() > this.m_142062_() + 5) {
                    ResourceLocation biome = (ResourceLocation)region.m_204166_((BlockPos)pos).m_203439_().map(resourceKey -> resourceKey.m_135782_(), noKey -> null);
                    if (chunk.m_8055_((BlockPos)pos) == ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64440_()) {
                        if (!isInSolid) {
                            SurfaceDecorators.getSurfaceDecorator(biome).buildSurface(pos, this.m_6337_(), visibleToSun, chunk, (NoiseGeneratorSettings)this.settings.m_203334_());
                            isInSolid = true;
                            visibleToSun = false;
                            continue block1;
                        }
                    } else {
                        isInSolid = false;
                    }
                    pos.m_122173_(Direction.DOWN);
                }
            }
        }
    }

    public double calculateNoiseValue(int x, int z, FastNoise noise) {
        float frequency = 0.5f;
        float amplitude = 4.0f;
        double noiseX = noise.GetNoise((float)x * frequency, (float)z * frequency);
        double noiseZ = noise.GetNoise((float)x * frequency, (float)z * frequency);
        double combinedNoise = (double)amplitude * (noiseX + noiseZ);
        return combinedNoise;
    }

    public void m_6929_(WorldGenRegion region) {
        ChunkPos chunkpos = region.m_143488_();
        Holder holder = region.m_204166_(chunkpos.m_45615_().m_175288_(region.m_151558_() - 1));
        WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_224599_()));
        worldgenRandom.m_64690_(region.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
        NaturalSpawner.m_220450_((ServerLevelAccessor)region, (Holder)holder, (ChunkPos)chunkpos, (RandomSource)worldgenRandom);
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState p_223211_, StructureManager manager, ChunkAccess chunk) {
        this.fillNoiseSampleArrays(chunk);
        Heightmap[] heightmaps = new Heightmap[]{chunk.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG), chunk.m_6005_(Heightmap.Types.WORLD_SURFACE_WG)};
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = this.getMaxY(); y >= this.m_142062_(); --y) {
                    BlockState state;
                    Random random = new Random();
                    pos.m_122178_(x, y, z);
                    float sample = this.sampleDensityFromArray(this.terrainShapeSamplePoints, x, y, z);
                    if (sample > 0.0f) {
                        BiomeManager biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)((TriassicBiomeSource)this.m_62218_()), this.seed);
                        Holder biome = biomeManager.m_204214_(new BlockPos(x + chunk.m_7697_().m_45604_(), pos.m_123342_(), z + chunk.m_7697_().m_45605_()));
                        state = biome.m_203565_(PFBiomes.TRIASSIC_HENOSTONE_CAVE) ? ((Block)PFBlocks.HENOSTONE.get()).m_49966_() : (y < 0 + -random.nextInt(5) ? Blocks.f_152550_.m_49966_() : ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64440_());
                        if (y <= this.m_142062_() + random.nextInt(4)) {
                            state = Blocks.f_50752_.m_49966_();
                        }
                    } else {
                        state = y <= this.m_142062_() + random.nextInt(4) ? Blocks.f_50752_.m_49966_() : (y < this.m_6337_() ? this.getAirAtPos(chunk, x + chunk.m_7697_().m_45604_(), y, z + chunk.m_7697_().m_45605_()) : Blocks.f_50016_.m_49966_());
                    }
                    for (Heightmap heightmap : heightmaps) {
                        heightmap.m_64249_(x, y, z, state);
                    }
                    chunk.m_6978_((BlockPos)pos, state, false);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    private boolean shouldHaveFluid(BlockPos pos) {
        BiomeManager biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)((TriassicBiomeSource)this.m_62218_()), this.seed);
        Holder biome = biomeManager.m_204214_(new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        if (pos.m_123342_() <= this.m_6337_()) {
            return biome.m_203565_(PFBiomes.ISCHIGUALASTO_RIVER) || biome.m_203565_(PFBiomes.CHINLE_RIVER) || biome.m_203565_(PFBiomes.CHINLE_SWAMP) || (double)noise.GetNoise((float)pos.m_123341_() * 0.8f, pos.m_123342_(), (float)pos.m_123343_() * 0.8f) > 0.7;
        }
        return false;
    }

    private BlockState getAirAtPos(ChunkAccess chunk, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (this.shouldHaveFluid(pos)) {
            if (!(this.shouldHaveFluid(new BlockPos(x + 1, y + 0, z + 0)) && this.shouldHaveFluid(new BlockPos(x + 0, y + 0, z + 1)) && this.shouldHaveFluid(new BlockPos(x - 1, y + 0, z + 0)) && this.shouldHaveFluid(new BlockPos(x + 0, y + 0, z - 1)) && this.shouldHaveFluid(new BlockPos(x + 0, y - 1, z + 0)))) {
                return Blocks.f_50069_.m_49966_();
            }
            return Blocks.f_49990_.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    private float sampleDensity(float x, float y, float z) {
        int seaLevel = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
        if (y > (float)seaLevel) {
            y += 3.0f;
        }
        BiomeManager biomeManager = new BiomeManager((BiomeManager.NoiseBiomeSource)((TriassicBiomeSource)this.m_62218_()), this.seed);
        Holder biome = biomeManager.m_204214_(new BlockPos((int)x, (int)y, (int)z));
        float baseDensity = this.calculateBaseDensity(x, y, z, (Holder<Biome>)biome);
        int blendRadius = 16;
        int blendStep = 4;
        float blendedDensity = baseDensity;
        int blendCount = 1;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int size = Math.floorDiv(blendRadius, blendStep);
        for (BlockPos.MutableBlockPos blockPos : BlockPos.m_121935_((BlockPos)BlockPos.f_121853_, (int)size, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            double distToLowCornerSqr;
            int nx = (int)(x + (float)(blockPos.m_123341_() * blendStep));
            int nz = (int)(z + (float)(blockPos.m_123343_() * blendStep));
            mutableBlockPos.m_122178_(nx, (int)y, nz);
            Holder nearbyBiome = biomeManager.m_204214_((BlockPos)mutableBlockPos);
            if (nearbyBiome == biome) continue;
            if (nearbyBiome.m_203565_(PFBiomes.CHINLE_RIVER) || nearbyBiome.m_203565_(PFBiomes.ISCHIGUALASTO_RIVER)) {
                distToLowCornerSqr = mutableBlockPos.m_203202_((double)x, (double)y, (double)z);
                if (!(distToLowCornerSqr < (double)Mth.m_144944_((int)blendRadius))) continue;
                double delta = distToLowCornerSqr / (double)Mth.m_144944_((int)blendRadius);
                blendedDensity += this.blendSmoothstep((float)delta, this.flatsSample(x, y, z), baseDensity);
                ++blendCount;
                continue;
            }
            distToLowCornerSqr = mutableBlockPos.m_203202_((double)x, (double)y, (double)z);
            if (!(distToLowCornerSqr < (double)Mth.m_144944_((int)blendRadius))) continue;
            float nearbyDensity = this.calculateBaseDensity(nx, y, nz, (Holder<Biome>)nearbyBiome);
            double delta = distToLowCornerSqr / (double)Mth.m_144944_((int)blendRadius);
            blendedDensity += this.blendSmoothstep((float)delta, nearbyDensity, baseDensity);
            ++blendCount;
        }
        float finalDensity = blendedDensity / (float)blendCount;
        float smoothingNoise = noise.GetNoise(x * 0.1f, y * 0.1f, z * 0.1f);
        finalDensity = Mth.m_14179_((float)0.2f, (float)finalDensity, (float)(finalDensity + smoothingNoise * 0.1f));
        return finalDensity;
    }

    private float blendSmoothstep(float delta, float value1, float value2) {
        float smoothDelta = delta * delta * (3.0f - 2.0f * delta);
        return Mth.m_14179_((float)smoothDelta, (float)value1, (float)value2);
    }

    public float flatsSample(float x, float y, float z) {
        int seaLevel = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
        if (y > (float)seaLevel) {
            y += 3.0f;
        }
        float frequency1 = 0.3f;
        float sample = noise.GetNoise(x * frequency1, y * frequency1 * 0.8f, z * frequency1);
        float floor = -0.2f;
        float smoothness = 0.001f;
        float h = Mth.m_14036_((float)(0.5f + 0.5f * (sample - floor) / smoothness), (float)0.0f, (float)1.0f);
        sample = Mth.m_14179_((float)sample, (float)floor, (float)h) - smoothness * h * (1.0f - h);
        float flatsFrequency = 3.0f;
        float flatsNoise = noise.GetNoise(x * flatsFrequency, 0.0f, z * flatsFrequency);
        flatsNoise = 1.0f - flatsNoise * flatsNoise;
        flatsNoise *= y - (float)seaLevel;
        float frequency2 = 2.5f;
        sample += Mth.m_14154_((float)(noise.GetNoise(x * frequency2, y * frequency2, z * frequency2) * 0.2f));
        float frequency3 = 3.5f;
        sample += Mth.m_14154_((float)(noise.GetNoise(x * frequency3, y * frequency3, z * frequency3) * 0.05f));
        sample -= 0.15f;
        sample -= flatsNoise;
        return sample -= 2.0f;
    }

    public float calculateBaseDensity(float x, float y, float z, Holder<Biome> biome) {
        int seaLevel = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
        if (y > (float)seaLevel) {
            y += 3.0f;
        }
        float frequency1 = 0.3f;
        float sample = noise.GetNoise(x * frequency1, y * frequency1 * 0.8f, z * frequency1);
        float floor = -0.2f;
        float smoothness = 0.001f;
        float h = Mth.m_14036_((float)(0.5f + 0.5f * (sample - floor) / smoothness), (float)0.0f, (float)1.0f);
        sample = Mth.m_14179_((float)sample, (float)floor, (float)h) - smoothness * h * (1.0f - h);
        float bigRockFrequency = 0.4f;
        float rockNoise = noise.GetNoise(x * bigRockFrequency, y * frequency1 + 512.0f, z * bigRockFrequency);
        float bigRockNoise = Mth.m_14116_((float)(sample * sample + rockNoise * rockNoise));
        bigRockNoise = sample < 0.0f || rockNoise < 0.0f ? 1.0f : bigRockNoise;
        float bigRockStrength = 0.2f;
        bigRockNoise *= bigRockStrength;
        bigRockNoise += 1.0f - bigRockStrength;
        float hugeCliffFrequency = 0.1f;
        float hugeCliffNoise = noise.GetNoise(x * hugeCliffFrequency, 2834.0f, z * hugeCliffFrequency);
        hugeCliffNoise = (float)Mth.m_14008_((double)Math.pow(1.3 * (double)hugeCliffNoise, 12.0), (double)0.0, (double)1.0) * 5.0f;
        float hugeCliffWobble = -0.5f * Mth.m_14089_((float)((float)Math.PI * 2 * hugeCliffNoise)) + 0.5f;
        float lumpFrequency = 4.3f;
        float cliffLumpiness = noise.GetNoise(x * lumpFrequency, y * lumpFrequency * 0.8f, z * lumpFrequency);
        cliffLumpiness *= (hugeCliffWobble *= 1.5f) * 0.1f;
        float riverFrequency = 0.1f;
        float riverNoise = noise.GetNoise(x * riverFrequency, 0.0f, z * riverFrequency);
        riverNoise = 1.0f - riverNoise * riverNoise;
        riverNoise *= y - (float)seaLevel;
        float flatsFrequency = 3.0f;
        float flatsNoise = noise.GetNoise(x * flatsFrequency, 0.0f, z * flatsFrequency);
        flatsNoise = 1.0f - flatsNoise * flatsNoise;
        flatsNoise *= y - (float)seaLevel;
        float bigHillRockFrequency = 0.4f;
        float hillRockNoise = noise.GetNoise(x * bigHillRockFrequency, y * frequency1 + 512.0f, z * bigHillRockFrequency);
        float bigHillRockNoise = Mth.m_14116_((float)(sample * sample + hillRockNoise * hillRockNoise));
        bigHillRockNoise = sample < 0.0f || hillRockNoise < 0.0f ? 1.0f : bigHillRockNoise;
        float bigHillRockStrength = 0.2f;
        bigHillRockNoise *= bigHillRockStrength;
        bigHillRockNoise += 1.0f - bigHillRockStrength;
        float hillFrequency = 0.1f;
        float hillNoise = noise.GetNoise(x * hillFrequency, 2834.0f, z * hillFrequency);
        hillNoise = (float)Mth.m_14008_((double)Math.pow(1.3 * (double)hillNoise, 12.0), (double)0.0, (double)1.0) * 0.4f;
        float hillWobble = -0.5f * Mth.m_14089_((float)((float)Math.PI * 2 * hillNoise)) + 0.5f;
        float hillLumpFrequency = 4.3f;
        float hillLumpiness = noise.GetNoise(x * hillLumpFrequency, y * hillLumpFrequency * 1.8f, z * hillLumpFrequency);
        hillLumpiness *= (hillWobble *= 1.5f) * 0.1f;
        float swampFrequency = 1.5f;
        float swampNoise = noise.GetNoise(x * swampFrequency, 0.0f, z * swampFrequency);
        swampNoise = 1.5f - swampNoise * swampNoise;
        swampNoise = (float)((double)swampNoise * (((double)(y - (float)seaLevel) + 0.55) * 1.1));
        if (biome.m_203565_(PFBiomes.ISCHIGUALASTO_HILLS)) {
            sample += hillLumpiness;
        }
        if (biome.m_203565_(PFBiomes.CHINLE_WOODED_MOUNTAINS)) {
            sample += cliffLumpiness;
        }
        float frequency2 = 2.5f;
        sample += Mth.m_14154_((float)(noise.GetNoise(x * frequency2, y * frequency2, z * frequency2) * 0.2f));
        float frequency3 = 3.5f;
        sample += Mth.m_14154_((float)(noise.GetNoise(x * frequency3, y * frequency3, z * frequency3) * 0.05f));
        sample -= 0.15f;
        if (biome.m_203565_(PFBiomes.CHINLE_RIVER) || biome.m_203565_(PFBiomes.ISCHIGUALASTO_RIVER)) {
            sample -= riverNoise;
            sample *= 8.0f;
            sample -= 22.0f;
        }
        if (biome.m_203565_(PFBiomes.ISCHIGUALASTO_CLEARING) || biome.m_203565_(PFBiomes.ISCHIGUALASTO_FOREST) || biome.m_203565_(PFBiomes.CHINLE_FLATS)) {
            sample -= flatsNoise;
        }
        if (biome.m_203565_(PFBiomes.ISCHIGUALASTO_HILLS)) {
            sample *= 1.6f;
            sample = (float)((double)sample + 0.4);
            sample -= (y - (float)((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_() - hillNoise * 64.0f) / (16.0f / bigHillRockNoise * (hillWobble + 1.0f));
            sample *= 1.8f;
        }
        if (biome.m_203565_(PFBiomes.CHINLE_WOODED_MOUNTAINS)) {
            sample *= 2.4f;
            sample = (float)((double)sample + 1.25);
            sample -= (y - (float)((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_() - hugeCliffNoise * 64.0f) / (16.0f / bigRockNoise * (hugeCliffWobble + 1.0f));
        }
        if (biome.m_203565_(PFBiomes.CHINLE_SWAMP)) {
            sample -= swampNoise;
            sample *= 3.3f;
            sample -= 4.75f;
        }
        if (y < 60.0f) {
            sample *= 1.0f;
            sample = (float)((double)sample + 0.4);
            sample -= (y - (float)((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_() - hillNoise * 64.0f) / (16.0f / bigHillRockNoise * (hillWobble + 1.0f));
            sample *= 6.6f;
        }
        if (y > -60.0f) {
            float sample1 = noise.GetNoise(x, y, z);
            float sample2 = noise.GetNoise(x, y + 1.0381903E7f, z);
            float caveSample = sample1 * sample1 + sample2 * sample2;
            caveSample /= 2.0f;
            caveSample = (float)((double)caveSample * 1.5);
            caveSample = (float)((double)caveSample - 0.02);
            sample = Math.min(sample, caveSample);
        }
        return sample;
    }

    public void fillNoiseSampleArrays(ChunkAccess chunk) {
        int hSamplePoints = (int)Math.ceil(4.8f);
        int vSamplePoints = (int)Math.ceil((float)this.m_6331_() * 0.15f);
        float hOffset = 16.0f / (float)hSamplePoints;
        float vOffset = (float)this.m_6331_() / (float)vSamplePoints;
        this.terrainShapeSamplePoints = new float[hSamplePoints + 1][vSamplePoints][hSamplePoints + 1];
        for (int sX = 0; sX < hSamplePoints + 1; ++sX) {
            for (int sZ = 0; sZ < hSamplePoints + 1; ++sZ) {
                for (int sY = 0; sY < vSamplePoints; ++sY) {
                    float cX = (float)sX * hOffset;
                    float cY = (float)sY * vOffset;
                    float cZ = (float)sZ * hOffset;
                    float x = cX + (float)chunk.m_7697_().m_45604_();
                    float z = cZ + (float)chunk.m_7697_().m_45605_();
                    float y = cY + (float)chunk.m_141937_();
                    this.terrainShapeSamplePoints[sX][sY][sZ] = this.sampleDensity(x, y, z);
                }
            }
        }
    }

    public float sampleDensityFromArray(float[][][] densityArray, int localX, int localY, int localZ) {
        int maxXZ = 16;
        int maxY = this.m_6331_();
        float xzSampleRes = (float)(densityArray.length - 1) / (float)maxXZ;
        float ySampleRes = (float)(densityArray[0].length - 1) / (float)maxY;
        float sampleX = (float)localX * xzSampleRes;
        float sxFrac = Mth.m_14187_((float)sampleX);
        int sxF = Mth.m_14143_((float)sampleX);
        int sxC = Mth.m_14167_((float)sampleX);
        float sampleY = (float)(localY - this.m_142062_()) * ySampleRes;
        float syFrac = Mth.m_14187_((float)sampleY);
        int syF = Mth.m_14143_((float)sampleY);
        int syC = Mth.m_14167_((float)sampleY);
        float sampleZ = (float)localZ * xzSampleRes;
        float szFrac = Mth.m_14187_((float)sampleZ);
        int szF = Mth.m_14143_((float)sampleZ);
        int szC = Mth.m_14167_((float)sampleZ);
        float xLerp1 = Mth.m_14179_((float)sxFrac, (float)densityArray[sxF][syF][szF], (float)densityArray[sxC][syF][szF]);
        float xLerp2 = Mth.m_14179_((float)sxFrac, (float)densityArray[sxF][syF][szC], (float)densityArray[sxC][syF][szC]);
        float zLerp1 = Mth.m_14179_((float)szFrac, (float)xLerp1, (float)xLerp2);
        float xLerp3 = Mth.m_14179_((float)sxFrac, (float)densityArray[sxF][syC][szF], (float)densityArray[sxC][syC][szF]);
        float xLerp4 = Mth.m_14179_((float)sxFrac, (float)densityArray[sxF][syC][szC], (float)densityArray[sxC][syC][szC]);
        float zLerp2 = Mth.m_14179_((float)szFrac, (float)xLerp3, (float)xLerp4);
        float yLerp = Mth.m_14179_((float)Mth.m_14179_((float)Mth.m_14036_((float)((float)(localY - this.m_6337_()) / 64.0f), (float)0.0f, (float)1.0f), (float)(syFrac * syFrac * syFrac), (float)syFrac), (float)zLerp1, (float)zLerp2);
        return yLerp;
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
    }

    public int m_6331_() {
        return this.getMaxY() - this.m_142062_();
    }

    public int m_142062_() {
        return -64;
    }

    public int getMaxY() {
        return 256;
    }

    public int m_214096_(int p_156153_, int p_156154_, Heightmap.Types type, LevelHeightAccessor accessor, RandomState p_223036_) {
        return this.m_6337_();
    }

    public NoiseColumn m_214184_(int p_156150_, int p_156151_, LevelHeightAccessor chunk, RandomState p_223031_) {
        BlockState[] states = new BlockState[chunk.m_141928_()];
        int iY = 0;
        for (int y = chunk.m_141937_(); y < chunk.m_151558_(); ++y) {
            states[iY] = Blocks.f_50016_.m_49966_();
            ++iY;
        }
        return new NoiseColumn(chunk.m_141937_(), states);
    }

    public void m_213600_(List<String> string, RandomState state, BlockPos pos) {
    }

    static {
        noise.SetNoiseType(FastNoise.NoiseType.Simplex);
    }
}

