/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.world.biome.biomesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import superlord.prehistoricfauna.common.util.FastNoise;
import superlord.prehistoricfauna.common.world.chunkgen.TriassicChunkGenerator;
import superlord.prehistoricfauna.init.PFBiomes;

public class TriassicBiomeSource
extends BiomeSource
implements BiomeManager.NoiseBiomeSource {
    public static final Codec<TriassicBiomeSource> CODEC = RecordCodecBuilder.create((T p_48644_) -> p_48644_.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(biomeGetter -> null)).apply((Applicative)p_48644_, p_48644_.stable(TriassicBiomeSource::new)));
    private final Holder<Biome> chinleRiver;
    private final Holder<Biome> chinleFlats;
    private final Holder<Biome> chinleSwamp;
    private final Holder<Biome> chinleWoodedMountains;
    private final Holder<Biome> ischigualastoRiver;
    private final Holder<Biome> ischigualastoForest;
    private final Holder<Biome> ischigualastoClearing;
    private final Holder<Biome> ischigualastoHills;
    private final Holder<Biome> prehistoricDripstoneCave;
    private final Holder<Biome> henostoneCave;
    public double noiseValue;

    public TriassicBiomeSource(HolderGetter<Biome> biome) {
        this((Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_FLATS), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_WOODED_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.TRIASSIC_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.TRIASSIC_HENOSTONE_CAVE));
    }

    public static TriassicBiomeSource create(HolderGetter<Biome> biome) {
        return new TriassicBiomeSource((Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_FLATS), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_WOODED_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.TRIASSIC_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.TRIASSIC_HENOSTONE_CAVE));
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return Stream.of(this.chinleFlats, this.chinleRiver, this.chinleSwamp, this.chinleWoodedMountains, this.ischigualastoClearing, this.ischigualastoForest, this.ischigualastoHills, this.ischigualastoRiver, this.prehistoricDripstoneCave, this.henostoneCave);
    }

    public TriassicBiomeSource(Holder<Biome> chinleRiver, Holder<Biome> chinleFlats, Holder<Biome> chinleSwamp, Holder<Biome> chinleWoodedMountains, Holder<Biome> ischigualastoRiver, Holder<Biome> ischigualastoForest, Holder<Biome> ischigualastoClearing, Holder<Biome> ischigualastoHills, Holder<Biome> prehistoricDripstoneCave, Holder<Biome> henostoneCave) {
        this.chinleRiver = chinleRiver;
        this.chinleFlats = chinleFlats;
        this.chinleSwamp = chinleSwamp;
        this.chinleWoodedMountains = chinleWoodedMountains;
        this.ischigualastoRiver = ischigualastoRiver;
        this.ischigualastoForest = ischigualastoForest;
        this.ischigualastoHills = ischigualastoHills;
        this.ischigualastoClearing = ischigualastoClearing;
        this.prehistoricDripstoneCave = prehistoricDripstoneCave;
        this.henostoneCave = henostoneCave;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler p_204241_) {
        return this.m_203495_(x, y, z);
    }

    public double timeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.6f, (float)z * 0.6f);
    }

    public double tempNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.2f, (float)z * 0.2f);
    }

    public double hillinessNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.4f, (float)z * 0.4f);
    }

    public double humidityNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.7f, (float)z * 0.7f);
    }

    public double caveTimeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.3f, (float)y * 0.3f, (float)z * 0.3f);
    }

    public double getNoiseValue() {
        return this.noiseValue;
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        double timelineNoise = this.timeLineNoise(x, y, z, TriassicChunkGenerator.noise);
        double tempNoise = this.tempNoise(x, y, z, TriassicChunkGenerator.noise);
        double humidityNoise = this.humidityNoise(x, y, z, TriassicChunkGenerator.noise);
        double hillinessNoise = this.hillinessNoise(x, y, z, TriassicChunkGenerator.noise);
        double caveTimeLineNoise = this.caveTimeLineNoise(x, y, z, TriassicChunkGenerator.noise);
        if (y < 6) {
            if (humidityNoise > 0.4) {
                return this.prehistoricDripstoneCave;
            }
            if (caveTimeLineNoise > 0.8) {
                return this.henostoneCave;
            }
        }
        if (timelineNoise >= (double)0.0222f) {
            if (hillinessNoise > 0.5) {
                return this.chinleWoodedMountains;
            }
            if (tempNoise > (double)0.3f) {
                return this.chinleFlats;
            }
            return this.chinleSwamp;
        }
        if (timelineNoise < (double)0.0222f && timelineNoise >= 0.0) {
            return this.chinleRiver;
        }
        if (timelineNoise <= (double)-0.0222f) {
            if (hillinessNoise > (double)0.3f) {
                return this.ischigualastoHills;
            }
            if (hillinessNoise < (double)-0.4f) {
                return this.ischigualastoClearing;
            }
            return this.ischigualastoForest;
        }
        return this.ischigualastoRiver;
    }
}

