/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.world.biome.biomesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import superlord.prehistoricfauna.common.util.FastNoise;
import superlord.prehistoricfauna.init.PFBiomes;

public class PrehistoricBiomeSource
extends BiomeSource
implements BiomeManager.NoiseBiomeSource {
    public static final Codec<PrehistoricBiomeSource> CODEC = RecordCodecBuilder.create((T p_48644_) -> p_48644_.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(biomeGetter -> null)).apply((Applicative)p_48644_, p_48644_.stable(PrehistoricBiomeSource::new)));
    private final Holder<Biome> chinleFlats;
    private final Holder<Biome> chinleRiver;
    private final Holder<Biome> chinleSwamp;
    private final Holder<Biome> chinleWoodedMountains;
    private final Holder<Biome> ischigualastoRiver;
    private final Holder<Biome> ischigualastoClearing;
    private final Holder<Biome> ischigualastoForest;
    private final Holder<Biome> ischigualastoHills;
    private final Holder<Biome> kayentaDryForest;
    private final Holder<Biome> kayentaButtes;
    private final Holder<Biome> kayentaDesert;
    private final Holder<Biome> kayentaRiver;
    private final Holder<Biome> morrisonSavanna;
    private final Holder<Biome> morrisonHills;
    private final Holder<Biome> hellCreekHardwoodForest;
    private final Holder<Biome> hellCreekClearing;
    private final Holder<Biome> hellCreekBluffs;
    private final Holder<Biome> hellCreekRedwoods;
    private final Holder<Biome> hellCreekSwamp;
    private final Holder<Biome> hellCreekRiver;
    private final Holder<Biome> djadochtaDunes;
    private final Holder<Biome> djadochtaArroyo;
    private final Holder<Biome> djadochtaAlluvialPlains;
    private final Holder<Biome> yixianForest;
    private final Holder<Biome> yixianLakes;
    private final Holder<Biome> yixianSnowyForest;
    private final Holder<Biome> yixianSnowyMountains;
    private final Holder<Biome> yixianRegrowth;
    private final Holder<Biome> yixianVolcano;
    private final Holder<Biome> dripstoneCaves;
    private final Holder<Biome> henostoneCaves;
    private long seed;
    FastNoise noise;

    public PrehistoricBiomeSource(HolderGetter<Biome> biome) {
        this((Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_FLATS), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_WOODED_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DRY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_BUTTES), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DESERT), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_SAVANNA), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_HARDWOOD_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_BLUFFS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_REDWOODS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_DUNES), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ARROYO), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ALLUVIAL_PLAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_LAKES), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_REGROWTH), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_VOLCANO), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_HENOSTONE_CAVE));
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return Stream.of(this.chinleFlats, this.chinleRiver, this.chinleSwamp, this.chinleWoodedMountains, this.ischigualastoRiver, this.ischigualastoClearing, this.ischigualastoForest, this.ischigualastoHills, this.kayentaDryForest, this.kayentaButtes, this.kayentaDesert, this.kayentaRiver, this.morrisonSavanna, this.morrisonHills, this.hellCreekHardwoodForest, this.hellCreekClearing, this.hellCreekBluffs, this.hellCreekRedwoods, this.hellCreekSwamp, this.hellCreekRiver, this.djadochtaDunes, this.djadochtaArroyo, this.djadochtaAlluvialPlains, this.yixianForest, this.yixianLakes, this.yixianSnowyForest, this.yixianSnowyMountains, this.yixianRegrowth, this.yixianVolcano, this.dripstoneCaves, this.henostoneCaves);
    }

    public static PrehistoricBiomeSource create(HolderGetter<Biome> biome) {
        return new PrehistoricBiomeSource((Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_FLATS), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.CHINLE_WOODED_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.ISCHIGUALASTO_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DRY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_BUTTES), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DESERT), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_SAVANNA), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_HARDWOOD_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_BLUFFS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_REDWOODS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_DUNES), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ARROYO), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ALLUVIAL_PLAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_LAKES), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_REGROWTH), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_VOLCANO), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_HENOSTONE_CAVE));
    }

    public PrehistoricBiomeSource(Holder<Biome> chinleFlats, Holder<Biome> chinleRiver, Holder<Biome> chinleSwamp, Holder<Biome> chinleWoodedMountains, Holder<Biome> ischigualastoRiver, Holder<Biome> ischigualastoClearing, Holder<Biome> ischigualastoForest, Holder<Biome> ischigualastoHills, Holder<Biome> kayentaDryForest, Holder<Biome> kayentaButtes, Holder<Biome> kayentaDesert, Holder<Biome> kayentaRiver, Holder<Biome> morrisonSavanna, Holder<Biome> morrisonHills, Holder<Biome> hellCreekHardwoodForest, Holder<Biome> hellCreekClearing, Holder<Biome> hellCreekBluffs, Holder<Biome> hellCreekRedwoods, Holder<Biome> hellCreekSwamp, Holder<Biome> hellCreekRiver, Holder<Biome> djadochtaDunes, Holder<Biome> djadochtaArroyo, Holder<Biome> djadochtaAlluvialPlains, Holder<Biome> yixianForest, Holder<Biome> yixianLakes, Holder<Biome> yixianSnowyForest, Holder<Biome> yixianSnowyMountains, Holder<Biome> yixianRegrowth, Holder<Biome> yixianVolcano, Holder<Biome> dripstoneCaves, Holder<Biome> henostoneCaves) {
        Random random = new Random();
        this.seed = random.nextInt();
        this.chinleFlats = chinleFlats;
        this.chinleRiver = chinleRiver;
        this.chinleSwamp = chinleSwamp;
        this.chinleWoodedMountains = chinleWoodedMountains;
        this.ischigualastoRiver = ischigualastoRiver;
        this.ischigualastoClearing = ischigualastoClearing;
        this.ischigualastoForest = ischigualastoForest;
        this.ischigualastoHills = ischigualastoHills;
        this.kayentaDryForest = kayentaDryForest;
        this.kayentaButtes = kayentaButtes;
        this.kayentaDesert = kayentaDesert;
        this.kayentaRiver = kayentaRiver;
        this.morrisonSavanna = morrisonSavanna;
        this.morrisonHills = morrisonHills;
        this.hellCreekHardwoodForest = hellCreekHardwoodForest;
        this.hellCreekClearing = hellCreekClearing;
        this.hellCreekBluffs = hellCreekBluffs;
        this.hellCreekRedwoods = hellCreekRedwoods;
        this.hellCreekSwamp = hellCreekSwamp;
        this.hellCreekRiver = hellCreekRiver;
        this.djadochtaDunes = djadochtaDunes;
        this.djadochtaArroyo = djadochtaArroyo;
        this.djadochtaAlluvialPlains = djadochtaAlluvialPlains;
        this.yixianForest = yixianForest;
        this.yixianLakes = yixianLakes;
        this.yixianSnowyForest = yixianSnowyForest;
        this.yixianSnowyMountains = yixianSnowyMountains;
        this.yixianRegrowth = yixianRegrowth;
        this.yixianVolcano = yixianVolcano;
        this.dripstoneCaves = dripstoneCaves;
        this.henostoneCaves = henostoneCaves;
        this.noise = new FastNoise((int)this.seed);
        this.noise.SetNoiseType(FastNoise.NoiseType.Simplex);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return this.m_203495_(x, y, z);
    }

    public double periodNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.05f, (float)z * 0.05f);
    }

    public double timeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.1f, (float)z * 0.1f);
    }

    public double tempNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.2f, (float)z * 0.2f);
    }

    public double hillinessNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.4f, (float)z * 0.4f);
    }

    public double humidityNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.7f, (float)z * 0.7f);
    }

    public double caveTimeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.3f, (float)y * 0.3f, (float)z * 0.3f);
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        double timelineNoise = this.timeLineNoise(x, y, z, this.noise);
        double periodNoise = this.periodNoise(x, y, z, this.noise);
        double tempNoise = this.tempNoise(x, y, z, this.noise);
        double humidityNoise = this.humidityNoise(x, y, z, this.noise);
        double hillinessNoise = this.hillinessNoise(x, y, z, this.noise);
        double caveTimeLineNoise = this.caveTimeLineNoise(x, y, z, this.noise);
        if (y < 6) {
            if (humidityNoise > 0.4) {
                if (tempNoise <= -0.5 && timelineNoise <= (double)-0.3333f && periodNoise >= (double)0.3333f) {
                    if (hillinessNoise > 0.0) {
                        return this.yixianSnowyMountains;
                    }
                    return this.yixianSnowyForest;
                }
                return this.dripstoneCaves;
            }
            if (caveTimeLineNoise > 0.8) {
                return this.henostoneCaves;
            }
        }
        if (periodNoise >= (double)0.3333f) {
            if (timelineNoise >= (double)0.3333f) {
                if (hillinessNoise > 0.5) {
                    return this.hellCreekBluffs;
                }
                if (hillinessNoise < 0.0) {
                    if (humidityNoise > 0.0) {
                        return this.hellCreekSwamp;
                    }
                    return this.hellCreekClearing;
                }
                if (tempNoise <= 0.0) {
                    return this.hellCreekRedwoods;
                }
                return this.hellCreekHardwoodForest;
            }
            if (timelineNoise <= (double)-0.3333f) {
                if (tempNoise <= -0.5) {
                    if (hillinessNoise > 0.0) {
                        return this.yixianSnowyMountains;
                    }
                    return this.yixianSnowyForest;
                }
                if (humidityNoise >= 0.25 && hillinessNoise < 0.0) {
                    return this.yixianLakes;
                }
                if (tempNoise >= 0.5) {
                    if (hillinessNoise > 0.0) {
                        return this.yixianVolcano;
                    }
                    return this.yixianRegrowth;
                }
                return this.yixianForest;
            }
            if (timelineNoise > (double)-0.3333f && timelineNoise < (double)0.32f) {
                if (humidityNoise > 0.0 && hillinessNoise < 0.5) {
                    return this.djadochtaArroyo;
                }
                if (hillinessNoise > 0.0 && humidityNoise < 0.0) {
                    return this.djadochtaDunes;
                }
                return this.djadochtaAlluvialPlains;
            }
            return this.hellCreekRiver;
        }
        if (periodNoise <= (double)-0.3333f) {
            if (timelineNoise >= (double)0.0222f) {
                if (hillinessNoise > 0.5) {
                    return this.chinleWoodedMountains;
                }
                if (tempNoise > (double)0.3f) {
                    return this.chinleFlats;
                }
                return this.chinleSwamp;
            }
            if (timelineNoise < (double)0.0222f && timelineNoise >= 0.0) {
                return this.chinleRiver;
            }
            if (timelineNoise <= (double)-0.0222f) {
                if (hillinessNoise > (double)0.3f) {
                    return this.ischigualastoHills;
                }
                if (hillinessNoise < (double)-0.4f) {
                    return this.ischigualastoClearing;
                }
                return this.ischigualastoForest;
            }
            return this.ischigualastoRiver;
        }
        if (timelineNoise >= 0.0) {
            if (hillinessNoise > (double)0.3f) {
                return this.morrisonHills;
            }
            return this.morrisonSavanna;
        }
        if (timelineNoise <= (double)-0.0111f) {
            if (tempNoise > (double)0.2f) {
                if (hillinessNoise > (double)0.4f) {
                    return this.kayentaButtes;
                }
                return this.kayentaDesert;
            }
            return this.kayentaDryForest;
        }
        return this.kayentaRiver;
    }
}

