/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.world.biome.biomesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import superlord.prehistoricfauna.common.util.FastNoise;
import superlord.prehistoricfauna.common.world.chunkgen.JurassicChunkGenerator;
import superlord.prehistoricfauna.init.PFBiomes;

public class JurassicBiomeSource
extends BiomeSource
implements BiomeManager.NoiseBiomeSource {
    double noiseValue;
    public static final Codec<JurassicBiomeSource> CODEC = RecordCodecBuilder.create((T p_48644_) -> p_48644_.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(biomeGetter -> null)).apply((Applicative)p_48644_, p_48644_.stable(JurassicBiomeSource::new)));
    private final Holder<Biome> kayentaDryForest;
    private final Holder<Biome> kayentaButtes;
    private final Holder<Biome> kayentaDesert;
    private final Holder<Biome> kayentaRiver;
    private final Holder<Biome> morrisonSavanna;
    private final Holder<Biome> morrisonHills;
    private final Holder<Biome> prehistoricDripstoneCave;
    private final Holder<Biome> henostoneCave;

    public JurassicBiomeSource(HolderGetter<Biome> biome) {
        this((Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DRY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_BUTTES), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DESERT), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_SAVANNA), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.JURASSIC_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.JURASSIC_HENOSTONE_CAVE));
    }

    public static JurassicBiomeSource create(HolderGetter<Biome> biome) {
        return new JurassicBiomeSource((Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DRY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_BUTTES), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_DESERT), (Holder<Biome>)biome.m_255043_(PFBiomes.KAYENTA_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_SAVANNA), (Holder<Biome>)biome.m_255043_(PFBiomes.MORRISON_HILLS), (Holder<Biome>)biome.m_255043_(PFBiomes.JURASSIC_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.JURASSIC_HENOSTONE_CAVE));
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return Stream.of(this.kayentaButtes, this.kayentaDesert, this.kayentaDryForest, this.kayentaRiver, this.morrisonHills, this.morrisonSavanna, this.prehistoricDripstoneCave, this.henostoneCave);
    }

    public JurassicBiomeSource(Holder<Biome> kayentaDryForest, Holder<Biome> kayentaButtes, Holder<Biome> kayentaDesert, Holder<Biome> kayentaRiver, Holder<Biome> morrisonSavanna, Holder<Biome> morrisonHills, Holder<Biome> prehistoricDripstoneCave, Holder<Biome> henostoneCave) {
        this.kayentaDryForest = kayentaDryForest;
        this.kayentaButtes = kayentaButtes;
        this.kayentaDesert = kayentaDesert;
        this.kayentaRiver = kayentaRiver;
        this.morrisonSavanna = morrisonSavanna;
        this.morrisonHills = morrisonHills;
        this.prehistoricDripstoneCave = prehistoricDripstoneCave;
        this.henostoneCave = henostoneCave;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return this.m_203495_(x, y, z);
    }

    public double timeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.1f, (float)z * 0.1f);
    }

    public double tempNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.2f, (float)z * 0.2f);
    }

    public double hillinessNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.4f, (float)z * 0.4f);
    }

    public double humidityNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.7f, (float)z * 0.7f);
    }

    public double caveTimeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.3f, (float)y * 0.3f, (float)z * 0.3f);
    }

    public double getNoiseValue() {
        return this.noiseValue;
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        double timelineNoise = this.timeLineNoise(x, y, z, JurassicChunkGenerator.noise);
        double tempNoise = this.tempNoise(x, y, z, JurassicChunkGenerator.noise);
        double humidityNoise = this.humidityNoise(x, y, z, JurassicChunkGenerator.noise);
        double hillinessNoise = this.hillinessNoise(x, y, z, JurassicChunkGenerator.noise);
        double caveTimeLineNoise = this.caveTimeLineNoise(x, y, z, JurassicChunkGenerator.noise);
        if (y < 6) {
            if (humidityNoise > 0.4) {
                return this.prehistoricDripstoneCave;
            }
            if (caveTimeLineNoise > 0.8) {
                return this.henostoneCave;
            }
        }
        if (timelineNoise >= 0.0) {
            if (hillinessNoise > (double)0.3f) {
                return this.morrisonHills;
            }
            return this.morrisonSavanna;
        }
        if (timelineNoise <= (double)-0.0111f) {
            if (tempNoise > (double)0.2f) {
                if (hillinessNoise > (double)0.4f) {
                    return this.kayentaButtes;
                }
                return this.kayentaDesert;
            }
            return this.kayentaDryForest;
        }
        return this.kayentaRiver;
    }
}

