/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.world.biome.biomesource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import superlord.prehistoricfauna.common.util.FastNoise;
import superlord.prehistoricfauna.common.world.chunkgen.CretaceousChunkGenerator;
import superlord.prehistoricfauna.init.PFBiomes;

public class CretaceousBiomeSource
extends BiomeSource
implements BiomeManager.NoiseBiomeSource {
    double noiseValue;
    public static final Codec<CretaceousBiomeSource> CODEC = RecordCodecBuilder.create((T p_48644_) -> p_48644_.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256952_).forGetter(biomeGetter -> null)).apply((Applicative)p_48644_, p_48644_.stable(CretaceousBiomeSource::new)));
    private final Holder<Biome> hellCreekHardwoodForest;
    private final Holder<Biome> hellCreekClearing;
    private final Holder<Biome> hellCreekBluffs;
    private final Holder<Biome> hellCreekRedwoods;
    private final Holder<Biome> hellCreekSwamp;
    private final Holder<Biome> hellCreekRiver;
    private final Holder<Biome> djadochtaDunes;
    private final Holder<Biome> djadochtaArroyo;
    private final Holder<Biome> djadochtaAlluvialPlains;
    private final Holder<Biome> yixianForest;
    private final Holder<Biome> yixianSnowyForest;
    private final Holder<Biome> yixianSnowyMountains;
    private final Holder<Biome> yixianRegrowth;
    private final Holder<Biome> yixianVolcano;
    private final Holder<Biome> yixianLakes;
    private final Holder<Biome> dripstoneCaves;
    private final Holder<Biome> henostoneCaves;

    public CretaceousBiomeSource(HolderGetter<Biome> biome) {
        this((Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_HARDWOOD_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_BLUFFS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_REDWOODS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_DUNES), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ARROYO), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ALLUVIAL_PLAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_REGROWTH), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_VOLCANO), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_LAKES), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_HENOSTONE_CAVE));
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return Stream.of(this.hellCreekBluffs, this.hellCreekClearing, this.hellCreekHardwoodForest, this.hellCreekRedwoods, this.hellCreekRiver, this.hellCreekSwamp, this.djadochtaAlluvialPlains, this.djadochtaArroyo, this.djadochtaDunes, this.yixianForest, this.yixianLakes, this.yixianRegrowth, this.yixianSnowyForest, this.yixianSnowyMountains, this.yixianVolcano, this.dripstoneCaves, this.henostoneCaves);
    }

    public static CretaceousBiomeSource create(HolderGetter<Biome> biome) {
        return new CretaceousBiomeSource((Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_HARDWOOD_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_CLEARING), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_BLUFFS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_REDWOODS), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_SWAMP), (Holder<Biome>)biome.m_255043_(PFBiomes.HELL_CREEK_RIVER), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_DUNES), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ARROYO), (Holder<Biome>)biome.m_255043_(PFBiomes.DJADOCHTA_ALLUVIAL_PLAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_FOREST), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_SNOWY_MOUNTAINS), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_REGROWTH), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_VOLCANO), (Holder<Biome>)biome.m_255043_(PFBiomes.YIXIAN_LAKES), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_DRIPSTONE_CAVE), (Holder<Biome>)biome.m_255043_(PFBiomes.CRETACEOUS_HENOSTONE_CAVE));
    }

    public CretaceousBiomeSource(Holder<Biome> hellCreekHardwoodForest, Holder<Biome> hellCreekClearing, Holder<Biome> hellCreekBluffs, Holder<Biome> hellCreekRedwoods, Holder<Biome> hellCreekSwamp, Holder<Biome> hellCreekRiver, Holder<Biome> djadochtaDunes, Holder<Biome> djadochtaArroyo, Holder<Biome> djadochtaAlluvialPlains, Holder<Biome> yixianForest, Holder<Biome> yixianSnowyForest, Holder<Biome> yixianSnowyMountains, Holder<Biome> yixianRegrowth, Holder<Biome> yixianVolcano, Holder<Biome> yixianLakes, Holder<Biome> dripstoneCaves, Holder<Biome> henostoneCaves) {
        this.hellCreekHardwoodForest = hellCreekHardwoodForest;
        this.hellCreekClearing = hellCreekClearing;
        this.hellCreekBluffs = hellCreekBluffs;
        this.hellCreekRedwoods = hellCreekRedwoods;
        this.hellCreekSwamp = hellCreekSwamp;
        this.hellCreekRiver = hellCreekRiver;
        this.djadochtaDunes = djadochtaDunes;
        this.djadochtaArroyo = djadochtaArroyo;
        this.djadochtaAlluvialPlains = djadochtaAlluvialPlains;
        this.yixianForest = yixianForest;
        this.yixianSnowyForest = yixianSnowyForest;
        this.yixianSnowyMountains = yixianSnowyMountains;
        this.yixianRegrowth = yixianRegrowth;
        this.yixianVolcano = yixianVolcano;
        this.yixianLakes = yixianLakes;
        this.dripstoneCaves = dripstoneCaves;
        this.henostoneCaves = henostoneCaves;
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return this.m_203495_(x, y, z);
    }

    public double timeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.1f, (float)z * 0.1f);
    }

    public double tempNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.2f, (float)z * 0.2f);
    }

    public double hillinessNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.4f, (float)z * 0.4f);
    }

    public double humidityNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.7f, (float)z * 0.7f);
    }

    public double getNoiseValue() {
        return this.noiseValue;
    }

    public double caveTimeLineNoise(int x, int y, int z, FastNoise noise) {
        return noise.GetNoise((float)x * 0.3f, (float)y * 0.3f, (float)z * 0.3f);
    }

    public Holder<Biome> m_203495_(int x, int y, int z) {
        double timelineNoise = this.timeLineNoise(x, y, z, CretaceousChunkGenerator.noise);
        double tempNoise = this.tempNoise(x, y, z, CretaceousChunkGenerator.noise);
        double humidityNoise = this.humidityNoise(x, y, z, CretaceousChunkGenerator.noise);
        double hillinessNoise = this.hillinessNoise(x, y, z, CretaceousChunkGenerator.noise);
        double caveTimeLineNoise = this.caveTimeLineNoise(x, y, z, CretaceousChunkGenerator.noise);
        if (y < 6) {
            if (humidityNoise > 0.4) {
                if (tempNoise <= -0.5 && timelineNoise <= (double)-0.3333f) {
                    if (hillinessNoise > 0.0) {
                        return this.yixianSnowyMountains;
                    }
                    return this.yixianSnowyForest;
                }
                return this.dripstoneCaves;
            }
            if (caveTimeLineNoise > 0.8) {
                return this.henostoneCaves;
            }
        }
        if (timelineNoise >= (double)0.3333f) {
            if (hillinessNoise > 0.5) {
                return this.hellCreekBluffs;
            }
            if (hillinessNoise < 0.0) {
                if (humidityNoise > 0.0) {
                    return this.hellCreekSwamp;
                }
                return this.hellCreekClearing;
            }
            if (tempNoise <= 0.0) {
                return this.hellCreekRedwoods;
            }
            return this.hellCreekHardwoodForest;
        }
        if (timelineNoise <= (double)-0.3333f) {
            if (tempNoise <= -0.5) {
                if (hillinessNoise > 0.0) {
                    return this.yixianSnowyMountains;
                }
                return this.yixianSnowyForest;
            }
            if (humidityNoise >= 0.25 && hillinessNoise < 0.0) {
                return this.yixianLakes;
            }
            if (tempNoise >= 0.5) {
                if (hillinessNoise > 0.0) {
                    return this.yixianVolcano;
                }
                return this.yixianRegrowth;
            }
            return this.yixianForest;
        }
        if (timelineNoise > (double)-0.3333f && timelineNoise < (double)0.32f) {
            if (humidityNoise > 0.0 && hillinessNoise < 0.5) {
                return this.djadochtaArroyo;
            }
            if (hillinessNoise > 0.0 && humidityNoise < 0.0) {
                return this.djadochtaDunes;
            }
            return this.djadochtaAlluvialPlains;
        }
        return this.hellCreekRiver;
    }
}

