/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBiomeModifiers;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFPlacedFeatures;

public class PFBiomeModifier
implements BiomeModifier {
    public static final Codec<PFBiomeModifier> CODEC = RecordCodecBuilder.create(p_48644_ -> p_48644_.group((App)RegistryOps.retrieveRegistryLookup((ResourceKey)Registries.f_256988_).forGetter(placedFeature -> null)).apply((Applicative)p_48644_, p_48644_.stable(PFBiomeModifier::new)));
    public final Holder<PlacedFeature> largeMetasequoiaTrees;
    public final Holder<PlacedFeature> rareSmallMetasequoiaTrees;
    public final Holder<PlacedFeature> smallAraucariaTrees;
    public final Holder<PlacedFeature> rareEphedra;
    public final Holder<PlacedFeature> smallGinkgoTrees;
    public final Holder<PlacedFeature> rareLargeGinkgoTrees;
    public final Holder<PlacedFeature> smallMixedGingkoTrees;
    public final Holder<PlacedFeature> rareMixedLargeGinkgoTrees;
    public final Holder<PlacedFeature> rareSmallYellowGinkgoTrees;
    public final Holder<PlacedFeature> taxusTrees;
    public final Holder<PlacedFeature> clubmoss;
    public final Holder<PlacedFeature> rareNelumbo;
    public final Holder<PlacedFeature> azolla;
    public final Holder<PlacedFeature> marchantia;
    public final Holder<PlacedFeature> algae;
    public final Holder<PlacedFeature> waterloggedHorsetails;
    public final Holder<PlacedFeature> horsetails;
    public final Holder<PlacedFeature> rareTaxodiumTrees;
    public final Holder<PlacedFeature> taxodiumKnees;
    public final Holder<PlacedFeature> osmunda;
    public final Holder<PlacedFeature> tallOsmunda;
    public final Holder<PlacedFeature> crassostreaOysters;
    public final Holder<PlacedFeature> rareLargeAraucariaTrees;

    public PFBiomeModifier(HolderGetter<PlacedFeature> feature) {
        this((Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.LARGE_METASEQUOIA_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.SPARSE_SMALL_METASEQUOIA_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.SMALL_ARAUCARIA_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.RARE_EPHEDRA), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.SMALL_GINKGO_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.RARE_LARGE_GINKGO_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.SMALL_MIXED_GINKGO_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.RARE_MIXED_LARGE_GINKGO_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.SPARSE_SMALL_YELLOW_GINKGO_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.TAXUS_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.CLUBMOSS), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.RARE_NELUMBO), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.AZOLLA), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.MARCHANTIA), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.ALGAE), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.WATERLOGGED_HORSETAILS), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.HORSETAILS), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.RARE_TAXODIUM_TREES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.TAXODIUM_KNEES), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.OSMUNDA), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.TALL_OSMUNDA), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.CRASSOSTREA_OYSTERS), (Holder<PlacedFeature>)feature.m_255043_(PFPlacedFeatures.RARE_LARGE_ARAUCARIA_TREES));
    }

    public PFBiomeModifier(Holder<PlacedFeature> largeMetasequoiaTrees, Holder<PlacedFeature> rareSmallMetasequoiaTrees, Holder<PlacedFeature> smallAraucariaTrees, Holder<PlacedFeature> rareEphedra, Holder<PlacedFeature> smallGinkgoTrees, Holder<PlacedFeature> rareLargeGinkgoTrees, Holder<PlacedFeature> smallMixedGinkgoTrees, Holder<PlacedFeature> rareMixedLargeGinkgoTrees, Holder<PlacedFeature> rareSmallYellowGinkgoTrees, Holder<PlacedFeature> taxusTrees, Holder<PlacedFeature> clubmoss, Holder<PlacedFeature> rareNelumbo, Holder<PlacedFeature> azolla, Holder<PlacedFeature> marchantia, Holder<PlacedFeature> algae, Holder<PlacedFeature> waterloggedHorsetails, Holder<PlacedFeature> horsetails, Holder<PlacedFeature> rareTaxodiumTrees, Holder<PlacedFeature> taxodiumKnees, Holder<PlacedFeature> osmunda, Holder<PlacedFeature> tallOsmunda, Holder<PlacedFeature> crassostreaOysters, Holder<PlacedFeature> rareLargeAraucariaTrees) {
        this.largeMetasequoiaTrees = largeMetasequoiaTrees;
        this.rareSmallMetasequoiaTrees = rareSmallMetasequoiaTrees;
        this.smallAraucariaTrees = smallAraucariaTrees;
        this.rareEphedra = rareEphedra;
        this.smallGinkgoTrees = smallGinkgoTrees;
        this.rareLargeGinkgoTrees = rareLargeGinkgoTrees;
        this.smallMixedGingkoTrees = smallMixedGinkgoTrees;
        this.rareMixedLargeGinkgoTrees = rareMixedLargeGinkgoTrees;
        this.rareSmallYellowGinkgoTrees = rareSmallYellowGinkgoTrees;
        this.taxusTrees = taxusTrees;
        this.clubmoss = clubmoss;
        this.rareNelumbo = rareNelumbo;
        this.azolla = azolla;
        this.marchantia = marchantia;
        this.waterloggedHorsetails = waterloggedHorsetails;
        this.horsetails = horsetails;
        this.algae = algae;
        this.rareTaxodiumTrees = rareTaxodiumTrees;
        this.taxodiumKnees = taxodiumKnees;
        this.osmunda = osmunda;
        this.tallOsmunda = tallOsmunda;
        this.crassostreaOysters = crassostreaOysters;
        this.rareLargeAraucariaTrees = rareLargeAraucariaTrees;
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && biome.m_203656_(BiomeTags.f_215817_)) {
            if (PrehistoricFaunaConfig.extantWorldGeneration) {
                if (biome.m_203565_(Biomes.f_186764_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.largeMetasequoiaTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareSmallMetasequoiaTrees);
                }
                if (biome.m_203565_(Biomes.f_48158_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.smallAraucariaTrees);
                }
                if (biome.m_203565_(Biomes.f_186768_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.smallAraucariaTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareLargeAraucariaTrees);
                }
                if (biome.m_203565_(Biomes.f_48203_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareEphedra);
                }
                if (biome.m_203656_(BiomeTags.f_207607_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareEphedra);
                }
                if (biome.m_203565_(Biomes.f_186759_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.smallGinkgoTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareLargeGinkgoTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.clubmoss);
                }
                if (biome.m_203565_(Biomes.f_186754_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.smallMixedGingkoTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareMixedLargeGinkgoTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.clubmoss);
                }
                if (biome.m_203565_(Biomes.f_186767_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareSmallYellowGinkgoTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.taxusTrees);
                }
                if (biome.m_203565_(Biomes.f_48176_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareSmallYellowGinkgoTrees);
                }
                if (biome.m_203565_(Biomes.f_271432_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareSmallYellowGinkgoTrees);
                }
                if (biome.m_203565_(Biomes.f_48206_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.taxusTrees);
                }
                if (biome.m_203565_(Biomes.f_186755_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.taxusTrees);
                }
                if (biome.m_203565_(Biomes.f_186765_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.clubmoss);
                }
                if (biome.m_203565_(Biomes.f_186766_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.clubmoss);
                }
                if (biome.m_203565_(Biomes.f_48207_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.clubmoss);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareNelumbo);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.azolla);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.marchantia);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.algae);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.waterloggedHorsetails);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.horsetails);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareTaxodiumTrees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.taxodiumKnees);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.osmunda);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.tallOsmunda);
                }
                if (biome.m_203565_(Biomes.f_220595_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareNelumbo);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.marchantia);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.algae);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.crassostreaOysters);
                }
                if (biome.m_203565_(Biomes.f_48208_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.rareNelumbo);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.waterloggedHorsetails);
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.horsetails);
                }
                if (biome.m_203565_(Biomes.f_48202_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.azolla);
                }
                if (biome.m_203565_(Biomes.f_186760_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.crassostreaOysters);
                }
                if (biome.m_203565_(Biomes.f_48222_) || biome.m_203565_(Biomes.f_48197_) || biome.m_203565_(Biomes.f_186769_)) {
                    builder.getGenerationSettings().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.marchantia);
                }
            }
            if (PrehistoricFaunaConfig.extantEntitySpawns) {
                if (biome.m_203565_(Biomes.f_48208_)) {
                    builder.getMobSpawnSettings().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)PFEntities.GAR.get(), 12, 1, 2));
                    builder.getMobSpawnSettings().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)PFEntities.ACIPENSER.get(), 15, 1, 2));
                }
                if (biome.m_203565_(Biomes.f_48207_)) {
                    builder.getMobSpawnSettings().m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)PFEntities.GAR.get(), 12, 1, 2));
                }
                if (biome.m_203656_(BiomeTags.f_207611_)) {
                    builder.getMobSpawnSettings().m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)PFEntities.DERMESTID_BEETLE.get(), 7, 1, 2));
                }
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)PFBiomeModifiers.PF_BIOME_MODIFIER_TYPE.get();
    }
}

