/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.util.trees;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import superlord.prehistoricfauna.common.util.trees.TreeSpawner;

public abstract class HugeTreeSpawner
extends TreeSpawner {
    public static boolean canBigTreeSpawnAt(BlockState blockUnder, LevelReader world, BlockPos pos, int xOffset, int zOffset) {
        Block block = blockUnder.m_60734_();
        return block == world.m_8055_(pos.m_7918_(xOffset, 0, zOffset)).m_60734_() && block == world.m_8055_(pos.m_7918_(xOffset + 1, 0, zOffset)).m_60734_() && block == world.m_8055_(pos.m_7918_(xOffset, 0, zOffset + 1)).m_60734_() && block == world.m_8055_(pos.m_7918_(xOffset + 1, 0, zOffset + 1)).m_60734_();
    }

    @Override
    public boolean spawn(WorldGenLevel world, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, RandomSource random) {
        for (int i = 0; i >= -1; --i) {
            for (int j = 0; j >= -1; --j) {
                if (!HugeTreeSpawner.canBigTreeSpawnAt(blockUnder, (LevelReader)world, pos, i, j)) continue;
                return this.bigTree(world, chunkGenerator, pos, blockUnder, random, i, j);
            }
        }
        return super.spawn(world, chunkGenerator, pos, blockUnder, random);
    }

    @Nullable
    protected abstract ResourceKey<ConfiguredFeature<?, ?>> getBigTreeFeature(RandomSource var1);

    public boolean bigTree(WorldGenLevel world, ChunkGenerator chunkGenerator, BlockPos pos, BlockState blockUnder, RandomSource random, int xOffset, int zOffset) {
        ResourceKey<ConfiguredFeature<?, ?>> configuredTreeFeature = this.getBigTreeFeature(random);
        Holder holder = (Holder)world.m_9598_().m_175515_(Registries.f_256911_).m_203636_(configuredTreeFeature).orElse(null);
        ConfiguredFeature configuredfeature = (ConfiguredFeature)holder.m_203334_();
        if (configuredTreeFeature == null) {
            return false;
        }
        BlockState blockstate = Blocks.f_50016_.m_49966_();
        world.m_7731_(pos.m_7918_(xOffset, 0, zOffset), blockstate, 4);
        world.m_7731_(pos.m_7918_(xOffset + 1, 0, zOffset), blockstate, 4);
        world.m_7731_(pos.m_7918_(xOffset, 0, zOffset + 1), blockstate, 4);
        world.m_7731_(pos.m_7918_(xOffset + 1, 0, zOffset + 1), blockstate, 4);
        if (configuredfeature.m_224953_(world, chunkGenerator, random, pos.m_7918_(xOffset, 0, zOffset))) {
            return true;
        }
        world.m_7731_(pos.m_7918_(xOffset, 0, zOffset), blockUnder, 4);
        world.m_7731_(pos.m_7918_(xOffset + 1, 0, zOffset), blockUnder, 4);
        world.m_7731_(pos.m_7918_(xOffset, 0, zOffset + 1), blockUnder, 4);
        world.m_7731_(pos.m_7918_(xOffset + 1, 0, zOffset + 1), blockUnder, 4);
        return false;
    }
}

