/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import superlord.prehistoricfauna.common.items.PaleopediaItem;

public enum EnumPaleoPages {
    INTRODUCTION(0),
    PALEONTOLOGY(1),
    SCIENTIFIC_NOTES(0),
    DJADOCHTA(8),
    AEPYORNITHOMIMUS(0),
    BYRONOSAURUS(0),
    CITIPATI(0),
    GOYOCEPHALE(0),
    HALSZKARAPTOR(0),
    KOL(0),
    OVIRAPTOR(0),
    PINACOSAURUS(0),
    PLESIOHADROS(0),
    PROTOCERATOPS(0),
    TELMASAURUS(0),
    UDANOCERATOPS(0),
    VELOCIRAPTOR(0),
    HELL_CREEK(9),
    ANKYLOSAURUS(0),
    ANZU(0),
    BASILEMYS(0),
    BRACHYCHAMPSA(0),
    DAKOTARAPTOR(0),
    DIDELPHODON(0),
    EDMONTOSAURUS(0),
    ORNITHOMIMUS(0),
    PACHYCEPHALOSAURUS(0),
    PALAEOSANIWA(0),
    THESCELOSAURUS(0),
    TRICERATOPS(0),
    TYRANNOSAURUS(0),
    YIXIAN(1),
    BEIPIAOSAURUS(0),
    CHANGYURAPTOR(0),
    DILONG(0),
    DONGBEITITAN(0),
    INCISIVOSAURUS(0),
    JINZHOUSAURUS(0),
    LIAONINGOSAURUS(0),
    PSITTACOSAURUS(0),
    REPENOMAMUS(0),
    RUIXINIA(0),
    SINOSAUROPTERYX(0),
    YUTYRANNUS(0),
    ZHENYUANLONG(0),
    KAYENTA(9),
    CALSOYASUCHUS(0),
    DILOPHOSAURUS(0),
    KAYENTATHERIUM(0),
    MEGAPNOSAURUS(0),
    SARAHSAURUS(0),
    SCELIDOSAURUS(0),
    SCUTELLOSAURUS(0),
    MORRISON(7),
    ALLOSAURUS(0),
    CAMARASAURUS(0),
    CERATOSAURUS(0),
    DRYOSAURUS(0),
    EILENODON(0),
    HESPERORNITHOIDES(0),
    STEGOSAURUS(0),
    CHINLE(11),
    COELOPHYSIS(0),
    DESMATOSUCHUS(0),
    PLACERIAS(0),
    POPOSAURUS(0),
    POSTOSUCHUS(0),
    TRILOPHOSAURUS(0),
    TYPOTHORAX(0),
    ISCHIGUALASTO(10),
    CHROMOGISAURUS(0),
    EXAERETODON(0),
    HERRERASAURUS(0),
    HYPERODAPEDON(0),
    ISCHIGUALASTIA(0),
    SAUROSUCHUS(0),
    SILLOSUCHUS(0);

    public static final ImmutableList<EnumPaleoPages> ALL_PAGES;
    public static final ImmutableList<Integer> ALL_INDEXES;
    public int pages;

    private EnumPaleoPages(int pages) {
        this.pages = pages;
    }

    public static Set<EnumPaleoPages> containedPages(Collection<Integer> pages) {
        return pages.stream().map(arg_0 -> ALL_PAGES.get(arg_0)).collect(Collectors.toSet());
    }

    public static boolean hasAllPages(ItemStack book) {
        return Ints.asList((int[])book.m_41783_().m_128465_("Pages")).containsAll((Collection<?>)ALL_INDEXES);
    }

    public static List<Integer> enumToInt(List<EnumPaleoPages> pages) {
        return pages.stream().map(Enum::ordinal).collect(Collectors.toList());
    }

    public static EnumPaleoPages getRand() {
        return EnumPaleoPages.values()[ThreadLocalRandom.current().nextInt(EnumPaleoPages.values().length)];
    }

    public static void addRandomPage(ItemStack book) {
        List<EnumPaleoPages> list;
        if (book.m_41720_() instanceof PaleopediaItem && !(list = EnumPaleoPages.possiblePages(book)).isEmpty()) {
            EnumPaleoPages.addPage(list.get(ThreadLocalRandom.current().nextInt(list.size())), book);
        }
    }

    public static List<EnumPaleoPages> possiblePages(ItemStack book) {
        if (book.m_41720_() instanceof PaleopediaItem) {
            CompoundTag tag = book.m_41783_();
            Set<EnumPaleoPages> containedPages = EnumPaleoPages.containedPages(Ints.asList((int[])tag.m_128465_("Pages")));
            ArrayList<EnumPaleoPages> possiblePages = new ArrayList<EnumPaleoPages>((Collection<EnumPaleoPages>)ALL_PAGES);
            possiblePages.removeAll(containedPages);
            return possiblePages;
        }
        return Collections.emptyList();
    }

    public static boolean addPage(EnumPaleoPages page, ItemStack book) {
        boolean flag = false;
        if (book.m_41720_() instanceof PaleopediaItem) {
            CompoundTag tag = book.m_41783_();
            ArrayList<Integer> already = new ArrayList<Integer>(Ints.asList((int[])tag.m_128465_("Pages")));
            if (!already.contains(page.ordinal())) {
                already.add(page.ordinal());
                flag = true;
            }
            tag.m_128385_("Pages", Ints.toArray(already));
        }
        return flag;
    }

    @Nullable
    public static EnumPaleoPages fromInt(int index) {
        if (index < 0) {
            return null;
        }
        int length = EnumPaleoPages.values().length;
        return EnumPaleoPages.values()[index % length];
    }

    static {
        ALL_PAGES = ImmutableList.copyOf((Object[])EnumPaleoPages.values());
        ALL_INDEXES = ImmutableList.copyOf((Iterator)IntStream.range(0, EnumPaleoPages.values().length).iterator());
    }
}

