/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.util;

import com.google.common.base.Supplier;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import superlord.prehistoricfauna.client.util.ChestBlockEntityWithoutLevelRenderer;
import superlord.prehistoricfauna.client.util.ChestManager;
import superlord.prehistoricfauna.common.blocks.compat.BEWLRFuelBlockItem;
import superlord.prehistoricfauna.common.blocks.compat.PFChestBlock;
import superlord.prehistoricfauna.common.blocks.compat.PFTrappedChestBlock;
import superlord.prehistoricfauna.common.entity.block.compat.PFChestBlockEntity;
import superlord.prehistoricfauna.common.entity.block.compat.PFTrappedChestBlockEntity;
import superlord.prehistoricfauna.common.util.AbstractSubRegistryHelper;
import superlord.prehistoricfauna.common.util.BEWLRBlockItem;
import superlord.prehistoricfauna.common.util.ISubRegistryHelper;
import superlord.prehistoricfauna.common.util.RegistryHelper;

public class BlockSubRegistryHelper
extends AbstractSubRegistryHelper<Block> {
    protected final DeferredRegister<Item> itemRegister;

    public BlockSubRegistryHelper(RegistryHelper parent) {
        this(parent, parent.getSubHelper(ForgeRegistries.ITEMS).getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, ISubRegistryHelper<Item> itemHelper) {
        this(parent, itemHelper.getDeferredRegister(), (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)parent.getModId()));
    }

    public BlockSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> itemRegister, DeferredRegister<Block> deferredRegister) {
        super(parent, deferredRegister);
        this.itemRegister = itemRegister;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static BEWLRBlockItem.LazyBEWLR chestBEWLR(boolean trapped) {
        return trapped ? new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<PFTrappedChestBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new PFTrappedChestBlockEntity(BlockPos.f_121853_, Blocks.f_50325_.m_49966_()))) : new BEWLRBlockItem.LazyBEWLR((dispatcher, entityModelSet) -> new ChestBlockEntityWithoutLevelRenderer<PFChestBlockEntity>((BlockEntityRenderDispatcher)dispatcher, (EntityModelSet)entityModelSet, new PFChestBlockEntity(BlockPos.f_121853_, Blocks.f_50087_.m_49966_())));
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    public <B extends Block> RegistryObject<B> createBlock(String name, Supplier<? extends B> supplier, Item.Properties properties) {
        RegistryObject block = this.deferredRegister.register(name, supplier);
        this.itemRegister.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }

    public RegistryObject<PFChestBlock> createChestBlock(String name, String materialName, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = ChestManager.registerMaterials(modId, materialName, false);
        RegistryObject block = this.deferredRegister.register(name, () -> new PFChestBlock(chestMaterialsName, properties));
        this.itemRegister.register(name, () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> BlockSubRegistryHelper.chestBEWLR(false), 300));
        return block;
    }

    public RegistryObject<PFChestBlock> createChestBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createChestBlock(materialName + "_chest", materialName, properties);
    }

    public RegistryObject<PFTrappedChestBlock> createTrappedChestBlock(String name, String materialName, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        RegistryObject block = this.deferredRegister.register(name, () -> new PFTrappedChestBlock(modId + ":" + materialName + "_trapped", properties));
        String chestMaterialsName = ChestManager.registerMaterials(modId, materialName, true);
        this.itemRegister.register(name, () -> new BEWLRFuelBlockItem((Block)block.get(), new Item.Properties(), () -> () -> BlockSubRegistryHelper.chestBEWLR(true), 300));
        return block;
    }

    public RegistryObject<PFTrappedChestBlock> createTrappedChestBlock(String materialName, BlockBehaviour.Properties properties) {
        return this.createTrappedChestBlock(materialName + "_trapped_chest", materialName, properties);
    }

    public RegistryObject<PFTrappedChestBlock> createTrappedChestBlockNamed(String materialName, BlockBehaviour.Properties properties) {
        return this.createTrappedChestBlock("trapped_" + materialName + "_chest", materialName, properties);
    }
}

