/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.teleporter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import superlord.prehistoricfauna.PrehistoricFauna;
import superlord.prehistoricfauna.common.blocks.CretaceousPortalBlock;
import superlord.prehistoricfauna.common.blocks.PortalFrameBlock;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFDimensions;

public class CretaceousTeleporter
implements ITeleporter {
    private static final Block FRAME = (Block)PFBlocks.PORTAL_FRAME.get();
    private final ServerLevel world;
    private static final Method m_getRelativePortalPosition = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"m_7643_", (Class[])new Class[]{Direction.Axis.class, BlockUtil.FoundRectangle.class});

    public CretaceousTeleporter(ServerLevel world) {
        this.world = world;
    }

    public Optional<BlockUtil.FoundRectangle> getExistingPortal(BlockPos pos) {
        PoiManager poimanager = this.world.m_8904_();
        int i = 16;
        poimanager.m_27056_((LevelReader)this.world, pos, i);
        Optional<PoiRecord> optional = poimanager.m_27166_(type -> type.m_203565_(PFDimensions.CRETACEOUS_PORTAL.getKey()), pos, i, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.m_27257_().m_123331_((Vec3i)pos)).thenComparingInt(poi -> poi.m_27257_().m_123342_())).filter(poi -> this.world.m_8055_(poi.m_27257_()).m_61138_((Property)BlockStateProperties.f_61364_)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.m_27257_();
            this.world.m_7726_().m_8387_(TicketType.f_9447_, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.world.m_8055_(blockpos);
            return BlockUtil.m_124334_((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, posIn -> this.world.m_8055_(posIn) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder border = this.world.m_6857_();
        int height = Math.min(this.world.m_151558_(), this.world.m_141937_() + this.world.m_143344_()) - 1;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        for (BlockPos.MutableBlockPos mut : BlockPos.m_121935_((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            if (!border.m_61937_((BlockPos)mut) || !border.m_61937_((BlockPos)mut.m_122175_(direction, 1))) continue;
            mut.m_122175_(direction.m_122424_(), 1);
            for (int l = height; l >= this.world.m_141937_(); --l) {
                int j1;
                mut.m_142448_(l);
                if (!this.canReplaceBlock(mut)) continue;
                int i1 = l;
                while (l > this.world.m_141937_() && this.canReplaceBlock(mut.m_122173_(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > height || (j1 = i1 - l) > 0 && j1 < 3) continue;
                mut.m_142448_(l);
                if (!this.checkRegionForPlacement((BlockPos)mut, mutable, direction, 0)) continue;
                double d2 = pos.m_123331_((Vec3i)mut);
                if (this.checkRegionForPlacement((BlockPos)mut, mutable, direction, -1) && this.checkRegionForPlacement((BlockPos)mut, mutable, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = mut.m_7949_();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = mut.m_7949_();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            blockpos = new BlockPos(pos.m_123341_(), Mth.m_14045_((int)pos.m_123342_(), (int)70, (int)(this.world.m_141928_() - 10)), pos.m_123343_()).m_7949_();
            Direction drotated = direction.m_122427_();
            if (!border.m_61937_(blockpos)) {
                return Optional.empty();
            }
            for (int fOffset = -1; fOffset < 2; ++fOffset) {
                for (int fWidth = 0; fWidth < 2; ++fWidth) {
                    for (int fHeight = -1; fHeight < 3; ++fHeight) {
                        boolean flag = fHeight < 0;
                        mutable.m_122154_((Vec3i)blockpos, fWidth * direction.m_122429_() + fOffset * drotated.m_122429_(), fHeight, fWidth * direction.m_122431_() + fOffset * direction.m_122431_());
                        this.world.m_46597_((BlockPos)mutable, flag ? (BlockState)FRAME.m_49966_().m_61124_((Property)PortalFrameBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)) : Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
        for (int fWidth = -1; fWidth < 4; ++fWidth) {
            for (int fHeight = -1; fHeight < 4; ++fHeight) {
                if (fWidth != -1 && fWidth != 3 && fHeight != -1 && fHeight != 3) continue;
                mutable.m_122154_((Vec3i)blockpos, fWidth * direction.m_122429_(), fHeight, fWidth * direction.m_122431_());
                this.world.m_46597_((BlockPos)mutable, (BlockState)FRAME.m_49966_().m_61124_((Property)PortalFrameBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            }
        }
        BlockState portal = (BlockState)((CretaceousPortalBlock)((Object)PFBlocks.CRETACEOUS_PORTAL.get())).m_49966_().m_61124_(CretaceousPortalBlock.AXIS, (Comparable)axis);
        for (int pWidth = 0; pWidth < 3; ++pWidth) {
            for (int pHeight = 0; pHeight < 3; ++pHeight) {
                mutable.m_122154_((Vec3i)blockpos, pWidth * direction.m_122429_(), pHeight, pWidth * direction.m_122431_());
                this.world.m_7731_((BlockPos)mutable, portal, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.m_7949_(), 2, 3));
    }

    private boolean canReplaceBlock(BlockPos.MutableBlockPos mutable) {
        BlockState state = this.world.m_8055_((BlockPos)mutable);
        return state.m_247087_() && state.m_60819_().m_76178_();
    }

    private boolean checkRegionForPlacement(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction directionIn, int offsetScale) {
        Direction direction = directionIn.m_122427_();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.m_122154_((Vec3i)originalPos, directionIn.m_122429_() * i + direction.m_122429_() * offsetScale, j, directionIn.m_122431_() * i + direction.m_122431_() * offsetScale);
                if (j < 0 && !this.world.m_8055_((BlockPos)offsetPos).m_280296_()) {
                    return false;
                }
                if (j < 0 || this.world.m_46859_((BlockPos)offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        return repositionEntity.apply(false);
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        boolean toCretaceous;
        boolean bl = toCretaceous = destWorld.m_46472_() == PFDimensions.CRETACEOUS;
        if (entity.m_9236_().m_46472_() != PFDimensions.CRETACEOUS && !toCretaceous) {
            return null;
        }
        WorldBorder border = destWorld.m_6857_();
        double minX = Math.max(-2.9999872E7, border.m_61955_() + 16.0);
        double minZ = Math.max(-2.9999872E7, border.m_61956_() + 16.0);
        double maxX = Math.min(2.9999872E7, border.m_61957_() - 16.0);
        double maxZ = Math.min(2.9999872E7, border.m_61958_() - 16.0);
        double offset = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)destWorld.m_6042_());
        BlockPos blockpos = new BlockPos(Mth.m_14045_((int)((int)entity.m_20185_() * (int)offset), (int)((int)minX), (int)((int)maxX)), (int)entity.m_20186_(), Mth.m_14045_((int)((int)entity.m_20189_() * (int)offset), (int)((int)minZ), (int)((int)maxZ)));
        return this.getPortalLogic(entity, blockpos).map(portalresult -> {
            Vec3 vector3d;
            Direction.Axis axis;
            BlockState blockstate = entity.m_9236_().m_8055_(entity.f_19819_);
            if (blockstate.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)blockstate.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle result = BlockUtil.m_124334_((BlockPos)entity.f_19819_, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, pos -> entity.m_9236_().m_8055_(pos) == blockstate);
                try {
                    vector3d = (Vec3)m_getRelativePortalPosition.invoke((Object)entity, axis, result);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_257966_((ServerLevel)destWorld, (BlockUtil.FoundRectangle)portalresult, (Direction.Axis)axis, (Vec3)vector3d, (Entity)entity, (Vec3)entity.m_20184_(), (float)entity.m_146908_(), (float)entity.m_146909_());
        }).orElse(null);
    }

    private Optional<BlockUtil.FoundRectangle> getPortalLogic(Entity entity, BlockPos pos) {
        Optional<BlockUtil.FoundRectangle> existing = this.getExistingPortal(pos);
        if (entity instanceof ServerPlayer) {
            if (existing.isPresent()) {
                return existing;
            }
            Direction.Axis axis = entity.m_9236_().m_8055_(entity.f_19819_).m_61145_(CretaceousPortalBlock.AXIS).orElse(Direction.Axis.X);
            Optional<BlockUtil.FoundRectangle> portal = this.makePortal(pos, axis);
            if (!portal.isPresent()) {
                PrehistoricFauna.LOGGER.error("Unable to create a portal, likely target out of worldborder");
            }
            return portal;
        }
        return existing;
    }
}

