/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.items;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Edmontosaurus;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Triceratops;
import superlord.prehistoricfauna.common.entity.cretaceous.hellcreek.Tyrannosaurus;
import superlord.prehistoricfauna.common.entity.cretaceous.yixian.Dongbeititan;
import superlord.prehistoricfauna.common.entity.jurassic.morrison.Camarasaurus;
import superlord.prehistoricfauna.init.PFItems;

public class PFSpawnEggItem
extends SpawnEggItem {
    private static final List<PFSpawnEggItem> MOD_EGGS = new ArrayList<PFSpawnEggItem>();
    private static final Map<EntityType<? extends Mob>, PFSpawnEggItem> TYPE_MAP = new IdentityHashMap<EntityType<? extends Mob>, PFSpawnEggItem>();
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;
    private static final DispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction face = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        try {
            type.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_121945_(face), MobSpawnType.DISPENSER, face != Direction.UP, false);
        }
        catch (Exception exception) {
            DispenseItemBehavior.f_181892_.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.m_7961_(), (Object)exception);
            return ItemStack.f_41583_;
        }
        stack.m_41774_(1);
        source.m_7727_().m_220407_(GameEvent.f_157810_, source.m_7961_(), GameEvent.Context.m_223722_((BlockState)source.m_6414_()));
        return stack;
    };

    public PFSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        super((EntityType)null, backgroundColor, highlightColor, props);
        this.typeSupplier = type;
        MOD_EGGS.add(this);
    }

    public EntityType<?> m_43228_(@Nullable CompoundTag tag) {
        EntityType<? extends Mob> type = super.m_43228_(tag);
        return type != null ? type : this.typeSupplier.get();
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Nullable
    public static SpawnEggItem fromEntityType(@Nullable EntityType<?> type) {
        SpawnEggItem ret = TYPE_MAP.get(type);
        return ret != null ? ret : SpawnEggItem.m_43213_(type);
    }

    protected EntityType<?> getDefaultType() {
        return this.typeSupplier.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (stack.m_41720_() == PFItems.THESCELOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BRACHYCHAMPSA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ACIPENSER_SPAWN_EGG.get() || stack.m_41720_() == PFItems.LONCHIDION_SPAWN_EGG.get() || stack.m_41720_() == PFItems.MELVIUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ANKYLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TRICERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TYRANNOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DIDELPHODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BASILEMYS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DAKOTARAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.MYLEDAPHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.GAR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CYCLURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PALAEOSANIWA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PACHYCEPHALOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ORNITHOMIMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CEPHALOLEICHNITES_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EDMONTOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ANZU_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PARAPSEPHURUS_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"hell_creek").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"cretaceous").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (stack.m_41720_() == PFItems.DRYOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ALLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EILENODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.STEGOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CAMARASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HESPERORNITHOIDES_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CERATOSAURUS_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"morrison").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"jurassic").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (stack.m_41720_() == PFItems.SAUROSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SILLOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EXAERETODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HYPERODAPEDON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ISCHIGUALASTIA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HERRERASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CHROMOGISAURUS_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"ischigualasto").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"triassic").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (stack.m_41720_() == PFItems.CERATODUS_SPAWN_EGG.get()) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344)) {
                tooltip.add((Component)Component.m_237115_((String)"mki").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"jt").m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"egg.hold_shift").m_130940_(ChatFormatting.GRAY));
            }
        } else if (stack.m_41720_() == PFItems.PROTOCERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.VELOCIRAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CITIPATI_SPAWN_EGG.get() || stack.m_41720_() == PFItems.AEPYORNITHOMIMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TELMASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PINACOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PLESIOHADROS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.OVIRAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DERMESTID_BEETLE_SPAWN_EGG.get() || stack.m_41720_() == PFItems.GOBIULUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HARENAICHTHYS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.UDANOCERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HALSZKARAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.GOYOCEPHALE_SPAWN_EGG.get() || stack.m_41720_() == PFItems.KOL_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BYRONOSAURUS_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"djadochta").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"cretaceous").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (stack.m_41720_() == PFItems.DILOPHOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.KAYENTATHERIUM_SPAWN_EGG.get() || stack.m_41720_() == PFItems.MEGAPNOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SARAHSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SCELIDOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SCUTELLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CALSOYASUCHUS_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"kayenta").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"jurassic").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (stack.m_41720_() == PFItems.ARGANODUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CHINLEA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.MOOREODONTUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SAURICHTHYS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TRILOPHOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DESMATOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.POSTOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.COELOPHYSIS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PLACERIAS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.POPOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TYPOTHORAX_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"chinle").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"triassic").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (stack.m_41720_() == PFItems.POTAMOCERATODUS_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"mk").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"jurassic").m_130940_(ChatFormatting.DARK_GRAY));
        } else if (stack.m_41720_() == PFItems.YUTYRANNUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PSITTACOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SINOSAUROPTERYX_SPAWN_EGG.get() || stack.m_41720_() == PFItems.INCISIVOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.APOCLION_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CRETARANEUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PROTOPSEPHURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SINAMIA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.YANOSTEUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BEIPIAOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CHANGYURAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.LIAONINGOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.REPENOMAMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.RUIXINIA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DONGBEITITAN_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DILONG_SPAWN_EGG.get() || stack.m_41720_() == PFItems.LIAONEMOBIUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ZHENYUANLONG_SPAWN_EGG.get() || stack.m_41720_() == PFItems.JINZHOUSAURUS_SPAWN_EGG.get()) {
            tooltip.add((Component)Component.m_237115_((String)"yixian").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"cretaceous").m_130940_(ChatFormatting.DARK_GRAY));
        }
        if ((stack.m_41720_() == PFItems.TYRANNOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ALLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DILOPHOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SAUROSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.POSTOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.POPOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HESPERORNITHOIDES_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HERRERASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DAKOTARAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CERATOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.VELOCIRAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.MEGAPNOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.COELOPHYSIS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PALAEOSANIWA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.YUTYRANNUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SINOSAUROPTERYX_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BYRONOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.REPENOMAMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DILONG_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ZHENYUANLONG_SPAWN_EGG.get()) && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344))) {
            tooltip.add((Component)Component.m_237115_((String)"carnivore").m_130940_(ChatFormatting.RED));
        }
        if ((stack.m_41720_() == PFItems.TRICERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SCUTELLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SCELIDOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.STEGOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.AEPYORNITHOMIMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SARAHSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SILLOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ISCHIGUALASTIA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DESMATOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ANKYLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.THESCELOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BASILEMYS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CAMARASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DRYOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PINACOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PLESIOHADROS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TRILOPHOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.KAYENTATHERIUM_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HYPERODAPEDON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EILENODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PROTOCERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TYPOTHORAX_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PLACERIAS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EXAERETODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.UDANOCERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PACHYCEPHALOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.GOYOCEPHALE_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PSITTACOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EDMONTOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.LIAONINGOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.RUIXINIA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DONGBEITITAN_SPAWN_EGG.get() || stack.m_41720_() == PFItems.JINZHOUSAURUS_SPAWN_EGG.get()) && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344))) {
            tooltip.add((Component)Component.m_237115_((String)"herbivore").m_130940_(ChatFormatting.DARK_GREEN));
        }
        if ((stack.m_41720_() == PFItems.CITIPATI_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CHROMOGISAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.OVIRAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ORNITHOMIMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.INCISIVOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BEIPIAOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ANZU_SPAWN_EGG.get()) && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344))) {
            tooltip.add((Component)Component.m_237115_((String)"omnivore").m_130940_(ChatFormatting.YELLOW));
        }
        if (stack.m_41720_() == PFItems.TELMASAURUS_SPAWN_EGG.get() && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344))) {
            tooltip.add((Component)Component.m_237115_((String)"ovivore").m_130940_(ChatFormatting.WHITE));
        }
        if (stack.m_41720_() == PFItems.DIDELPHODON_SPAWN_EGG.get() && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344))) {
            tooltip.add((Component)Component.m_237115_((String)"molluscivore").m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if ((stack.m_41720_() == PFItems.KOL_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CHANGYURAPTOR_SPAWN_EGG.get()) && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344))) {
            tooltip.add((Component)Component.m_237115_((String)"insectivore").m_130940_(ChatFormatting.GREEN));
        }
        if ((stack.m_41720_() == PFItems.CALSOYASUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BRACHYCHAMPSA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HALSZKARAPTOR_SPAWN_EGG.get()) && (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344))) {
            tooltip.add((Component)Component.m_237115_((String)"piscivore").m_130940_(ChatFormatting.DARK_AQUA));
        }
        if (stack.m_41720_() == PFItems.TYRANNOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SCELIDOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TRICERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ALLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.STEGOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.AEPYORNITHOMIMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DILOPHOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SARAHSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CALSOYASUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SAUROSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SILLOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ISCHIGUALASTIA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CHROMOGISAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.POSTOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.POPOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DESMATOSUCHUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PLACERIAS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.UDANOCERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ORNITHOMIMUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.YUTYRANNUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ANZU_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BRACHYCHAMPSA_SPAWN_EGG.get()) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344)) {
                tooltip.add((Component)Component.m_237115_((String)"cathemeral").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"egg.hold_shift").m_130940_(ChatFormatting.GRAY));
            }
        }
        if (stack.m_41720_() == PFItems.ANKYLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.THESCELOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BASILEMYS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CAMARASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DRYOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HESPERORNITHOIDES_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PINACOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PLESIOHADROS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CITIPATI_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TELMASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HERRERASAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TRILOPHOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.OVIRAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HALSZKARAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PACHYCEPHALOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.GOYOCEPHALE_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PSITTACOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.INCISIVOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EDMONTOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BEIPIAOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.LIAONINGOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.RUIXINIA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DONGBEITITAN_SPAWN_EGG.get() || stack.m_41720_() == PFItems.JINZHOUSAURUS_SPAWN_EGG.get()) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344)) {
                tooltip.add((Component)Component.m_237115_((String)"diurnal").m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"egg.hold_shift").m_130940_(ChatFormatting.GRAY));
            }
        }
        if (stack.m_41720_() == PFItems.DAKOTARAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DIDELPHODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CERATOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.VELOCIRAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.KAYENTATHERIUM_SPAWN_EGG.get() || stack.m_41720_() == PFItems.HYPERODAPEDON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PALAEOSANIWA_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SINOSAUROPTERYX_SPAWN_EGG.get() || stack.m_41720_() == PFItems.CHANGYURAPTOR_SPAWN_EGG.get() || stack.m_41720_() == PFItems.DILONG_SPAWN_EGG.get() || stack.m_41720_() == PFItems.ZHENYUANLONG_SPAWN_EGG.get()) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344)) {
                tooltip.add((Component)Component.m_237115_((String)"crepuscular").m_130940_(ChatFormatting.LIGHT_PURPLE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"egg.hold_shift").m_130940_(ChatFormatting.GRAY));
            }
        }
        if (stack.m_41720_() == PFItems.EILENODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.SCUTELLOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.PROTOCERATOPS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.MEGAPNOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.COELOPHYSIS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.TYPOTHORAX_SPAWN_EGG.get() || stack.m_41720_() == PFItems.EXAERETODON_SPAWN_EGG.get() || stack.m_41720_() == PFItems.KOL_SPAWN_EGG.get() || stack.m_41720_() == PFItems.BYRONOSAURUS_SPAWN_EGG.get() || stack.m_41720_() == PFItems.REPENOMAMUS_SPAWN_EGG.get()) {
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340) || InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)344)) {
                tooltip.add((Component)Component.m_237115_((String)"nocturnal").m_130940_(ChatFormatting.DARK_BLUE));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"egg.hold_shift").m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    public Optional<Mob> m_43215_(Player p_43216_, Mob p_43217_, EntityType<? extends Mob> p_43218_, ServerLevel p_43219_, Vec3 p_43220_, ItemStack p_43221_) {
        if (!this.m_43230_(p_43221_.m_41783_(), p_43218_)) {
            return Optional.empty();
        }
        Object mob = p_43217_ instanceof AgeableMob ? (p_43217_ instanceof Edmontosaurus ? ((Edmontosaurus)p_43217_).m_142606_(p_43219_, (AgeableMob)((Edmontosaurus)p_43217_)) : ((AgeableMob)p_43217_).m_142606_(p_43219_, (AgeableMob)p_43217_)) : (Mob)p_43218_.m_20615_((Level)p_43219_);
        if (mob == null) {
            return Optional.empty();
        }
        mob.m_6863_(true);
        if (mob instanceof Edmontosaurus) {
            ((Edmontosaurus)((Object)mob)).setJuvenile(false);
            ((Edmontosaurus)((Object)mob)).m_146762_(-48000);
        }
        if (mob instanceof Dongbeititan) {
            ((Dongbeititan)((Object)mob)).setJuvenile(false);
            ((Dongbeititan)((Object)mob)).m_146762_(-48000);
        }
        if (mob instanceof Triceratops) {
            ((Triceratops)((Object)mob)).setJuvenile(false);
            ((Triceratops)((Object)mob)).m_146762_(-48000);
        }
        if (mob instanceof Tyrannosaurus) {
            ((Tyrannosaurus)((Object)mob)).setJuvenile(false);
            ((Tyrannosaurus)((Object)mob)).m_146762_(-48000);
        }
        if (mob instanceof Camarasaurus) {
            ((Camarasaurus)((Object)mob)).setJuvenile(false);
            ((Camarasaurus)((Object)mob)).setHatchling(true);
            ((Camarasaurus)((Object)mob)).m_146762_(-72000);
        }
        if (!mob.m_6162_()) {
            return Optional.empty();
        }
        mob.m_7678_(p_43220_.m_7096_(), p_43220_.m_7098_(), p_43220_.m_7094_(), 0.0f, 0.0f);
        p_43219_.m_47205_((Entity)mob);
        if (p_43221_.m_41788_()) {
            mob.m_6593_(p_43221_.m_41786_());
        }
        if (!p_43216_.m_150110_().f_35937_) {
            p_43221_.m_41774_(1);
        }
        return Optional.of(mob);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorRegisterHandler {
        private ColorRegisterHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerSpawnEggColors(RegisterColorHandlersEvent.Item event) {
            MOD_EGGS.forEach(egg -> event.getItemColors().m_92689_((stack, layer) -> egg.m_43211_(layer), new ItemLike[]{egg}));
        }
    }

    @Mod.EventBusSubscriber(modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class CommonHandler {
        private CommonHandler() {
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            MOD_EGGS.forEach(egg -> {
                DispenseItemBehavior dispenseBehavior = egg.createDispenseBehavior();
                if (dispenseBehavior != null) {
                    DispenserBlock.m_52672_((ItemLike)egg, (DispenseItemBehavior)dispenseBehavior);
                }
                TYPE_MAP.put(egg.typeSupplier.get(), (PFSpawnEggItem)((Object)egg));
            });
        }
    }
}

