/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.items;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.RegistryObject;

public class BottledBugItem
extends Item {
    private static final Map<? extends EntityType<?>, BottledBugItem> EGGS = Maps.newIdentityHashMap();
    public static final List<BottledBugItem> UNADDED_EGGS = new ArrayList<BottledBugItem>();
    private final Lazy<? extends EntityType<?>> entityTypeSupplier;

    public BottledBugItem(NonNullSupplier<? extends EntityType<?>> entityTypeSupplier, Item.Properties properties) {
        super(properties);
        this.entityTypeSupplier = Lazy.of(() -> entityTypeSupplier.get());
        UNADDED_EGGS.add(this);
    }

    public BottledBugItem(RegistryObject<? extends EntityType<?>> entityTypeSupplier, Item.Properties properties) {
        super(properties);
        this.entityTypeSupplier = Lazy.of(() -> entityTypeSupplier.get());
        UNADDED_EGGS.add(this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity tileentity;
        Level world = context.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50085_) && (tileentity = world.m_7702_(blockpos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawnerblockentity = (SpawnerBlockEntity)tileentity;
            EntityType<?> entitytype1 = this.getType(itemstack.m_41783_());
            spawnerblockentity.m_252803_(entitytype1, world.m_213780_());
            tileentity.m_6596_();
            world.m_7260_(blockpos, blockstate, blockstate, 3);
            if (!context.m_43723_().m_7500_()) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType<?> entitytype = this.getType(itemstack.m_41783_());
        if (entitytype.m_20592_((ServerLevel)world, itemstack, context.m_43723_(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null && !context.m_43723_().m_7500_()) {
            itemstack.m_41774_(1);
            context.m_43723_().m_21008_(context.m_43724_(), new ItemStack((ItemLike)Items.f_42590_));
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult raytraceresult = BottledBugItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(worldIn instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockHitResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.m_82425_();
        if (!(worldIn.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos, blockraytraceresult.m_82434_(), itemstack)) {
            EntityType<?> entitytype = this.getType(itemstack.m_41783_());
            if (entitytype.m_20592_((ServerLevel)worldIn, itemstack, playerIn, blockpos, MobSpawnType.SPAWN_EGG, false, false) == null) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            if (!playerIn.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            playerIn.m_36356_(new ItemStack((ItemLike)Items.f_42590_));
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public boolean spawnsEntity(@Nullable CompoundTag nbt, EntityType<?> type) {
        return Objects.equals(this.getType(nbt), type);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static BottledBugItem getEgg(@Nullable EntityType<?> type) {
        return EGGS.get(type);
    }

    public static Iterable<BottledBugItem> getEggs() {
        return Iterables.unmodifiableIterable(EGGS.values());
    }

    public EntityType<?> getType(@Nullable CompoundTag nbt) {
        CompoundTag compoundnbt;
        if (nbt != null && nbt.m_128425_("EntityTag", 10) && (compoundnbt = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)compoundnbt.m_128461_("id")).orElse((EntityType)this.entityTypeSupplier.get());
        }
        return (EntityType)this.entityTypeSupplier.get();
    }

    public Optional<Mob> getChildToSpawn(Player player, Mob mob, EntityType<? extends Mob> entityType, ServerLevel world, Vec3 pos, ItemStack stack) {
        if (!this.spawnsEntity(stack.m_41783_(), entityType)) {
            return Optional.empty();
        }
        Object mobentity = mob instanceof AgeableMob ? ((AgeableMob)mob).m_142606_(world, (AgeableMob)mob) : (Mob)entityType.m_20615_((Level)world);
        if (mobentity == null) {
            return Optional.empty();
        }
        mobentity.m_6863_(true);
        if (!mobentity.m_6162_()) {
            return Optional.empty();
        }
        mobentity.m_7678_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0.0f, 0.0f);
        world.m_47205_((Entity)mobentity);
        if (stack.m_41788_()) {
            mobentity.m_6593_(stack.m_41611_());
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return Optional.of(mobentity);
    }
}

