/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.feature.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;

public class PFTreeConfig
implements FeatureConfiguration {
    public static final Codec<PFTreeConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("trunk_provider").orElse((Object)SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_())).forGetter(config -> config.trunkProvider), (App)BlockStateProvider.f_68747_.fieldOf("leaves_provider").orElse((Object)SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_())).forGetter(config -> config.leavesProvider), (App)Codec.INT.fieldOf("min_height").orElse((Object)15).forGetter(config -> config.minHeight), (App)Codec.INT.fieldOf("max_height").orElse((Object)15).forGetter(config -> config.maxHeight)).apply((Applicative)codecRecorder, PFTreeConfig::new));
    private boolean forcedPlacement = false;
    private final BlockStateProvider trunkProvider;
    private final BlockStateProvider leavesProvider;
    private final int minHeight;
    private final int maxHeight;
    private Rotation rotation = Rotation.NONE;
    private Mirror mirror = Mirror.NONE;

    public PFTreeConfig(BlockStateProvider trunkProvider, BlockStateProvider leavesProvider, int minHeight, int maxHeight) {
        this.trunkProvider = trunkProvider;
        this.leavesProvider = leavesProvider;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public void forcePlacement() {
        this.forcedPlacement = true;
    }

    public BlockStateProvider getTrunkProvider() {
        return this.trunkProvider;
    }

    public BlockStateProvider getLeavesProvider() {
        return this.leavesProvider;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getMaxPossibleHeight() {
        int returnValue = this.maxHeight - this.minHeight;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public void setRotationAndMirror(Rotation rotation, Mirror mirror) {
        this.rotation = rotation;
        this.mirror = mirror;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public boolean isPlacementForced() {
        return this.forcedPlacement;
    }

    public static class Builder {
        private BlockStateProvider trunkProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
        private BlockStateProvider leavesProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
        private int minHeight = 15;
        private int maxPossibleHeight = 1;

        public Builder setTrunkBlock(Block block) {
            this.trunkProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setTrunkBlock(BlockState state) {
            this.trunkProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_49999_.m_49966_());
            return this;
        }

        public Builder setLeavesBlock(Block block) {
            this.leavesProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setLeavesBlock(BlockState state) {
            this.leavesProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setLeavesBlock(BlockStateProvider stateProvider) {
            this.leavesProvider = stateProvider != null ? stateProvider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
            return this;
        }

        public Builder setMinHeight(int minHeight) {
            this.minHeight = minHeight;
            return this;
        }

        public Builder setMaxHeight(int maxPossibleHeight) {
            this.maxPossibleHeight = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder copy(PFTreeConfig config) {
            this.trunkProvider = config.trunkProvider;
            this.leavesProvider = config.leavesProvider;
            this.maxPossibleHeight = config.maxHeight;
            this.minHeight = config.minHeight;
            return this;
        }

        public PFTreeConfig build() {
            return new PFTreeConfig(this.trunkProvider, this.leavesProvider, this.minHeight, this.maxPossibleHeight);
        }
    }
}

