/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.feature.trees;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import superlord.prehistoricfauna.common.feature.util.PFTreeConfig;
import superlord.prehistoricfauna.common.util.FastNoise;
import superlord.prehistoricfauna.common.util.FeatureGenUtil;

public abstract class PFAbstractTreeFeature<TC extends PFTreeConfig>
extends Feature<TC> {
    protected static FastNoise fastNoise;
    protected long seed;
    public static final Map<Block, Block> SPREADABLE_TO_NON_SPREADABLE;

    public PFAbstractTreeFeature(Codec<TC> configCodec) {
        super(configCodec);
    }

    public static boolean canLogPlaceHere(LevelSimulatedReader worldReader, BlockPos blockPos) {
        return worldReader.m_7433_(blockPos, state -> state.m_60795_() || state.m_60819_().m_76178_()) || FeatureGenUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherTreeHere(LevelSimulatedReader worldReader, BlockPos pos) {
        return worldReader.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_));
    }

    public boolean isAnotherTreeLikeThisHere(LevelSimulatedReader worldReader, BlockPos pos, Block logBlock, Block leafBlock) {
        return worldReader.m_7433_(pos, state -> {
            Block block = state.m_60734_();
            return block == logBlock || block == leafBlock;
        });
    }

    public void buildTrunkBase(BlockPos centerPos, Set<BlockPos> treeBlocksSet, WorldGenLevel reader, PFTreeConfig config, RandomSource rand, BoundingBox boundingBox, BlockPos ... trunkPositions) {
        if (config.isPlacementForced()) {
            return;
        }
        BlockState ground = reader.m_8055_(centerPos.m_121945_(Direction.DOWN));
        if (SPREADABLE_TO_NON_SPREADABLE.containsKey(ground.m_60734_())) {
            ground = SPREADABLE_TO_NON_SPREADABLE.get(ground.m_60734_()).m_49966_();
        }
        if (trunkPositions.length > 0) {
            BlockPos.MutableBlockPos mutableTrunk = new BlockPos.MutableBlockPos();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.m_122190_((Vec3i)trunkPos);
                for (int fill = 1; fill <= 25; ++fill) {
                    if (PFAbstractTreeFeature.canLogPlaceHere((LevelSimulatedReader)reader, (BlockPos)mutableTrunk)) {
                        if (fill <= 15) {
                            this.setFinalBlockState(treeBlocksSet, (LevelWriter)reader, (BlockPos)mutableTrunk, config.getTrunkProvider().m_213972_(rand, (BlockPos)mutableTrunk), boundingBox);
                        } else {
                            this.setFinalBlockState(treeBlocksSet, (LevelWriter)reader, (BlockPos)mutableTrunk, ground, boundingBox);
                        }
                    } else {
                        fill = 25;
                    }
                    mutableTrunk.m_122173_(Direction.DOWN);
                }
            }
        }
    }

    public void placeTrunk(BlockPos startPos, PFTreeConfig config, RandomSource random, Set<BlockPos> blockSet, WorldGenLevel reader, BlockPos pos, BoundingBox boundingBox) {
        if (PFAbstractTreeFeature.canLogPlaceHere((LevelSimulatedReader)reader, pos = PFAbstractTreeFeature.getTransformedPos(config, startPos, pos))) {
            this.setFinalBlockState(blockSet, (LevelWriter)reader, pos, config.getTrunkProvider().m_213972_(random, pos), boundingBox);
        }
    }

    public void placeBranch(BlockPos startPos, PFTreeConfig config, RandomSource random, Set<BlockPos> blockSet, WorldGenLevel reader, BlockPos pos, BoundingBox boundingBox) {
        if (PFAbstractTreeFeature.canLogPlaceHere((LevelSimulatedReader)reader, pos = PFAbstractTreeFeature.getTransformedPos(config, startPos, pos))) {
            this.setFinalBlockState(blockSet, (LevelWriter)reader, pos, config.getTrunkProvider().m_213972_(random, pos), boundingBox);
        }
    }

    public void placeLeaves(BlockPos startPos, PFTreeConfig config, RandomSource random, Set<BlockPos> blockSet, WorldGenLevel reader, BlockPos pos, BoundingBox boundingBox) {
        if (PFAbstractTreeFeature.isAir((LevelSimulatedReader)reader, pos = PFAbstractTreeFeature.getTransformedPos(config, startPos, pos))) {
            this.setFinalBlockState(blockSet, (LevelWriter)reader, pos, config.getLeavesProvider().m_213972_(random, pos), boundingBox);
        }
    }

    public void placeLeaves(BlockPos startPos, PFTreeConfig config, RandomSource random, WorldGenLevel reader, int x, int y, int z, BoundingBox boundingBox, Set<BlockPos> pos) {
        BlockPos blockPos = new BlockPos(x, y, z);
        if (PFAbstractTreeFeature.isAir((LevelSimulatedReader)reader, blockPos = PFAbstractTreeFeature.getTransformedPos(config, startPos, blockPos))) {
            this.setFinalBlockState(pos, (LevelWriter)reader, blockPos, config.getLeavesProvider().m_213972_(random, blockPos), boundingBox);
        }
    }

    public static BlockPos getTransformedPos(PFTreeConfig config, BlockPos startPos, BlockPos pos) {
        Rotation rotation = config.getRotation();
        Mirror mirror = config.getMirror();
        BlockPos blockPos = FeatureGenUtil.extractOffset(startPos, pos);
        if (blockPos instanceof BlockPos.MutableBlockPos) {
            FeatureGenUtil.transformMutable((BlockPos.MutableBlockPos)blockPos, mirror, rotation);
            ((BlockPos.MutableBlockPos)blockPos).m_122184_(startPos.m_123341_(), 0, startPos.m_123343_());
            return blockPos;
        }
        return FeatureGenUtil.transform(blockPos, mirror, rotation).m_7918_(startPos.m_123341_(), 0, startPos.m_123343_());
    }

    public boolean canSaplingGrowHere(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_) || state.m_60795_() || state.m_204336_(BlockTags.f_278411_));
    }

    public static boolean isAir(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }

    public boolean isAirOrWater(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60795_() || state.m_60734_() == Blocks.f_49990_);
    }

    public boolean doesSaplingHaveSpaceToGrow(LevelSimulatedReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.m_122178_(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.m_122178_(trunkPos.m_123341_(), trunkPos.m_123342_() + yOffSet, trunkPos.m_123343_()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.m_122178_(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesSaplingHaveSpaceToGrow(LevelSimulatedReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xNegativeDistance, int zNegativeDistance, int xPositiveDistance, int zPositiveDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canSaplingGrowHere(reader, (BlockPos)mutable.m_122178_(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canSaplingGrowHere(reader, (BlockPos)mutable.m_122178_(trunkPos.m_123341_(), trunkPos.m_123342_() + yOffSet, trunkPos.m_123343_()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xNegativeDistance; xOffset <= xPositiveDistance; ++xOffset) {
                    for (int zOffset = -zNegativeDistance; zOffset <= zPositiveDistance; ++zOffset) {
                        if (this.canSaplingGrowHere(reader, (BlockPos)mutable.m_122178_(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherTreeNearby(LevelSimulatedReader reader, BlockPos pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherTreeHere(reader, (BlockPos)mutable.m_122178_(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isCliff(LevelSimulatedReader reader, BlockPos ... trunkPositions) {
        return this.isCliff(reader, 5, trunkPositions);
    }

    public boolean isCliff(LevelSimulatedReader reader, int checkDownRange, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (BlockPos trunkPos : trunkPositions) {
                mutable.m_122190_((Vec3i)trunkPos);
                for (int moveDown = 0; moveDown <= checkDownRange && (this.isAirOrWater(reader, (BlockPos)mutable) || FeatureGenUtil.isPlant(reader, (BlockPos)mutable)); ++moveDown) {
                    if (moveDown == checkDownRange) {
                        return true;
                    }
                    mutable.m_122173_(Direction.DOWN);
                }
            }
        }
        return false;
    }

    public void buildTrunk(WorldGenLevel reader, PFTreeConfig config, RandomSource random, BlockPos operatingPos, int downRange) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)operatingPos);
        for (int moveDown = 0; moveDown < downRange; ++moveDown) {
            BlockState movingState = reader.m_8055_((BlockPos)mutable);
            if (SPREADABLE_TO_NON_SPREADABLE.containsKey(movingState.m_60734_())) {
                reader.m_7731_((BlockPos)mutable, SPREADABLE_TO_NON_SPREADABLE.get(movingState.m_60734_()).m_49966_(), 2);
                break;
            }
            if (FeatureGenUtil.isTerrainOrRock((LevelSimulatedReader)reader, (BlockPos)mutable)) break;
            reader.m_7731_((BlockPos)mutable, config.getTrunkProvider().m_213972_(random, (BlockPos)mutable), 2);
            mutable.m_122173_(Direction.DOWN);
        }
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            this.seed = seed;
        }
    }

    public final void setFinalBlockState(Set<BlockPos> changedBlocks, LevelWriter worldIn, BlockPos pos, BlockState blockState, BoundingBox boundingBox) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
        boundingBox.m_162386_(new BoundingBox(pos));
        if (blockState.m_204336_(BlockTags.f_13106_)) {
            changedBlocks.add(pos.m_7949_());
        }
    }

    public void setBlockStateWithoutUpdates(LevelWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        worldWriter.m_7731_(blockPos, blockState, 18);
    }

    public void setBlockStateWithoutUpdates(LevelWriter worldWriter, BlockPos blockPos, BlockState blockState, int flags) {
        worldWriter.m_7731_(blockPos, blockState, flags);
    }

    public boolean m_142674_(FeaturePlaceContext<TC> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_225041_(), featurePlaceContext.m_159777_(), (PFTreeConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel worldIn, ChunkGenerator generator, RandomSource rand, BlockPos pos, TC config) {
        Rotation rotation = Rotation.values()[rand.m_188503_(Rotation.values().length)];
        Mirror mirror = Mirror.values()[rand.m_188503_(Mirror.values().length)];
        ((PFTreeConfig)config).setRotationAndMirror(rotation, mirror);
        return this.placeTree(worldIn, rand, pos, config);
    }

    public boolean placeTree(WorldGenLevel worldIn, RandomSource rand, BlockPos pos, TC config) {
        HashSet set = Sets.newHashSet();
        BoundingBox mutableboundingbox = new BoundingBox(pos);
        boolean flag = this.generate(set, worldIn, rand, pos, mutableboundingbox, false, config);
        if (mutableboundingbox.m_162395_() > mutableboundingbox.m_162399_()) {
            return false;
        }
        ArrayList list = Lists.newArrayList();
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        for (BlockPos blockPos : set) {
            boolean cliff;
            if (blockPos.m_123342_() != pos.m_123342_() || (cliff = this.isCliff((LevelSimulatedReader)worldIn, 9, blockPos)) || FeatureGenUtil.isTerrainOrRock((LevelSimulatedReader)worldIn, blockPos.m_7495_())) continue;
            this.buildTrunk(worldIn, (PFTreeConfig)config, rand, blockPos, 10);
        }
        BitSetDiscreteVoxelShape voxelshapepart = new BitSetDiscreteVoxelShape(mutableboundingbox.m_71056_(), mutableboundingbox.m_71057_(), mutableboundingbox.m_71058_());
        try (PooledMutable posInPool = PooledMutable.get();){
            if (flag && !set.isEmpty()) {
                for (BlockPos blockpos : Lists.newArrayList((Iterable)set)) {
                    if (mutableboundingbox.m_71051_((Vec3i)blockpos)) {
                        voxelshapepart.m_142703_(blockpos.m_123341_() - mutableboundingbox.m_162395_(), blockpos.m_123342_() - mutableboundingbox.m_162396_(), blockpos.m_123343_() - mutableboundingbox.m_162398_());
                    }
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate;
                        posInPool.set((Vec3i)blockpos).m_122173_(direction);
                        if (set.contains(posInPool) || !(blockstate = worldIn.m_8055_((BlockPos)posInPool)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                        ((Set)list.get(0)).add(posInPool.m_7949_());
                        this.setBlockStateWithoutUpdates((LevelWriter)worldIn, (BlockPos)posInPool, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                        if (!mutableboundingbox.m_71051_((Vec3i)posInPool)) continue;
                        voxelshapepart.m_142703_(posInPool.m_123341_() - mutableboundingbox.m_162395_(), posInPool.m_123342_() - mutableboundingbox.m_162396_(), posInPool.m_123343_() - mutableboundingbox.m_162398_());
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (BlockPos blockpos1 : set1) {
                    if (mutableboundingbox.m_71051_((Vec3i)blockpos1)) {
                        voxelshapepart.m_142703_(blockpos1.m_123341_() - mutableboundingbox.m_162395_(), blockpos1.m_123342_() - mutableboundingbox.m_162396_(), blockpos1.m_123343_() - mutableboundingbox.m_162398_());
                    }
                    for (Direction direction1 : Direction.values()) {
                        int newDistance;
                        int currentDistance;
                        BlockState blockstate1;
                        posInPool.set((Vec3i)blockpos1).m_122173_(direction1);
                        if (set1.contains(posInPool) || set2.contains(posInPool) || !(blockstate1 = worldIn.m_8055_((BlockPos)posInPool)).m_61138_((Property)BlockStateProperties.f_61414_) || (currentDistance = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= (newDistance = l + 1)) continue;
                        BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(newDistance));
                        if (newDistance >= 7) {
                            this.setBlockStateWithoutUpdates((LevelWriter)worldIn, (BlockPos)posInPool, Blocks.f_50016_.m_49966_(), 2);
                        } else {
                            this.setBlockStateWithoutUpdates((LevelWriter)worldIn, (BlockPos)posInPool, blockstate2);
                        }
                        if (mutableboundingbox.m_71051_((Vec3i)posInPool)) {
                            voxelshapepart.m_142703_(posInPool.m_123341_() - mutableboundingbox.m_162395_(), posInPool.m_123342_() - mutableboundingbox.m_162396_(), posInPool.m_123343_() - mutableboundingbox.m_162398_());
                        }
                        set2.add(posInPool.m_7949_());
                    }
                }
            }
        }
        StructureTemplate.m_74510_((LevelAccessor)worldIn, (int)3, (DiscreteVoxelShape)voxelshapepart, (int)mutableboundingbox.m_162395_(), (int)mutableboundingbox.m_162396_(), (int)mutableboundingbox.m_162398_());
        return flag;
    }

    protected abstract boolean generate(Set<BlockPos> var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, BoundingBox var5, boolean var6, TC var7);

    static {
        SPREADABLE_TO_NON_SPREADABLE = new HashMap<Block, Block>();
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.f_50440_, Blocks.f_50493_);
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.f_50195_, Blocks.f_50493_);
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.f_152481_, Blocks.f_50493_);
        SPREADABLE_TO_NON_SPREADABLE.put(Blocks.f_50599_, Blocks.f_50493_);
    }

    public static final class PooledMutable
    extends BlockPos.MutableBlockPos
    implements AutoCloseable {
        private boolean free;
        private static final List<PooledMutable> POOL = Lists.newArrayList();

        private PooledMutable(int x, int y, int z) {
            super(x, y, z);
        }

        public static PooledMutable get() {
            return PooledMutable.get(0, 0, 0);
        }

        public static PooledMutable get(double x, double y, double z) {
            return PooledMutable.get(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static PooledMutable get(int x, int y, int z) {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                PooledMutable pooledMutable;
                if (!POOL.isEmpty() && (pooledMutable = POOL.remove(POOL.size() - 1)) != null && pooledMutable.free) {
                    pooledMutable.free = false;
                    pooledMutable.set(x, y, z);
                    return pooledMutable;
                }
            }
            return new PooledMutable(x, y, z);
        }

        public PooledMutable set(int i, int j, int k) {
            return (PooledMutable)super.m_122178_(i, j, k);
        }

        public PooledMutable set(double d, double e, double f) {
            return (PooledMutable)super.m_122169_(d, e, f);
        }

        public PooledMutable set(Vec3i vec3i) {
            return (PooledMutable)super.m_122190_(vec3i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<PooledMutable> list = POOL;
            synchronized (list) {
                if (POOL.size() < 100) {
                    POOL.add(this);
                }
                this.free = true;
            }
        }
    }
}

