/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraftforge.common.Tags;
import superlord.prehistoricfauna.common.feature.util.NoisySphereConfig;
import superlord.prehistoricfauna.common.util.FastNoise;

public class NoisySphereFeature
extends Feature<NoisySphereConfig> {
    protected static FastNoise fastNoise;
    protected long seed;

    public NoisySphereFeature(Codec<NoisySphereConfig> configFactoryIn) {
        super(configFactoryIn);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisySphereConfig> context) {
        BlockPos position = context.m_159777_();
        Random random = new Random();
        WorldGenLevel world = context.m_159774_();
        NoisySphereConfig config = (NoisySphereConfig)context.m_159778_();
        this.setSeed(world.m_7328_());
        if (world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, position.m_123341_(), position.m_123343_()) <= position.m_123342_()) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position.m_6625_(random.nextInt(3)));
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        int stackHeight = random.nextInt(config.getMaxPossibleHeight()) + config.getMinHeight();
        int xRadius = config.getRandomXRadius(random);
        int yRadius = config.getRandomYRadius(random);
        int zRadius = config.getRandomZRadius(random);
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    for (int y = -yRadius; y <= yRadius; ++y) {
                        mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                        ChunkAccess chunk = world.m_46865_((BlockPos)mutable2);
                        double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                        double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_(), mutable2.m_123343_());
                        if (equationResult >= threshold || !world.m_8055_((BlockPos)mutable2).m_204336_(Tags.Blocks.STONE)) continue;
                        world.m_7731_((BlockPos)mutable2, config.getBlockProvider().m_213972_(context.m_225041_(), (BlockPos)mutable2), 2);
                    }
                    xRadius = (int)((double)xRadius / config.getRadiusDivisorPerStack());
                    yRadius = (int)((double)yRadius / config.getRadiusDivisorPerStack());
                    zRadius = (int)((double)zRadius / config.getRadiusDivisorPerStack());
                }
            }
        }
        return true;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || fastNoise == null) {
            fastNoise = new FastNoise((int)seed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            fastNoise.SetFrequency(0.09f);
            this.seed = seed;
        }
    }
}

