/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.events;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="prehistoricfauna", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DimensionSleepEvent {
    private static final Map<Player, Long> playerSleepTimes = new ConcurrentHashMap<Player, Long>();
    private static final long SLEEP_TIME_THRESHOLD = 100L;
    private static final long TIME_TO_SET = 1000L;

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            playerSleepTimes.put(player, level.m_46467_());
        }
    }

    @SubscribeEvent
    public static void onPlayerWake(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (!level.f_46443_ && level instanceof ServerLevel) {
            playerSleepTimes.remove(player);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.END && (server = event.getServer()) != null) {
            for (ServerLevel serverLevel : server.m_129785_()) {
                float sleepPercentage;
                float sleepingPercentage;
                int sleepingPlayers = 0;
                int totalPlayers = 0;
                boolean allPlayersSleptLongEnough = true;
                for (Player player : serverLevel.m_6907_()) {
                    ++totalPlayers;
                    if (player.m_5803_()) {
                        Long sleepStartTime = playerSleepTimes.get(player);
                        if (sleepStartTime != null && serverLevel.m_46467_() - sleepStartTime >= 100L) {
                            ++sleepingPlayers;
                            continue;
                        }
                        allPlayersSleptLongEnough = false;
                        continue;
                    }
                    allPlayersSleptLongEnough = false;
                }
                if (!allPlayersSleptLongEnough || totalPlayers <= 0 || !((sleepingPercentage = (float)sleepingPlayers / (float)totalPlayers * 100.0f) >= (sleepPercentage = (float)serverLevel.m_46469_().m_46215_(GameRules.f_151486_)))) continue;
                for (ServerLevel world : server.m_129785_()) {
                    world.m_8615_(1000L);
                    world.m_8606_(0, 0, false, false);
                }
                playerSleepTimes.clear();
            }
        }
    }
}

