/*
 * Decompiled with CFR 0.152.
 */
package superlord.prehistoricfauna.common.entity.triassic.ischigualasto;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import superlord.prehistoricfauna.common.blocks.DinosaurEggBlock;
import superlord.prehistoricfauna.common.entity.DinosaurEntity;
import superlord.prehistoricfauna.common.entity.goal.AggressiveTempermentAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyCarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.BabyPanicGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreEatFromFeederGoal;
import superlord.prehistoricfauna.common.entity.goal.CarnivoreHuntGoal;
import superlord.prehistoricfauna.common.entity.goal.CathemeralSleepGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurHurtByTargetGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurLookAtGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurMateGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurRandomLookGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurTerritorialAttackGoal;
import superlord.prehistoricfauna.common.entity.goal.DinosaurWaterAvoidingRandomStrollGoal;
import superlord.prehistoricfauna.common.entity.goal.HostileCarnivoreGoal;
import superlord.prehistoricfauna.common.entity.goal.HuntGoal;
import superlord.prehistoricfauna.common.entity.goal.LayEggGoal;
import superlord.prehistoricfauna.common.entity.goal.NaturalMateGoal;
import superlord.prehistoricfauna.common.entity.goal.ProtectBabyGoal;
import superlord.prehistoricfauna.common.entity.goal.UnscheduledSleepingGoal;
import superlord.prehistoricfauna.common.items.PaleopediaItem;
import superlord.prehistoricfauna.common.util.EnumPaleoPages;
import superlord.prehistoricfauna.config.PrehistoricFaunaConfig;
import superlord.prehistoricfauna.init.PFBlocks;
import superlord.prehistoricfauna.init.PFEffects;
import superlord.prehistoricfauna.init.PFEntities;
import superlord.prehistoricfauna.init.PFItems;
import superlord.prehistoricfauna.init.PFSounds;
import superlord.prehistoricfauna.init.PFTags;

public class Saurosuchus
extends DinosaurEntity {
    private static final EntityDataAccessor<Byte> SAUROSUCHUS_FLAGS = SynchedEntityData.m_135353_(Saurosuchus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int maxHunger = 75;
    private int warningSoundTicks;
    private Goal attackAnimals;

    public Saurosuchus(EntityType<? extends Saurosuchus> type, Level levelIn) {
        super(type, levelIn);
        super.m_274367_(1.0f);
        ((DinosaurEntity)this).maxHunger = this.maxHunger;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_6162_()) {
            return 0.625f;
        }
        return 1.25f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == PFItems.RAW_LARGE_SYNAPSID_MEAT.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.attackAnimals = new HuntGoal(this, LivingEntity.class, 10, false, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.SAUROSUCHUS_HUNTING));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new BabyPanicGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new DinosaurHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new ProtectBabyGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DinosaurTerritorialAttackGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new AggressiveTempermentAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new DinosaurMateGoal(this, 1.0));
        this.f_21345_.m_25352_(0, (Goal)new NaturalMateGoal(this, 1.0));
        this.f_21346_.m_25352_(1, this.attackAnimals);
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new DinosaurWaterAvoidingRandomStrollGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SleepGoal());
        this.f_21345_.m_25352_(5, (Goal)new DinosaurLookAtGoal(this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new DinosaurRandomLookGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new HostileCarnivoreGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(0, (Goal)new LayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new UnscheduledSleepingGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new AvoidEntityGoal((PathfinderMob)this, LivingEntity.class, 7.0f, 1.5, 1.75, p_213487_0_ -> p_213487_0_.m_6095_().m_204039_(PFTags.SAUROSUCHUS_AVOIDING)));
        this.f_21345_.m_25352_(1, (Goal)new CathemeralSleepGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new CarnivoreEatFromFeederGoal(this, 1.2f, 12, 2));
        this.f_21346_.m_25352_(0, (Goal)new CarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.SAUROSUCHUS_HUNTING)));
        this.f_21346_.m_25352_(0, (Goal)new BabyCarnivoreHuntGoal(this, LivingEntity.class, 10, 1.75, true, false, p_213487_1_ -> p_213487_1_.m_6095_().m_204039_(PFTags.SAUROSUCHUS_BABY_HUNTING)));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        int temperment = this.f_19796_.m_188503_(100);
        if (temperment < 80) {
            this.setTerritorial(true);
        } else if (temperment >= 80 && temperment < 95) {
            this.setProtective(true);
        } else if (temperment >= 95) {
            this.m_21561_(true);
        }
        this.setCarnivorous(true);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        Item item;
        ItemStack itemstack = p_230254_1_.m_21120_(p_230254_2_);
        if (PrehistoricFaunaConfig.advancedHunger) {
            int hunger = this.getCurrentHunger();
            if (hunger < this.maxHunger) {
                if (!(!this.m_6898_(itemstack) || this.m_27593_() && this.isInLoveNaturally())) {
                    this.m_27595_(p_230254_1_);
                    itemstack.m_41774_(1);
                } else {
                    if (itemstack.m_204117_(PFTags.MEATS_2_HUNGER)) {
                        if (hunger + 2 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 2);
                        }
                        itemstack.m_41774_(1);
                    }
                    if (itemstack.m_204117_(PFTags.MEATS_4_HUNGER)) {
                        if (hunger + 4 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 4);
                        }
                        itemstack.m_41774_(1);
                    }
                    if (itemstack.m_204117_(PFTags.MEATS_6_HUNGER)) {
                        if (hunger + 6 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 6);
                        }
                        itemstack.m_41774_(1);
                    }
                    if (itemstack.m_204117_(PFTags.MEATS_8_HUNGER)) {
                        if (hunger + 8 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 8);
                        }
                        itemstack.m_41774_(1);
                    }
                    if (itemstack.m_204117_(PFTags.MEATS_10_HUNGER)) {
                        if (hunger + 10 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 10);
                        }
                        itemstack.m_41774_(1);
                    }
                    if (itemstack.m_204117_(PFTags.MEATS_12_HUNGER)) {
                        if (hunger + 12 >= this.maxHunger) {
                            this.setHunger(this.maxHunger);
                        } else {
                            this.setHunger(hunger + 12);
                        }
                        itemstack.m_41774_(1);
                    }
                }
            }
            if (itemstack.m_204117_(PFTags.MEATS_2_HUNGER) || itemstack.m_204117_(PFTags.MEATS_4_HUNGER) || itemstack.m_204117_(PFTags.MEATS_6_HUNGER) || itemstack.m_204117_(PFTags.MEATS_8_HUNGER) || itemstack.m_204117_(PFTags.MEATS_10_HUNGER) || itemstack.m_204117_(PFTags.MEATS_12_HUNGER)) {
                p_230254_1_.m_5661_((Component)Component.m_237115_((String)"entity.prehistoricfauna.fullHunger"), true);
            }
        }
        if ((item = itemstack.m_41720_()) instanceof PaleopediaItem && !itemstack.m_41783_().m_128425_("Pages", EnumPaleoPages.SAUROSUCHUS.ordinal())) {
            EnumPaleoPages.addPage(EnumPaleoPages.fromInt(EnumPaleoPages.SAUROSUCHUS.ordinal()), itemstack);
            p_230254_1_.m_5661_((Component)Component.m_237115_((String)"paleopedia.saurosuchus_added"), true);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    public void m_146762_(int age) {
        super.m_146762_(age);
        if (this.m_146764_() >= -24000 && this.m_146764_() < 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(15.0);
        } else if (this.m_146764_() >= 0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22278_, 0.1);
    }

    protected SoundEvent m_7515_() {
        return this.isAsleep() ? null : (SoundEvent)PFSounds.SAUROSUCHUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)PFSounds.SAUROSUCHUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)PFSounds.SAUROSUCHUS_DEATH.get();
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.m_5496_((SoundEvent)PFSounds.SAUROSUCHUS_WARN.get(), 1.0f, this.m_6100_());
            this.warningSoundTicks = 40;
        }
    }

    public boolean m_5803_() {
        return this.getSaurosuchusFlag(32);
    }

    public void setSleeping(boolean p_213485_1_) {
        this.setSaurosuchusFlag(32, p_213485_1_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SAUROSUCHUS_FLAGS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsSleeping", this.m_5803_());
        compound.m_128379_("IsCrouching", this.m_6047_());
    }

    private void setSaurosuchusFlag(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.f_19804_.m_135381_(SAUROSUCHUS_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(SAUROSUCHUS_FLAGS) | p_213505_1_)));
        } else {
            this.f_19804_.m_135381_(SAUROSUCHUS_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(SAUROSUCHUS_FLAGS) & ~p_213505_1_)));
        }
    }

    private boolean getSaurosuchusFlag(int p_213507_1_) {
        return ((Byte)this.f_19804_.m_135370_(SAUROSUCHUS_FLAGS) & p_213507_1_) != 0;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleeping(compound.m_128471_("IsSleeping"));
    }

    @Override
    public boolean onAttackAnimationFinish(Entity entityIn) {
        boolean flag = super.onAttackAnimationFinish(entityIn);
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
            ((LivingEntity)entityIn).m_7292_(new MobEffectInstance((MobEffect)PFEffects.BLEEDING.get(), 300, 0, true, false));
        }
        return flag;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel p_241840_1_, AgeableMob p_241840_2_) {
        Saurosuchus entity = new Saurosuchus((EntityType<? extends Saurosuchus>)((EntityType)PFEntities.SAUROSUCHUS.get()), this.m_9236_());
        entity.m_6518_((ServerLevelAccessor)p_241840_1_, this.m_9236_().m_6436_(new BlockPos(entity.m_146903_(), entity.m_146904_(), entity.m_146907_())), MobSpawnType.BREEDING, null, null);
        return entity;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)PFItems.SAUROSUCHUS_SPAWN_EGG.get());
    }

    @Override
    public Item getEggItem() {
        return (Item)PFItems.SAUROSUCHUS_EGG.get();
    }

    @Override
    public BlockState getEggBlock(Level world, BlockPos pos) {
        return (BlockState)((Block)PFBlocks.SAUROSUCHUS_EGG.get()).m_49966_().m_61124_((Property)DinosaurEggBlock.EGGS, (Comparable)Integer.valueOf(this.f_19796_.m_188503_(4) + 1));
    }

    class MeleeAttackGoal
    extends net.minecraft.world.entity.ai.goal.MeleeAttackGoal {
        public MeleeAttackGoal() {
            super((PathfinderMob)Saurosuchus.this, 1.25, true);
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.m_6639_(enemy);
            if (distToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                Saurosuchus.this.m_5496_((SoundEvent)PFSounds.SAUROSUCHUS_BITE.get(), 1.0f, Saurosuchus.this.m_6100_());
                this.f_25540_.m_7327_((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    Saurosuchus.this.playWarningSound();
                }
            } else {
                this.m_25563_();
            }
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 6.0f + attackTarget.m_20205_();
        }
    }

    class SleepGoal
    extends BaseGoal {
        private int field_220825_c;

        public SleepGoal() {
            this.field_220825_c = Saurosuchus.this.f_19796_.m_188503_(140);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (Saurosuchus.this.f_20900_ == 0.0f && Saurosuchus.this.f_20901_ == 0.0f && Saurosuchus.this.f_20902_ == 0.0f && !PrehistoricFaunaConfig.sleeping) {
                return this.func_220823_j() || Saurosuchus.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.func_220823_j();
        }

        private boolean func_220823_j() {
            if (this.field_220825_c > 0) {
                --this.field_220825_c;
                return false;
            }
            return Saurosuchus.this.m_9236_().m_46461_() && this.func_220813_g() && !this.func_220814_h();
        }

        public void m_8041_() {
            this.field_220825_c = Saurosuchus.this.f_19796_.m_188503_(140);
            Saurosuchus.this.setSleeping(false);
        }

        public void m_8056_() {
            Saurosuchus.this.m_6862_(false);
            Saurosuchus.this.setSleeping(true);
            Saurosuchus.this.m_21573_().m_26573_();
            Saurosuchus.this.m_21566_().m_6849_(Saurosuchus.this.m_20185_(), Saurosuchus.this.m_20186_(), Saurosuchus.this.m_20189_(), 0.0);
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof Saurosuchus) {
                return false;
            }
            if (!(p_test_1_ instanceof Chicken || p_test_1_ instanceof Rabbit || p_test_1_ instanceof Monster)) {
                if (p_test_1_ instanceof TamableAnimal) {
                    return !((TamableAnimal)p_test_1_).m_21824_();
                }
                if (!(p_test_1_ instanceof Player) || !p_test_1_.m_5833_() && !((Player)p_test_1_).m_7500_()) {
                    return !p_test_1_.m_5803_() && !p_test_1_.m_20163_();
                }
                return false;
            }
            return true;
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final TargetingConditions field_220816_b;

        private BaseGoal() {
            this.field_220816_b = TargetingConditions.m_148352_().m_26883_(12.0).m_148355_().m_26888_((Predicate)new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = Saurosuchus.this.m_20183_();
            return !Saurosuchus.this.m_9236_().m_45527_(blockpos) && Saurosuchus.this.m_21692_(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !Saurosuchus.this.m_9236_().m_45971_(LivingEntity.class, this.field_220816_b, (LivingEntity)Saurosuchus.this, Saurosuchus.this.m_20191_().m_82377_(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

